module.exports = [
"[project]/node_modules/@genkit-ai/google-genai/lib/common/types.js [app-rsc] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var types_exports = {};
__export(types_exports, {
    BlockReason: ()=>BlockReason,
    DynamicRetrievalMode: ()=>DynamicRetrievalMode,
    ExecutableCodeLanguage: ()=>ExecutableCodeLanguage,
    FinishReason: ()=>FinishReason,
    FunctionCallingMode: ()=>FunctionCallingMode,
    HarmBlockThreshold: ()=>HarmBlockThreshold,
    HarmCategory: ()=>HarmCategory,
    HarmProbability: ()=>HarmProbability,
    HarmSeverity: ()=>HarmSeverity,
    Outcome: ()=>Outcome,
    SchemaType: ()=>SchemaType,
    TaskTypeSchema: ()=>TaskTypeSchema,
    isCodeExecutionTool: ()=>isCodeExecutionTool,
    isFunctionDeclarationsTool: ()=>isFunctionDeclarationsTool,
    isGoogleSearchRetrievalTool: ()=>isGoogleSearchRetrievalTool,
    isObject: ()=>isObject,
    isRetrievalTool: ()=>isRetrievalTool
});
module.exports = __toCommonJS(types_exports);
var import_genkit = __turbopack_context__.r("[project]/node_modules/genkit/lib/index.js [app-rsc] (ecmascript)");
var FunctionCallingMode = /* @__PURE__ */ ((FunctionCallingMode2)=>{
    FunctionCallingMode2["MODE_UNSPECIFIED"] = "MODE_UNSPECIFIED";
    FunctionCallingMode2["AUTO"] = "AUTO";
    FunctionCallingMode2["ANY"] = "ANY";
    FunctionCallingMode2["NONE"] = "NONE";
    return FunctionCallingMode2;
})(FunctionCallingMode || {});
function isObject(value) {
    return typeof value === "object" && value !== null;
}
var BlockReason = /* @__PURE__ */ ((BlockReason2)=>{
    BlockReason2["BLOCKED_REASON_UNSPECIFIED"] = "BLOCKED_REASON_UNSPECIFIED";
    BlockReason2["BLOCK_REASON_UNSPECIFIED"] = "BLOCK_REASON_UNSPECIFIED";
    BlockReason2["SAFETY"] = "SAFETY";
    BlockReason2["OTHER"] = "OTHER";
    BlockReason2["BLOCKLIST"] = "BLOCKLIST";
    BlockReason2["PROHIBITED_CONTENT"] = "PROHIBITED_CONTENT";
    return BlockReason2;
})(BlockReason || {});
var HarmCategory = /* @__PURE__ */ ((HarmCategory2)=>{
    HarmCategory2["HARM_CATEGORY_UNSPECIFIED"] = "HARM_CATEGORY_UNSPECIFIED";
    HarmCategory2["HARM_CATEGORY_HATE_SPEECH"] = "HARM_CATEGORY_HATE_SPEECH";
    HarmCategory2["HARM_CATEGORY_SEXUALLY_EXPLICIT"] = "HARM_CATEGORY_SEXUALLY_EXPLICIT";
    HarmCategory2["HARM_CATEGORY_HARASSMENT"] = "HARM_CATEGORY_HARASSMENT";
    HarmCategory2["HARM_CATEGORY_DANGEROUS_CONTENT"] = "HARM_CATEGORY_DANGEROUS_CONTENT";
    HarmCategory2["HARM_CATEGORY_CIVIC_INTEGRITY"] = "HARM_CATEGORY_CIVIC_INTEGRITY";
    return HarmCategory2;
})(HarmCategory || {});
var HarmBlockThreshold = /* @__PURE__ */ ((HarmBlockThreshold2)=>{
    HarmBlockThreshold2["HARM_BLOCK_THRESHOLD_UNSPECIFIED"] = "HARM_BLOCK_THRESHOLD_UNSPECIFIED";
    HarmBlockThreshold2["BLOCK_LOW_AND_ABOVE"] = "BLOCK_LOW_AND_ABOVE";
    HarmBlockThreshold2["BLOCK_MEDIUM_AND_ABOVE"] = "BLOCK_MEDIUM_AND_ABOVE";
    HarmBlockThreshold2["BLOCK_ONLY_HIGH"] = "BLOCK_ONLY_HIGH";
    HarmBlockThreshold2["BLOCK_NONE"] = "BLOCK_NONE";
    HarmBlockThreshold2["OFF"] = "OFF";
    return HarmBlockThreshold2;
})(HarmBlockThreshold || {});
var HarmProbability = /* @__PURE__ */ ((HarmProbability2)=>{
    HarmProbability2["HARM_PROBABILITY_UNSPECIFIED"] = "HARM_PROBABILITY_UNSPECIFIED";
    HarmProbability2["NEGLIGIBLE"] = "NEGLIGIBLE";
    HarmProbability2["LOW"] = "LOW";
    HarmProbability2["MEDIUM"] = "MEDIUM";
    HarmProbability2["HIGH"] = "HIGH";
    return HarmProbability2;
})(HarmProbability || {});
var DynamicRetrievalMode = /* @__PURE__ */ ((DynamicRetrievalMode2)=>{
    DynamicRetrievalMode2["MODE_UNSPECIFIED"] = "MODE_UNSPECIFIED";
    DynamicRetrievalMode2["MODE_DYNAMIC"] = "MODE_DYNAMIC";
    return DynamicRetrievalMode2;
})(DynamicRetrievalMode || {});
function isGoogleSearchRetrievalTool(tool) {
    return tool.googleSearchRetrieval !== void 0 || tool.googleSearch !== void 0;
}
var HarmSeverity = /* @__PURE__ */ ((HarmSeverity2)=>{
    HarmSeverity2["HARM_SEVERITY_UNSPECIFIED"] = "HARM_SEVERITY_UNSPECIFIED";
    HarmSeverity2["HARM_SEVERITY_NEGLIGIBLE"] = "HARM_SEVERITY_NEGLIGIBLE";
    HarmSeverity2["HARM_SEVERITY_LOW"] = "HARM_SEVERITY_LOW";
    HarmSeverity2["HARM_SEVERITY_MEDIUM"] = "HARM_SEVERITY_MEDIUM";
    HarmSeverity2["HARM_SEVERITY_HIGH"] = "HARM_SEVERITY_HIGH";
    return HarmSeverity2;
})(HarmSeverity || {});
var SchemaType = /* @__PURE__ */ ((SchemaType2)=>{
    SchemaType2["STRING"] = "STRING";
    SchemaType2["NUMBER"] = "NUMBER";
    SchemaType2["INTEGER"] = "INTEGER";
    SchemaType2["BOOLEAN"] = "BOOLEAN";
    SchemaType2["ARRAY"] = "ARRAY";
    SchemaType2["OBJECT"] = "OBJECT";
    return SchemaType2;
})(SchemaType || {});
const TaskTypeSchema = import_genkit.z.enum([
    "RETRIEVAL_DOCUMENT",
    "RETRIEVAL_QUERY",
    "SEMANTIC_SIMILARITY",
    "CLASSIFICATION",
    "CLUSTERING"
]);
var FinishReason = /* @__PURE__ */ ((FinishReason2)=>{
    FinishReason2["FINISH_REASON_UNSPECIFIED"] = "FINISH_REASON_UNSPECIFIED";
    FinishReason2["STOP"] = "STOP";
    FinishReason2["MAX_TOKENS"] = "MAX_TOKENS";
    FinishReason2["SAFETY"] = "SAFETY";
    FinishReason2["RECITATION"] = "RECITATION";
    FinishReason2["LANGUAGE"] = "LANGUAGE";
    FinishReason2["BLOCKLIST"] = "BLOCKLIST";
    FinishReason2["PROHIBITED_CONTENT"] = "PROHIBITED_CONTENT";
    FinishReason2["SPII"] = "SPII";
    FinishReason2["MALFORMED_FUNCTION_CALL"] = "MALFORMED_FUNCTION_CALL";
    FinishReason2["OTHER"] = "OTHER";
    return FinishReason2;
})(FinishReason || {});
var ExecutableCodeLanguage = /* @__PURE__ */ ((ExecutableCodeLanguage2)=>{
    ExecutableCodeLanguage2["LANGUAGE_UNSPECIFIED"] = "LANGUAGE_UNSPECIFIED";
    ExecutableCodeLanguage2["PYTHON"] = "PYTHON";
    return ExecutableCodeLanguage2;
})(ExecutableCodeLanguage || {});
var Outcome = /* @__PURE__ */ ((Outcome2)=>{
    Outcome2["OUTCOME_UNSPECIFIED"] = "OUTCOME_UNSPECIFIED";
    Outcome2["OUTCOME_OK"] = "OUTCOME_OK";
    Outcome2["OUTCOME_FAILED"] = "OUTCOME_FAILED";
    Outcome2["OUTCOME_DEADLINE_EXCEEDED"] = "OUTCOME_DEADLINE_EXCEEDED";
    return Outcome2;
})(Outcome || {});
function isFunctionDeclarationsTool(tool) {
    return tool.functionDeclarations !== void 0;
}
function isCodeExecutionTool(tool) {
    return tool.codeExecution !== void 0;
}
function isRetrievalTool(tool) {
    return tool.retrieval !== void 0;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    BlockReason,
    DynamicRetrievalMode,
    ExecutableCodeLanguage,
    FinishReason,
    FunctionCallingMode,
    HarmBlockThreshold,
    HarmCategory,
    HarmProbability,
    HarmSeverity,
    Outcome,
    SchemaType,
    TaskTypeSchema,
    isCodeExecutionTool,
    isFunctionDeclarationsTool,
    isGoogleSearchRetrievalTool,
    isObject,
    isRetrievalTool
}); //# sourceMappingURL=types.js.map
}),
"[project]/node_modules/@genkit-ai/google-genai/lib/common/utils.js [app-rsc] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var utils_exports = {};
__export(utils_exports, {
    checkModelName: ()=>checkModelName,
    checkSupportedMimeType: ()=>checkSupportedMimeType,
    cleanSchema: ()=>cleanSchema,
    displayUrl: ()=>displayUrl,
    extractErrMsg: ()=>extractErrMsg,
    extractMedia: ()=>extractMedia,
    extractMimeType: ()=>extractMimeType,
    extractText: ()=>extractText,
    extractVersion: ()=>extractVersion,
    getGenkitClientHeader: ()=>getGenkitClientHeader,
    modelName: ()=>modelName,
    processStream: ()=>processStream
});
module.exports = __toCommonJS(utils_exports);
var import_genkit = __turbopack_context__.r("[project]/node_modules/genkit/lib/index.js [app-rsc] (ecmascript)");
var import_types = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/common/types.js [app-rsc] (ecmascript)");
function extractErrMsg(e) {
    let errorMessage = "An unknown error occurred";
    if (e instanceof Error) {
        errorMessage = e.message;
    } else if (typeof e === "string") {
        errorMessage = e;
    } else {
        try {
            errorMessage = JSON.stringify(e);
        } catch (stringifyError) {
            errorMessage = "Failed to stringify error object";
        }
    }
    return errorMessage;
}
function extractVersion(model) {
    return model.version ? model.version : checkModelName(model.name);
}
function modelName(name) {
    if (!name) return name;
    const prefixesToRemove = /background-model\/|model\/|models\/|embedders\/|googleai\/|vertexai\//g;
    return name.replace(prefixesToRemove, "");
}
function checkModelName(name) {
    const version = modelName(name);
    if (!version) {
        throw new import_genkit.GenkitError({
            status: "INVALID_ARGUMENT",
            message: "Model name is required."
        });
    }
    return version;
}
function extractText(request) {
    return request.messages.at(-1)?.content.map((c)=>c.text || "").join("") ?? "";
}
const KNOWN_MIME_TYPES = {
    jpg: "image/jpeg",
    jpeg: "image/jpeg",
    png: "image/png",
    mp4: "video/mp4",
    pdf: "application/pdf"
};
function extractMimeType(url) {
    if (!url) {
        return "";
    }
    const dataPrefix = "data:";
    if (!url.startsWith(dataPrefix)) {
        url.lastIndexOf(".");
        const key = url.substring(url.lastIndexOf(".") + 1);
        if (Object.keys(KNOWN_MIME_TYPES).includes(key)) {
            return KNOWN_MIME_TYPES[key];
        }
        return "";
    }
    const commaIndex = url.indexOf(",");
    if (commaIndex == -1) {
        return "";
    }
    let mimeType = url.substring(dataPrefix.length, commaIndex);
    const base64Marker = ";base64";
    if (mimeType.endsWith(base64Marker)) {
        mimeType = mimeType.substring(0, mimeType.length - base64Marker.length);
    }
    return mimeType.trim();
}
function checkSupportedMimeType(media, supportedTypes) {
    if (!supportedTypes.includes(media.contentType ?? "")) {
        throw new import_genkit.GenkitError({
            status: "INVALID_ARGUMENT",
            message: `Invalid mimeType for ${displayUrl(media.url)}: "${media.contentType}". Supported mimeTypes: ${supportedTypes.join(", ")}`
        });
    }
}
function displayUrl(url) {
    if (url.length <= 50) {
        return url;
    }
    return url.substring(0, 25) + "..." + url.substring(url.length - 25);
}
function extractMedia(request, params) {
    const predicate = (part)=>{
        const media2 = part.media;
        if (!media2) {
            return false;
        }
        if (params.metadataType || params.isDefault) {
            const metadata = part.metadata;
            if (!metadata?.type) {
                return !!params.isDefault;
            } else {
                return metadata.type == params.metadataType;
            }
        }
        return true;
    };
    const media = request.messages.at(-1)?.content.find(predicate)?.media;
    if (media && !media?.contentType) {
        return {
            url: media.url,
            contentType: extractMimeType(media.url)
        };
    }
    return media;
}
function cleanSchema(schema) {
    const out = structuredClone(schema);
    for(const key in out){
        if (key === "$schema" || key === "additionalProperties") {
            delete out[key];
            continue;
        }
        if (typeof out[key] === "object") {
            out[key] = cleanSchema(out[key]);
        }
        if (key === "type" && Array.isArray(out[key])) {
            out[key] = out[key].find((t)=>t !== "null");
        }
    }
    return out;
}
function processStream(response) {
    if (!response.body) {
        throw new Error("Error processing stream because response.body not found");
    }
    const inputStream = response.body.pipeThrough(new TextDecoderStream("utf8", {
        fatal: true
    }));
    const responseStream = getResponseStream(inputStream);
    const [stream1, stream2] = responseStream.tee();
    return {
        stream: generateResponseSequence(stream1),
        response: getResponsePromise(stream2)
    };
}
function getResponseStream(inputStream) {
    const responseLineRE = /^data: (.*)(?:\n\n|\r\r|\r\n\r\n)/;
    const reader = inputStream.getReader();
    const stream = new ReadableStream({
        start (controller) {
            let currentText = "";
            return pump();
            //TURBOPACK unreachable
            ;
            function pump() {
                return reader.read().then(({ value, done })=>{
                    if (done) {
                        if (currentText.trim()) {
                            controller.error(new Error("Failed to parse stream"));
                            return;
                        }
                        controller.close();
                        return;
                    }
                    currentText += value;
                    let match = currentText.match(responseLineRE);
                    let parsedResponse;
                    while(match){
                        try {
                            parsedResponse = JSON.parse(match[1]);
                        } catch (e) {
                            controller.error(new Error(`Error parsing JSON response: "${match[1]}"`));
                            return;
                        }
                        controller.enqueue(parsedResponse);
                        currentText = currentText.substring(match[0].length);
                        match = currentText.match(responseLineRE);
                    }
                    return pump();
                }).catch((e)=>{
                    let err = e;
                    err.stack = e.stack;
                    if (err.name === "AbortError") {
                        err = new import_genkit.GenkitError({
                            status: "ABORTED",
                            message: "Request aborted when reading from the stream"
                        });
                    } else {
                        err = new Error("Error reading from the stream");
                    }
                    throw err;
                });
            }
        }
    });
    return stream;
}
async function* generateResponseSequence(stream) {
    const reader = stream.getReader();
    while(true){
        const { value, done } = await reader.read();
        if (done) {
            break;
        }
        yield value;
    }
}
async function getResponsePromise(stream) {
    const allResponses = [];
    const reader = stream.getReader();
    while(true){
        const { done, value } = await reader.read();
        if (done) {
            return aggregateResponses(allResponses);
        }
        allResponses.push(value);
    }
}
function aggregateResponses(responses) {
    const lastResponse = responses.at(-1);
    if (lastResponse === void 0) {
        throw new Error("Error aggregating stream chunks because the final response in stream chunk is undefined");
    }
    const aggregatedResponse = {};
    if (lastResponse.promptFeedback) {
        aggregatedResponse.promptFeedback = lastResponse.promptFeedback;
    }
    for (const response of responses){
        for (const candidate of response.candidates ?? []){
            const index = candidate.index ?? 0;
            if (!aggregatedResponse.candidates) {
                aggregatedResponse.candidates = [];
            }
            if (!aggregatedResponse.candidates[index]) {
                aggregatedResponse.candidates[index] = {
                    index
                };
            }
            const aggregatedCandidate = aggregatedResponse.candidates[index];
            aggregateMetadata(aggregatedCandidate, candidate, "citationMetadata");
            aggregateMetadata(aggregatedCandidate, candidate, "groundingMetadata");
            if (candidate.safetyRatings?.length) {
                aggregatedCandidate.safetyRatings = (aggregatedCandidate.safetyRatings ?? []).concat(candidate.safetyRatings);
            }
            if (candidate.finishReason !== void 0) {
                aggregatedCandidate.finishReason = candidate.finishReason;
            }
            if (candidate.finishMessage !== void 0) {
                aggregatedCandidate.finishMessage = candidate.finishMessage;
            }
            if (candidate.avgLogprobs !== void 0) {
                aggregatedCandidate.avgLogprobs = candidate.avgLogprobs;
            }
            if (candidate.logprobsResult !== void 0) {
                aggregatedCandidate.logprobsResult = candidate.logprobsResult;
            }
            if (candidate.content && candidate.content.parts) {
                if (!aggregatedCandidate.content) {
                    aggregatedCandidate.content = {
                        role: candidate.content.role || "user",
                        parts: []
                    };
                }
                for (const part of candidate.content.parts){
                    const newPart = {};
                    if (part.thought) {
                        newPart.thought = part.thought;
                    }
                    if (part.text) {
                        newPart.text = part.text;
                    }
                    if (part.functionCall) {
                        newPart.functionCall = part.functionCall;
                    }
                    if (part.executableCode) {
                        newPart.executableCode = part.executableCode;
                    }
                    if (part.codeExecutionResult) {
                        newPart.codeExecutionResult = part.codeExecutionResult;
                    }
                    if (Object.keys(newPart).length === 0) {
                        newPart.text = "";
                    }
                    aggregatedCandidate.content.parts.push(newPart);
                }
            }
        }
        if (response.usageMetadata) {
            aggregatedResponse.usageMetadata = response.usageMetadata;
        }
    }
    return aggregatedResponse;
}
function aggregateMetadata(aggCandidate, chunkCandidate, fieldName) {
    const chunkObj = chunkCandidate[fieldName];
    const aggObj = aggCandidate[fieldName];
    if (chunkObj === void 0) return;
    if (aggObj === void 0) {
        aggCandidate[fieldName] = chunkObj;
        return;
    }
    if ((0, import_types.isObject)(chunkObj)) {
        for (const k of Object.keys(chunkObj)){
            if (Array.isArray(aggObj[k]) && Array.isArray(chunkObj[k])) {
                aggObj[k] = aggObj[k].concat(chunkObj[k]);
            } else {
                aggObj[k] = chunkObj[k] ?? aggObj[k];
            }
        }
    }
}
function getGenkitClientHeader() {
    if (process.env.MONOSPACE_ENV == "true") {
        return (0, import_genkit.getClientHeader)() + " firebase-studio-vm";
    }
    return (0, import_genkit.getClientHeader)();
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    checkModelName,
    checkSupportedMimeType,
    cleanSchema,
    displayUrl,
    extractErrMsg,
    extractMedia,
    extractMimeType,
    extractText,
    extractVersion,
    getGenkitClientHeader,
    modelName,
    processStream
}); //# sourceMappingURL=utils.js.map
}),
"[project]/node_modules/@genkit-ai/google-genai/lib/googleai/client.js [app-rsc] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var client_exports = {};
__export(client_exports, {
    TEST_ONLY: ()=>TEST_ONLY,
    embedContent: ()=>embedContent,
    generateContent: ()=>generateContent,
    generateContentStream: ()=>generateContentStream,
    getGoogleAIUrl: ()=>getGoogleAIUrl,
    imagenPredict: ()=>imagenPredict,
    listModels: ()=>listModels,
    veoCheckOperation: ()=>veoCheckOperation,
    veoPredict: ()=>veoPredict
});
module.exports = __toCommonJS(client_exports);
var import_utils = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/common/utils.js [app-rsc] (ecmascript)");
async function listModels(apiKey, clientOptions) {
    const url = getGoogleAIUrl({
        resourcePath: "models",
        queryParams: "pageSize=1000",
        clientOptions
    });
    const fetchOptions = getFetchOptions({
        method: "GET",
        apiKey,
        clientOptions
    });
    const response = await makeRequest(url, fetchOptions);
    const modelResponse = JSON.parse(await response.text());
    return modelResponse.models;
}
async function generateContent(apiKey, model, generateContentRequest, clientOptions) {
    const url = getGoogleAIUrl({
        resourcePath: `models/${model}`,
        resourceMethod: "generateContent",
        clientOptions
    });
    const fetchOptions = getFetchOptions({
        method: "POST",
        apiKey,
        clientOptions,
        body: JSON.stringify(generateContentRequest)
    });
    const response = await makeRequest(url, fetchOptions);
    const responseJson = await response.json();
    return responseJson;
}
async function generateContentStream(apiKey, model, generateContentRequest, clientOptions) {
    const url = getGoogleAIUrl({
        resourcePath: `models/${model}`,
        resourceMethod: "streamGenerateContent",
        clientOptions
    });
    const fetchOptions = getFetchOptions({
        method: "POST",
        apiKey,
        clientOptions,
        body: JSON.stringify(generateContentRequest)
    });
    const response = await makeRequest(url, fetchOptions);
    return (0, import_utils.processStream)(response);
}
async function embedContent(apiKey, model, embedContentRequest, clientOptions) {
    const url = getGoogleAIUrl({
        resourcePath: `models/${model}`,
        resourceMethod: "embedContent",
        clientOptions
    });
    const fetchOptions = getFetchOptions({
        method: "POST",
        apiKey,
        clientOptions,
        body: JSON.stringify(embedContentRequest)
    });
    const response = await makeRequest(url, fetchOptions);
    return response.json();
}
async function imagenPredict(apiKey, model, imagenPredictRequest, clientOptions) {
    const url = getGoogleAIUrl({
        resourcePath: `models/${model}`,
        resourceMethod: "predict",
        clientOptions
    });
    const fetchOptions = getFetchOptions({
        method: "POST",
        apiKey,
        clientOptions,
        body: JSON.stringify(imagenPredictRequest)
    });
    const response = await makeRequest(url, fetchOptions);
    return response.json();
}
async function veoPredict(apiKey, model, veoPredictRequest, clientOptions) {
    const url = getGoogleAIUrl({
        resourcePath: `models/${model}`,
        resourceMethod: "predictLongRunning",
        clientOptions
    });
    const fetchOptions = getFetchOptions({
        method: "POST",
        apiKey,
        clientOptions,
        body: JSON.stringify(veoPredictRequest)
    });
    const response = await makeRequest(url, fetchOptions);
    return response.json();
}
async function veoCheckOperation(apiKey, operation, clientOptions) {
    const url = getGoogleAIUrl({
        resourcePath: operation,
        clientOptions
    });
    const fetchOptions = getFetchOptions({
        method: "GET",
        apiKey,
        clientOptions
    });
    const response = await makeRequest(url, fetchOptions);
    return response.json();
}
function getGoogleAIUrl(params) {
    const DEFAULT_API_VERSION = "v1beta";
    const DEFAULT_BASE_URL = "https://generativelanguage.googleapis.com";
    const apiVersion = params.clientOptions?.apiVersion || DEFAULT_API_VERSION;
    const baseUrl = params.clientOptions?.baseUrl || DEFAULT_BASE_URL;
    let url = `${baseUrl}/${apiVersion}/${params.resourcePath}`;
    if (params.resourceMethod) {
        url += `:${params.resourceMethod}`;
    }
    if (params.queryParams) {
        url += `?${params.queryParams}`;
    }
    if (params.resourceMethod === "streamGenerateContent") {
        url += `${params.queryParams ? "&" : "?"}alt=sse`;
    }
    return url;
}
function getFetchOptions(params) {
    const fetchOptions = {
        method: params.method,
        headers: getHeaders(params.apiKey, params.clientOptions)
    };
    if (params.body) {
        fetchOptions.body = params.body;
    }
    const signal = getAbortSignal(params.clientOptions);
    if (signal) {
        fetchOptions.signal = signal;
    }
    return fetchOptions;
}
function getAbortSignal(clientOptions) {
    const hasTimeout = (clientOptions?.timeout ?? -1) >= 0;
    if (clientOptions?.signal !== void 0 || hasTimeout) {
        const controller = new AbortController();
        if (hasTimeout) {
            setTimeout(()=>controller.abort(), clientOptions?.timeout);
        }
        if (clientOptions?.signal) {
            clientOptions.signal.addEventListener("abort", ()=>{
                controller.abort();
            });
        }
        return controller.signal;
    }
    return void 0;
}
function getHeaders(apiKey, clientOptions) {
    let customHeaders = {};
    if (clientOptions?.customHeaders) {
        customHeaders = structuredClone(clientOptions.customHeaders);
        delete customHeaders["x-goog-api-key"];
        delete customHeaders["x-goog-api-client"];
    }
    const headers = {
        ...customHeaders,
        "Content-Type": "application/json",
        "x-goog-api-key": apiKey,
        "x-goog-api-client": (0, import_utils.getGenkitClientHeader)()
    };
    return headers;
}
async function makeRequest(url, fetchOptions) {
    try {
        const response = await fetch(url, fetchOptions);
        if (!response.ok) {
            let errorText = await response.text();
            let errorMessage = errorText;
            try {
                const json = JSON.parse(errorText);
                if (json.error && json.error.message) {
                    errorMessage = json.error.message;
                }
            } catch (e) {}
            throw new Error(`Error fetching from ${url}: [${response.status} ${response.statusText}] ${errorMessage}`);
        }
        return response;
    } catch (e) {
        console.error(e);
        throw new Error(`Failed to fetch from ${url}: ${(0, import_utils.extractErrMsg)(e)}`);
    }
}
const TEST_ONLY = {
    getFetchOptions,
    getAbortSignal,
    getHeaders,
    makeRequest
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    TEST_ONLY,
    embedContent,
    generateContent,
    generateContentStream,
    getGoogleAIUrl,
    imagenPredict,
    listModels,
    veoCheckOperation,
    veoPredict
}); //# sourceMappingURL=client.js.map
}),
"[project]/node_modules/@genkit-ai/google-genai/lib/googleai/utils.js [app-rsc] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toESM = (mod, isNodeMode, target)=>(target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(// If the importer is in node compatibility mode or this is not an ESM
    // file that has been converted to a CommonJS file using a Babel-
    // compatible transform (i.e. "__esModule" has not been set), then set
    // "default" to the CommonJS "module.exports" for node compatibility.
    isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", {
        value: mod,
        enumerable: true
    }) : target, mod));
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var utils_exports = {};
__export(utils_exports, {
    API_KEY_FALSE_ERROR: ()=>API_KEY_FALSE_ERROR,
    MISSING_API_KEY_ERROR: ()=>MISSING_API_KEY_ERROR,
    calculateApiKey: ()=>calculateApiKey,
    checkApiKey: ()=>checkApiKey,
    checkModelName: ()=>import_utils2.checkModelName,
    cleanSchema: ()=>import_utils2.cleanSchema,
    extractImagenImage: ()=>extractImagenImage,
    extractText: ()=>import_utils2.extractText,
    extractVeoImage: ()=>extractVeoImage,
    extractVersion: ()=>import_utils2.extractVersion,
    getApiKeyFromEnvVar: ()=>getApiKeyFromEnvVar,
    modelName: ()=>import_utils2.modelName
});
module.exports = __toCommonJS(utils_exports);
var import_genkit = __turbopack_context__.r("[project]/node_modules/genkit/lib/index.js [app-rsc] (ecmascript)");
var import_process = __toESM(__turbopack_context__.r("[externals]/process [external] (process, cjs)"));
var import_utils = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/common/utils.js [app-rsc] (ecmascript)");
var import_utils2 = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/common/utils.js [app-rsc] (ecmascript)");
function getApiKeyFromEnvVar() {
    return import_process.default.env.GEMINI_API_KEY || import_process.default.env.GOOGLE_API_KEY || import_process.default.env.GOOGLE_GENAI_API_KEY;
}
const MISSING_API_KEY_ERROR = new import_genkit.GenkitError({
    status: "FAILED_PRECONDITION",
    message: "Please pass in the API key or set the GEMINI_API_KEY or GOOGLE_API_KEY environment variable.\nFor more details see https://genkit.dev/docs/plugins/google-genai/"
});
const API_KEY_FALSE_ERROR = new import_genkit.GenkitError({
    status: "INVALID_ARGUMENT",
    message: "GoogleAI plugin was initialized with {apiKey: false} but no apiKey configuration was passed at call time."
});
function checkApiKey(pluginApiKey) {
    let apiKey;
    if (pluginApiKey !== false) {
        apiKey = pluginApiKey || getApiKeyFromEnvVar();
    }
    if (pluginApiKey !== false && !apiKey) {
        throw MISSING_API_KEY_ERROR;
    }
    return apiKey;
}
function calculateApiKey(pluginApiKey, requestApiKey) {
    let apiKey;
    if (pluginApiKey !== false) {
        apiKey = pluginApiKey || getApiKeyFromEnvVar();
    }
    apiKey = requestApiKey || apiKey;
    if (pluginApiKey === false && !requestApiKey) {
        throw API_KEY_FALSE_ERROR;
    }
    if (!apiKey) {
        throw MISSING_API_KEY_ERROR;
    }
    return apiKey;
}
function extractVeoImage(request) {
    const media = request.messages.at(-1)?.content.find((p)=>!!p.media)?.media;
    if (media) {
        const img = media.url.split(",")[1];
        if (img && media.contentType) {
            return {
                bytesBase64Encoded: img,
                mimeType: media.contentType
            };
        } else if (img) {
            throw new import_genkit.GenkitError({
                status: "INVALID_ARGUMENT",
                message: "content type is required for images"
            });
        }
    }
    return void 0;
}
function extractImagenImage(request) {
    const image = (0, import_utils.extractMedia)(request, {
        metadataType: "base",
        isDefault: true
    })?.url.split(",")[1];
    if (image) {
        return {
            bytesBase64Encoded: image
        };
    }
    return void 0;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    API_KEY_FALSE_ERROR,
    MISSING_API_KEY_ERROR,
    calculateApiKey,
    checkApiKey,
    checkModelName,
    cleanSchema,
    extractImagenImage,
    extractText,
    extractVeoImage,
    extractVersion,
    getApiKeyFromEnvVar,
    modelName
}); //# sourceMappingURL=utils.js.map
}),
"[project]/node_modules/@genkit-ai/google-genai/lib/googleai/types.js [app-rsc] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var types_exports = {};
__export(types_exports, {
    FinishReason: ()=>import_types.FinishReason,
    HarmBlockThreshold: ()=>import_types.HarmBlockThreshold,
    HarmCategory: ()=>import_types.HarmCategory,
    TaskTypeSchema: ()=>import_types.TaskTypeSchema
});
module.exports = __toCommonJS(types_exports);
var import_types = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/common/types.js [app-rsc] (ecmascript)");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    FinishReason,
    HarmBlockThreshold,
    HarmCategory,
    TaskTypeSchema
}); //# sourceMappingURL=types.js.map
}),
"[project]/node_modules/@genkit-ai/google-genai/lib/googleai/embedder.js [app-rsc] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var embedder_exports = {};
__export(embedder_exports, {
    EmbeddingConfigSchema: ()=>EmbeddingConfigSchema,
    TEST_ONLY: ()=>TEST_ONLY,
    defineEmbedder: ()=>defineEmbedder,
    defineKnownModels: ()=>defineKnownModels,
    listActions: ()=>listActions,
    model: ()=>model
});
module.exports = __toCommonJS(embedder_exports);
var import_genkit = __turbopack_context__.r("[project]/node_modules/genkit/lib/index.js [app-rsc] (ecmascript)");
var import_embedder = __turbopack_context__.r("[project]/node_modules/genkit/lib/embedder.js [app-rsc] (ecmascript)");
var import_client = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/googleai/client.js [app-rsc] (ecmascript)");
var import_types = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/googleai/types.js [app-rsc] (ecmascript)");
var import_utils = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/googleai/utils.js [app-rsc] (ecmascript)");
const EmbeddingConfigSchema = import_genkit.z.object({
    /** Override the API key provided at plugin initialization. */ apiKey: import_genkit.z.string().optional(),
    /**
   * The `task_type` parameter is defined as the intended downstream application to help the model
   * produce better quality embeddings.
   **/ taskType: import_types.TaskTypeSchema.optional(),
    title: import_genkit.z.string().optional(),
    version: import_genkit.z.string().optional(),
    /**
   * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
   * By default, the model generates embeddings with 768 dimensions. Models such as
   * `text-embedding-004`, `text-embedding-005`, and `text-multilingual-embedding-002`
   * allow the output dimensionality to be adjusted between 1 and 768.
   * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
   **/ outputDimensionality: import_genkit.z.number().min(1).optional()
}).passthrough();
function commonRef(name, info, configSchema = EmbeddingConfigSchema) {
    return (0, import_embedder.embedderRef)({
        name: `googleai/${name}`,
        configSchema,
        info: info ?? {
            dimensions: 768,
            supports: {
                input: [
                    "text"
                ]
            }
        }
    });
}
const GENERIC_MODEL = commonRef("embedder");
const KNOWN_MODELS = {
    "text-embedding-004": commonRef("text-embedding-004"),
    "gemini-embedding-001": commonRef("gemini-embedding-001")
};
function model(version, config = {}) {
    const name = (0, import_utils.checkModelName)(version);
    return (0, import_embedder.embedderRef)({
        name: `googleai/${name}`,
        config,
        configSchema: GENERIC_MODEL.configSchema,
        info: {
            ...GENERIC_MODEL.info
        }
    });
}
function listActions(models) {
    return models.filter((m)=>m.supportedGenerationMethods.includes("embedContent")).filter((m)=>!m.description || !m.description.includes("deprecated")).map((m)=>{
        const ref = model(m.name);
        return (0, import_genkit.embedderActionMetadata)({
            name: ref.name,
            info: ref.info,
            configSchema: ref.configSchema
        });
    });
}
function defineKnownModels(ai, options) {
    for (const name of Object.keys(KNOWN_MODELS)){
        defineEmbedder(ai, name, options);
    }
}
function defineEmbedder(ai, name, pluginOptions) {
    (0, import_utils.checkApiKey)(pluginOptions?.apiKey);
    const ref = model(name);
    return ai.defineEmbedder({
        name: ref.name,
        configSchema: ref.configSchema,
        info: ref.info
    }, async (input, reqOptions)=>{
        const embedApiKey = (0, import_utils.calculateApiKey)(pluginOptions?.apiKey, reqOptions?.apiKey);
        const embedVersion = reqOptions?.version || (0, import_utils.extractVersion)(ref);
        const embeddings = await Promise.all(input.map(async (doc)=>{
            const response = await (0, import_client.embedContent)(embedApiKey, embedVersion, {
                taskType: reqOptions?.taskType,
                title: reqOptions?.title,
                content: {
                    role: "",
                    parts: [
                        {
                            text: doc.text
                        }
                    ]
                },
                outputDimensionality: reqOptions?.outputDimensionality
            });
            const values = response.embedding.values;
            return {
                embedding: values
            };
        }));
        return {
            embeddings
        };
    });
}
const TEST_ONLY = {
    KNOWN_MODELS
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    EmbeddingConfigSchema,
    TEST_ONLY,
    defineEmbedder,
    defineKnownModels,
    listActions,
    model
}); //# sourceMappingURL=embedder.js.map
}),
"[project]/node_modules/@genkit-ai/google-genai/lib/common/converters.js [app-rsc] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var converters_exports = {};
__export(converters_exports, {
    fromGeminiCandidate: ()=>fromGeminiCandidate,
    toGeminiFunctionModeEnum: ()=>toGeminiFunctionModeEnum,
    toGeminiMessage: ()=>toGeminiMessage,
    toGeminiSystemInstruction: ()=>toGeminiSystemInstruction,
    toGeminiTool: ()=>toGeminiTool
});
module.exports = __toCommonJS(converters_exports);
var import_genkit = __turbopack_context__.r("[project]/node_modules/genkit/lib/index.js [app-rsc] (ecmascript)");
var import_types = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/common/types.js [app-rsc] (ecmascript)");
function toGeminiTool(tool) {
    const declaration = {
        name: tool.name.replace(/\//g, "__"),
        // Gemini throws on '/' in tool name
        description: tool.description,
        parameters: toGeminiSchemaProperty(tool.inputSchema)
    };
    return declaration;
}
function toGeminiSchemaProperty(property) {
    if (!property || !property.type) {
        return void 0;
    }
    const baseSchema = {};
    if (property.description) {
        baseSchema.description = property.description;
    }
    if (property.enum) {
        baseSchema.enum = property.enum;
    }
    if (property.nullable) {
        baseSchema.nullable = property.nullable;
    }
    let propertyType;
    if (Array.isArray(property.type)) {
        const types = property.type;
        if (types.includes("null")) {
            baseSchema.nullable = true;
        }
        propertyType = types.find((t)=>t !== "null");
    } else {
        propertyType = property.type;
    }
    if (propertyType === "object") {
        const nestedProperties = {};
        Object.keys(property.properties).forEach((key)=>{
            nestedProperties[key] = toGeminiSchemaProperty(property.properties[key]);
        });
        return {
            ...baseSchema,
            type: import_types.SchemaType.OBJECT,
            properties: nestedProperties,
            required: property.required
        };
    } else if (propertyType === "array") {
        return {
            ...baseSchema,
            type: import_types.SchemaType.ARRAY,
            items: toGeminiSchemaProperty(property.items)
        };
    } else {
        const schemaType = import_types.SchemaType[propertyType.toUpperCase()];
        if (!schemaType) {
            throw new import_genkit.GenkitError({
                status: "INVALID_ARGUMENT",
                message: `Unsupported property type ${propertyType.toUpperCase()}`
            });
        }
        return {
            ...baseSchema,
            type: schemaType
        };
    }
}
function toGeminiMedia(part) {
    if (part.media?.url.startsWith("data:")) {
        const dataUrl = part.media.url;
        const b64Data = dataUrl.substring(dataUrl.indexOf(",") + 1);
        const contentType = part.media.contentType || dataUrl.substring(dataUrl.indexOf(":") + 1, dataUrl.indexOf(";"));
        return {
            inlineData: {
                mimeType: contentType,
                data: b64Data
            }
        };
    }
    if (!part.media?.contentType) {
        throw Error("Must supply a `contentType` when sending File URIs to Gemini.");
    }
    return {
        fileData: {
            mimeType: part.media.contentType,
            fileUri: part.media.url
        }
    };
}
function toGeminiToolRequest(part) {
    if (!part.toolRequest?.input) {
        throw Error("Invalid ToolRequestPart: input was missing.");
    }
    return {
        functionCall: {
            name: part.toolRequest.name,
            args: part.toolRequest.input
        }
    };
}
function toGeminiToolResponse(part) {
    if (!part.toolResponse?.output) {
        throw Error("Invalid ToolResponsePart: output was missing.");
    }
    return {
        functionResponse: {
            name: part.toolResponse.name,
            response: {
                name: part.toolResponse.name,
                content: part.toolResponse.output
            }
        }
    };
}
function toGeminiReasoning(part) {
    const out = {
        thought: true
    };
    if (typeof part.metadata?.thoughtSignature === "string") {
        out.thoughtSignature = part.metadata.thoughtSignature;
    }
    if (part.reasoning?.length) {
        out.text = part.reasoning;
    }
    return out;
}
function toGeminiCustom(part) {
    if (part.custom?.codeExecutionResult) {
        return {
            codeExecutionResult: part.custom.codeExecutionResult
        };
    }
    if (part.custom?.executableCode) {
        return {
            executableCode: part.custom.executableCode
        };
    }
    throw new Error("Unsupported Custom Part type");
}
function toGeminiPart(part) {
    if (part.text) {
        return {
            text: part.text
        };
    }
    if (part.media) {
        return toGeminiMedia(part);
    }
    if (part.toolRequest) {
        return toGeminiToolRequest(part);
    }
    if (part.toolResponse) {
        return toGeminiToolResponse(part);
    }
    if (typeof part.reasoning === "string") {
        return toGeminiReasoning(part);
    }
    if (part.custom) {
        return toGeminiCustom(part);
    }
    throw new Error("Unsupported Part type " + JSON.stringify(part));
}
function toGeminiRole(role, model) {
    switch(role){
        case "user":
            return "user";
        case "model":
            return "model";
        case "system":
            if (model?.info?.supports?.systemRole) {
                throw new Error("system role is only supported for a single message in the first position");
            } else {
                throw new Error("system role is not supported");
            }
        case "tool":
            return "function";
        default:
            return "user";
    }
}
function toGeminiMessage(message, model) {
    let sortedParts = message.content;
    if (message.role === "tool") {
        sortedParts = [
            ...message.content
        ].sort((a, b)=>{
            const aRef = a.toolResponse?.ref;
            const bRef = b.toolResponse?.ref;
            if (!aRef && !bRef) return 0;
            if (!aRef) return 1;
            if (!bRef) return -1;
            return parseInt(aRef, 10) - parseInt(bRef, 10);
        });
    }
    return {
        role: toGeminiRole(message.role, model),
        parts: sortedParts.map(toGeminiPart)
    };
}
function toGeminiSystemInstruction(message) {
    return {
        role: "user",
        parts: message.content.map(toGeminiPart)
    };
}
function toGeminiFunctionModeEnum(from) {
    if (from === void 0) {
        return void 0;
    }
    switch(from){
        case "MODE_UNSPECIFIED":
            {
                return import_types.FunctionCallingMode.MODE_UNSPECIFIED;
            }
        case "required":
        case "ANY":
            {
                return import_types.FunctionCallingMode.ANY;
            }
        case "auto":
        case "AUTO":
            {
                return import_types.FunctionCallingMode.AUTO;
            }
        case "none":
        case "NONE":
            {
                return import_types.FunctionCallingMode.NONE;
            }
        default:
            throw new Error(`unsupported function calling mode: ${from}`);
    }
}
function fromGeminiFinishReason(reason) {
    if (!reason) return "unknown";
    switch(reason){
        case "STOP":
            return "stop";
        case "MAX_TOKENS":
            return "length";
        case "SAFETY":
        // blocked for safety
        case "RECITATION":
        // blocked for reciting training data
        case "LANGUAGE":
        // blocked for using an unsupported language
        case "BLOCKLIST":
        // blocked for forbidden terms
        case "PROHIBITED_CONTENT":
        // blocked for potentially containing prohibited content
        case "SPII":
            return "blocked";
        case "MALFORMED_FUNCTION_CALL":
        case "OTHER":
            return "other";
        default:
            return "unknown";
    }
}
function fromGeminiThought(part) {
    return {
        reasoning: part.text || "",
        metadata: {
            thoughtSignature: part.thoughtSignature
        }
    };
}
function fromGeminiInlineData(part) {
    if (!part.inlineData || !part.inlineData.hasOwnProperty("mimeType") || !part.inlineData.hasOwnProperty("data")) {
        throw new Error("Invalid GeminiPart: missing required properties");
    }
    const { mimeType, data } = part.inlineData;
    const dataUrl = `data:${mimeType};base64,${data}`;
    return {
        media: {
            url: dataUrl,
            contentType: mimeType
        }
    };
}
function fromGeminiFileData(part) {
    if (!part.fileData || !part.fileData.hasOwnProperty("mimeType") || !part.fileData.hasOwnProperty("fileUri")) {
        throw new Error("Invalid Gemini File Data Part: missing required properties");
    }
    return {
        media: {
            url: part.fileData?.fileUri,
            contentType: part.fileData?.mimeType
        }
    };
}
function fromGeminiFunctionCall(part, ref) {
    if (!part.functionCall) {
        throw Error("Invalid Gemini Function Call Part: missing function call data");
    }
    return {
        toolRequest: {
            name: part.functionCall.name,
            input: part.functionCall.args,
            ref
        }
    };
}
function fromGeminiFunctionResponse(part, ref) {
    if (!part.functionResponse) {
        throw new Error("Invalid Gemini Function Call Part: missing function call data");
    }
    return {
        toolResponse: {
            name: part.functionResponse.name.replace(/__/g, "/"),
            // restore slashes
            output: part.functionResponse.response,
            ref
        }
    };
}
function fromExecutableCode(part) {
    if (!part.executableCode) {
        throw new Error("Invalid GeminiPart: missing executableCode");
    }
    return {
        custom: {
            executableCode: {
                language: part.executableCode.language,
                code: part.executableCode.code
            }
        }
    };
}
function fromCodeExecutionResult(part) {
    if (!part.codeExecutionResult) {
        throw new Error("Invalid GeminiPart: missing codeExecutionResult");
    }
    return {
        custom: {
            codeExecutionResult: {
                outcome: part.codeExecutionResult.outcome,
                output: part.codeExecutionResult.output
            }
        }
    };
}
function fromGeminiPart(part, ref) {
    if (part.thought) return fromGeminiThought(part);
    if (typeof part.text === "string") return {
        text: part.text
    };
    if (part.inlineData) return fromGeminiInlineData(part);
    if (part.fileData) return fromGeminiFileData(part);
    if (part.functionCall) return fromGeminiFunctionCall(part, ref);
    if (part.functionResponse) return fromGeminiFunctionResponse(part, ref);
    if (part.executableCode) return fromExecutableCode(part);
    if (part.codeExecutionResult) return fromCodeExecutionResult(part);
    throw new Error("Unsupported GeminiPart type " + JSON.stringify(part));
}
function fromGeminiCandidate(candidate) {
    const parts = candidate.content?.parts || [];
    const genkitCandidate = {
        index: candidate.index || 0,
        message: {
            role: "model",
            content: parts.filter((p)=>Object.keys(p).length > 0).map((part, index)=>fromGeminiPart(part, index.toString()))
        },
        finishReason: fromGeminiFinishReason(candidate.finishReason),
        finishMessage: candidate.finishMessage,
        custom: {
            safetyRatings: candidate.safetyRatings,
            citationMetadata: candidate.citationMetadata
        }
    };
    return genkitCandidate;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    fromGeminiCandidate,
    toGeminiFunctionModeEnum,
    toGeminiMessage,
    toGeminiSystemInstruction,
    toGeminiTool
}); //# sourceMappingURL=converters.js.map
}),
"[project]/node_modules/@genkit-ai/google-genai/lib/googleai/gemini.js [app-rsc] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var gemini_exports = {};
__export(gemini_exports, {
    GeminiConfigSchema: ()=>GeminiConfigSchema,
    GeminiTtsConfigSchema: ()=>GeminiTtsConfigSchema,
    GemmaConfigSchema: ()=>GemmaConfigSchema,
    TEST_ONLY: ()=>TEST_ONLY,
    defineKnownModels: ()=>defineKnownModels,
    defineModel: ()=>defineModel,
    isGeminiModelName: ()=>isGeminiModelName,
    isGemmaModelName: ()=>isGemmaModelName,
    isTTSModelName: ()=>isTTSModelName,
    listActions: ()=>listActions,
    model: ()=>model
});
module.exports = __toCommonJS(gemini_exports);
var import_genkit = __turbopack_context__.r("[project]/node_modules/genkit/lib/index.js [app-rsc] (ecmascript)");
var import_model = __turbopack_context__.r("[project]/node_modules/genkit/lib/model.js [app-rsc] (ecmascript)");
var import_middleware = __turbopack_context__.r("[project]/node_modules/genkit/lib/middleware.js [app-rsc] (ecmascript)");
var import_tracing = __turbopack_context__.r("[project]/node_modules/genkit/lib/tracing.js [app-rsc] (ecmascript)");
var import_converters = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/common/converters.js [app-rsc] (ecmascript)");
var import_client = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/googleai/client.js [app-rsc] (ecmascript)");
var import_utils = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/googleai/utils.js [app-rsc] (ecmascript)");
const SafetySettingsSchema = import_genkit.z.object({
    category: import_genkit.z.enum([
        "HARM_CATEGORY_UNSPECIFIED",
        "HARM_CATEGORY_HATE_SPEECH",
        "HARM_CATEGORY_SEXUALLY_EXPLICIT",
        "HARM_CATEGORY_HARASSMENT",
        "HARM_CATEGORY_DANGEROUS_CONTENT"
    ]),
    threshold: import_genkit.z.enum([
        "BLOCK_LOW_AND_ABOVE",
        "BLOCK_MEDIUM_AND_ABOVE",
        "BLOCK_ONLY_HIGH",
        "BLOCK_NONE"
    ])
});
const VoiceConfigSchema = import_genkit.z.object({
    prebuiltVoiceConfig: import_genkit.z.object({
        // TODO: Make this an array of objects so we can also specify the description
        // for each voiceName.
        voiceName: import_genkit.z.union([
            import_genkit.z.enum([
                "Zephyr",
                "Puck",
                "Charon",
                "Kore",
                "Fenrir",
                "Leda",
                "Orus",
                "Aoede",
                "Callirrhoe",
                "Autonoe",
                "Enceladus",
                "Iapetus",
                "Umbriel",
                "Algieba",
                "Despina",
                "Erinome",
                "Algenib",
                "Rasalgethi",
                "Laomedeia",
                "Achernar",
                "Alnilam",
                "Schedar",
                "Gacrux",
                "Pulcherrima",
                "Achird",
                "Zubenelgenubi",
                "Vindemiatrix",
                "Sadachbia",
                "Sadaltager",
                "Sulafat"
            ]),
            // To allow any new string values
            import_genkit.z.string()
        ]).describe("Name of the preset voice to use").optional()
    }).describe("Configuration for the prebuilt speaker to use").passthrough().optional()
}).describe("Configuration for the voice to use").passthrough();
const GeminiConfigSchema = import_model.GenerationCommonConfigSchema.extend({
    apiKey: import_genkit.z.string().describe("Overrides the plugin-configured API key, if specified.").optional(),
    safetySettings: import_genkit.z.array(SafetySettingsSchema).describe("Adjust how likely you are to see responses that could be harmful. Content is blocked based on the probability that it is harmful.").optional(),
    codeExecution: import_genkit.z.union([
        import_genkit.z.boolean(),
        import_genkit.z.object({}).strict()
    ]).describe("Enables the model to generate and run code.").optional(),
    contextCache: import_genkit.z.boolean().describe("Context caching allows you to save and reuse precomputed input tokens that you wish to use repeatedly.").optional(),
    functionCallingConfig: import_genkit.z.object({
        mode: import_genkit.z.enum([
            "MODE_UNSPECIFIED",
            "AUTO",
            "ANY",
            "NONE"
        ]).optional(),
        allowedFunctionNames: import_genkit.z.array(import_genkit.z.string()).optional()
    }).describe("Controls how the model uses the provided tools (function declarations). With AUTO (Default) mode, the model decides whether to generate a natural language response or suggest a function call based on the prompt and context. With ANY, the model is constrained to always predict a function call and guarantee function schema adherence. With NONE, the model is prohibited from making function calls.").optional(),
    responseModalities: import_genkit.z.array(import_genkit.z.enum([
        "TEXT",
        "IMAGE",
        "AUDIO"
    ])).describe("The modalities to be used in response. Only supported for 'gemini-2.0-flash-exp' model at present.").optional(),
    googleSearchRetrieval: import_genkit.z.union([
        import_genkit.z.boolean(),
        import_genkit.z.object({}).passthrough()
    ]).describe("Retrieve public web data for grounding, powered by Google Search.").optional(),
    temperature: import_genkit.z.number().min(0).max(2).describe(import_model.GenerationCommonConfigDescriptions.temperature + " The default value is 1.0.").optional(),
    topP: import_genkit.z.number().min(0).max(1).describe(import_model.GenerationCommonConfigDescriptions.topP + " The default value is 0.95.").optional(),
    thinkingConfig: import_genkit.z.object({
        includeThoughts: import_genkit.z.boolean().describe("Indicates whether to include thoughts in the response.If true, thoughts are returned only if the model supports thought and thoughts are available.").optional(),
        thinkingBudget: import_genkit.z.number().min(0).max(24576).describe("Indicates the thinking budget in tokens. 0 is DISABLED. -1 is AUTOMATIC. The default values and allowed ranges are model dependent. The thinking budget parameter gives the model guidance on the number of thinking tokens it can use when generating a response. A greater number of tokens is typically associated with more detailed thinking, which is needed for solving more complex tasks. ").optional()
    }).optional()
}).passthrough();
const GeminiTtsConfigSchema = GeminiConfigSchema.extend({
    speechConfig: import_genkit.z.object({
        voiceConfig: VoiceConfigSchema.optional(),
        multiSpeakerVoiceConfig: import_genkit.z.object({
            speakerVoiceConfigs: import_genkit.z.array(import_genkit.z.object({
                speaker: import_genkit.z.string().describe("Name of the speaker to use"),
                voiceConfig: VoiceConfigSchema
            }).describe("Configuration for a single speaker in a multi speaker setup").passthrough()).describe("Configuration for all the enabled speaker voices")
        }).describe("Configuration for multi-speaker setup").passthrough().optional()
    }).describe("Speech generation config").passthrough().optional()
}).passthrough();
const GemmaConfigSchema = GeminiConfigSchema.extend({
    temperature: import_genkit.z.number().min(0).max(1).describe(import_model.GenerationCommonConfigDescriptions.temperature + " The default value is 1.0.").optional()
}).passthrough();
function commonRef(name, info, configSchema = GeminiConfigSchema) {
    return (0, import_model.modelRef)({
        name: `googleai/${name}`,
        configSchema,
        info: info ?? {
            supports: {
                multiturn: true,
                media: true,
                tools: true,
                toolChoice: true,
                systemRole: true,
                constrained: "no-tools",
                output: [
                    "text",
                    "json"
                ]
            }
        }
    });
}
const GENERIC_MODEL = commonRef("gemini");
const GENERIC_TTS_MODEL = commonRef("gemini-tts", {
    supports: {
        multiturn: false,
        media: false,
        tools: false,
        toolChoice: false,
        systemRole: false,
        constrained: "no-tools"
    }
}, GeminiTtsConfigSchema);
const GENERIC_GEMMA_MODEL = commonRef("gemma-generic", void 0, GemmaConfigSchema);
const KNOWN_GEMINI_MODELS = {
    "gemini-2.5-pro": commonRef("gemini-2.5-pro"),
    "gemini-2.5-flash": commonRef("gemini-2.5-flash"),
    "gemini-2.5-flash-lite": commonRef("gemini-2.5-flash-lite"),
    "gemini-2.5-flash-image-preview": commonRef("gemini-2.5-flash-image-preview"),
    "gemini-2.0-flash": commonRef("gemini-2.0-flash"),
    "gemini-2.0-flash-preview-image-generation": commonRef("gemini-2.0-flash-preview-image-generation"),
    "gemini-2.0-flash-lite": commonRef("gemini-2.0-flash-lite")
};
function isGeminiModelName(value) {
    return value.startsWith("gemini-") && !value.endsWith("-tts");
}
const KNOWN_TTS_MODELS = {
    "gemini-2.5-flash-preview-tts": commonRef("gemini-2.5-flash-preview-tts", {
        ...GENERIC_TTS_MODEL.info
    }, GeminiTtsConfigSchema),
    "gemini-2.5-pro-preview-tts": commonRef("gemini-2.5-pro-preview-tts", {
        ...GENERIC_TTS_MODEL.info
    }, GeminiTtsConfigSchema)
};
function isTTSModelName(value) {
    return value.startsWith("gemini-") && value.endsWith("-tts");
}
const KNOWN_GEMMA_MODELS = {
    "gemma-3-12b-it": commonRef("gemma-3-12b-it", void 0, GemmaConfigSchema),
    "gemma-3-1b-it": commonRef("gemma-3-1b-it", void 0, GemmaConfigSchema),
    "gemma-3-27b-it": commonRef("gemma-3-27b-it", void 0, GemmaConfigSchema),
    "gemma-3-4b-it": commonRef("gemma-3-4b-it", void 0, GemmaConfigSchema),
    "gemma-3n-e4b-it": commonRef("gemma-3n-e4b-it", void 0, GemmaConfigSchema)
};
function isGemmaModelName(value) {
    return value.startsWith("gemma-");
}
const KNOWN_MODELS = {
    ...KNOWN_GEMINI_MODELS,
    ...KNOWN_TTS_MODELS,
    ...KNOWN_GEMMA_MODELS
};
function model(version, config = {}) {
    const name = (0, import_utils.checkModelName)(version);
    if (isTTSModelName(name)) {
        return (0, import_model.modelRef)({
            name: `googleai/${name}`,
            config,
            configSchema: GeminiTtsConfigSchema,
            info: {
                ...GENERIC_TTS_MODEL.info
            }
        });
    }
    if (isGemmaModelName(name)) {
        return (0, import_model.modelRef)({
            name: `googleai/${name}`,
            config,
            configSchema: GemmaConfigSchema,
            info: {
                ...GENERIC_GEMMA_MODEL.info
            }
        });
    }
    return (0, import_model.modelRef)({
        name: `googleai/${name}`,
        config,
        configSchema: GeminiConfigSchema,
        info: {
            ...GENERIC_MODEL.info
        }
    });
}
function listActions(models) {
    return models.filter((m)=>m.supportedGenerationMethods.includes("generateContent")).filter((m)=>!m.description || !m.description.includes("deprecated")).map((m)=>{
        const ref = model(m.name);
        return (0, import_genkit.modelActionMetadata)({
            name: ref.name,
            info: ref.info,
            configSchema: ref.configSchema
        });
    });
}
function defineKnownModels(ai, options) {
    for (const name of Object.keys(KNOWN_MODELS)){
        defineModel(ai, name, options);
    }
}
function defineModel(ai, name, pluginOptions) {
    (0, import_utils.checkApiKey)(pluginOptions?.apiKey);
    const ref = model(name);
    const clientOptions = {
        apiVersion: pluginOptions?.apiVersion,
        baseUrl: pluginOptions?.baseUrl
    };
    const middleware = [];
    if (ref.info?.supports?.media) {
        middleware.push((0, import_middleware.downloadRequestMedia)({
            maxBytes: 1024 * 1024 * 10,
            // don't downlaod files that have been uploaded using the Files API
            filter: (part)=>{
                try {
                    const url = new URL(part.media.url);
                    if (// Gemini can handle these URLs
                    [
                        "generativelanguage.googleapis.com",
                        "www.youtube.com",
                        "youtube.com",
                        "youtu.be"
                    ].includes(url.hostname)) return false;
                } catch  {}
                return true;
            }
        }));
    }
    return ai.defineModel({
        apiVersion: "v2",
        name: ref.name,
        ...ref.info,
        configSchema: ref.configSchema,
        use: middleware
    }, async (request, { streamingRequested, sendChunk, abortSignal })=>{
        const clientOpt = {
            ...clientOptions,
            signal: abortSignal
        };
        const messages = [
            ...request.messages
        ];
        if (messages.length === 0) throw new Error("No messages provided.");
        let systemInstruction = void 0;
        const systemMessage = messages.find((m)=>m.role === "system");
        if (systemMessage) {
            messages.splice(messages.indexOf(systemMessage), 1);
            systemInstruction = (0, import_converters.toGeminiSystemInstruction)(systemMessage);
        }
        const tools = [];
        if (request.tools?.length) {
            tools.push({
                functionDeclarations: request.tools.map(import_converters.toGeminiTool)
            });
        }
        const requestOptions = {
            ...request.config
        };
        const { apiKey: apiKeyFromConfig, safetySettings: safetySettingsFromConfig, codeExecution: codeExecutionFromConfig, version: versionFromConfig, functionCallingConfig, googleSearchRetrieval, tools: toolsFromConfig, ...restOfConfigOptions } = requestOptions;
        if (codeExecutionFromConfig) {
            tools.push({
                codeExecution: codeExecutionFromConfig === true ? {} : codeExecutionFromConfig
            });
        }
        if (toolsFromConfig) {
            tools.push(...toolsFromConfig);
        }
        if (googleSearchRetrieval) {
            tools.push({
                googleSearch: googleSearchRetrieval === true ? {} : googleSearchRetrieval
            });
        }
        let toolConfig;
        if (functionCallingConfig) {
            toolConfig = {
                functionCallingConfig: {
                    allowedFunctionNames: functionCallingConfig.allowedFunctionNames,
                    mode: (0, import_converters.toGeminiFunctionModeEnum)(functionCallingConfig.mode)
                }
            };
        } else if (request.toolChoice) {
            toolConfig = {
                functionCallingConfig: {
                    mode: (0, import_converters.toGeminiFunctionModeEnum)(request.toolChoice)
                }
            };
        }
        const jsonMode = request.output?.format === "json" || request.output?.contentType === "application/json" && tools.length === 0;
        const generationConfig = {
            ...restOfConfigOptions,
            candidateCount: request.candidates || void 0,
            responseMimeType: jsonMode ? "application/json" : void 0
        };
        if (request.output?.constrained && jsonMode) {
            generationConfig.responseSchema = (0, import_utils.cleanSchema)(request.output.schema);
        }
        const msg = (0, import_converters.toGeminiMessage)(messages[messages.length - 1], ref);
        let generateContentRequest = {
            systemInstruction,
            generationConfig,
            tools: tools.length ? tools : void 0,
            toolConfig,
            safetySettings: safetySettingsFromConfig?.filter((setting)=>setting.category !== "HARM_CATEGORY_UNSPECIFIED"),
            contents: messages.map((message)=>(0, import_converters.toGeminiMessage)(message, ref))
        };
        const modelVersion = versionFromConfig || (0, import_utils.extractVersion)(ref);
        const generateApiKey = (0, import_utils.calculateApiKey)(pluginOptions?.apiKey, requestOptions.apiKey);
        const callGemini = async ()=>{
            let response;
            if (streamingRequested) {
                const result = await (0, import_client.generateContentStream)(generateApiKey, modelVersion, generateContentRequest, clientOpt);
                for await (const item of result.stream){
                    item.candidates?.forEach((candidate)=>{
                        const c = (0, import_converters.fromGeminiCandidate)(candidate);
                        sendChunk({
                            index: c.index,
                            content: c.message.content
                        });
                    });
                }
                response = await result.response;
            } else {
                response = await (0, import_client.generateContent)(generateApiKey, modelVersion, generateContentRequest, clientOpt);
            }
            const candidates = response.candidates || [];
            if (response.candidates?.["undefined"]) {
                candidates.push(response.candidates["undefined"]);
            }
            if (!candidates.length) {
                throw new import_genkit.GenkitError({
                    status: "FAILED_PRECONDITION",
                    message: "No valid candidates returned."
                });
            }
            const candidateData = candidates.map(import_converters.fromGeminiCandidate) || [];
            return {
                candidates: candidateData,
                custom: response,
                usage: {
                    ...(0, import_model.getBasicUsageStats)(request.messages, candidateData),
                    inputTokens: response.usageMetadata?.promptTokenCount,
                    outputTokens: response.usageMetadata?.candidatesTokenCount,
                    thoughtsTokens: response.usageMetadata?.thoughtsTokenCount,
                    totalTokens: response.usageMetadata?.totalTokenCount,
                    cachedContentTokens: response.usageMetadata?.cachedContentTokenCount
                }
            };
        };
        return pluginOptions?.experimental_debugTraces ? await (0, import_tracing.runInNewSpan)(ai.registry, {
            metadata: {
                name: streamingRequested ? "sendMessageStream" : "sendMessage"
            }
        }, async (metadata)=>{
            metadata.input = {
                apiEndpoint: (0, import_client.getGoogleAIUrl)({
                    resourcePath: "",
                    clientOptions: clientOpt
                }),
                cache: {},
                model: modelVersion,
                generateContentOptions: generateContentRequest,
                parts: msg.parts,
                options: clientOpt
            };
            const response = await callGemini();
            metadata.output = response.custom;
            return response;
        }) : await callGemini();
    });
}
const TEST_ONLY = {
    KNOWN_MODELS
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    GeminiConfigSchema,
    GeminiTtsConfigSchema,
    GemmaConfigSchema,
    TEST_ONLY,
    defineKnownModels,
    defineModel,
    isGeminiModelName,
    isGemmaModelName,
    isTTSModelName,
    listActions,
    model
}); //# sourceMappingURL=gemini.js.map
}),
"[project]/node_modules/@genkit-ai/google-genai/lib/googleai/imagen.js [app-rsc] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var imagen_exports = {};
__export(imagen_exports, {
    ImagenConfigSchema: ()=>ImagenConfigSchema,
    TEST_ONLY: ()=>TEST_ONLY,
    defineKnownModels: ()=>defineKnownModels,
    defineModel: ()=>defineModel,
    isImagenModelName: ()=>isImagenModelName,
    listActions: ()=>listActions,
    model: ()=>model
});
module.exports = __toCommonJS(imagen_exports);
var import_genkit = __turbopack_context__.r("[project]/node_modules/genkit/lib/index.js [app-rsc] (ecmascript)");
var import_model = __turbopack_context__.r("[project]/node_modules/genkit/lib/model.js [app-rsc] (ecmascript)");
var import_client = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/googleai/client.js [app-rsc] (ecmascript)");
var import_utils = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/googleai/utils.js [app-rsc] (ecmascript)");
const ImagenConfigSchema = import_genkit.z.object({
    apiKey: import_genkit.z.string().describe("Override the API key provided at plugin initialization.").optional(),
    numberOfImages: import_genkit.z.number().describe("The number of images to generate, from 1 to 4 (inclusive). The default is 1.").optional(),
    aspectRatio: import_genkit.z.enum([
        "1:1",
        "9:16",
        "16:9",
        "3:4",
        "4:3"
    ]).describe("Desired aspect ratio of the output image.").optional(),
    personGeneration: import_genkit.z.enum([
        "dont_allow",
        "allow_adult",
        "allow_all"
    ]).describe("Control if/how images of people will be generated by the model.").optional()
}).passthrough();
function commonRef(name, info, configSchema = ImagenConfigSchema) {
    return (0, import_model.modelRef)({
        name: `googleai/${name}`,
        configSchema,
        info: info ?? {
            supports: {
                media: true,
                multiturn: false,
                tools: false,
                toolChoice: false,
                systemRole: false,
                output: [
                    "media"
                ]
            }
        }
    });
}
const GENERIC_MODEL = commonRef("imagen", {
    supports: {
        media: true,
        multiturn: true,
        tools: true,
        systemRole: true,
        output: [
            "media"
        ]
    }
});
const KNOWN_MODELS = {
    "imagen-3.0-generate-002": commonRef("imagen-3.0-generate-002"),
    "imagen-4.0-generate-preview-06-06": commonRef("imagen-4.0-generate-preview-06-06"),
    "imagen-4.0-ultra-generate-preview-06-06": commonRef("imagen-4.0-ultra-generate-preview-06-06")
};
function isImagenModelName(value) {
    return !!value?.startsWith("imagen-");
}
function model(version, config = {}) {
    const name = (0, import_utils.checkModelName)(version);
    if (KNOWN_MODELS[name]) {
        return KNOWN_MODELS[name].withConfig(config);
    }
    return (0, import_model.modelRef)({
        name: `googleai/${name}`,
        config,
        configSchema: ImagenConfigSchema,
        info: {
            ...GENERIC_MODEL.info
        }
    });
}
function listActions(models) {
    return models.filter((m)=>m.supportedGenerationMethods.includes("predict") && isImagenModelName((0, import_utils.modelName)(m.name))).filter((m)=>!m.description || !m.description.includes("deprecated")).map((m)=>{
        const ref = model(m.name);
        return (0, import_genkit.modelActionMetadata)({
            name: ref.name,
            info: ref.info,
            configSchema: ref.configSchema
        });
    });
}
function defineKnownModels(ai, options) {
    for (const name of Object.keys(KNOWN_MODELS)){
        defineModel(ai, name, options);
    }
}
function defineModel(ai, name, pluginOptions) {
    (0, import_utils.checkApiKey)(pluginOptions?.apiKey);
    const ref = model(name);
    const clientOptions = {
        apiVersion: pluginOptions?.apiVersion,
        baseUrl: pluginOptions?.baseUrl
    };
    return ai.defineModel({
        apiVersion: "v2",
        name: ref.name,
        ...ref.info,
        configSchema: ref.configSchema
    }, async (request, { abortSignal })=>{
        const clientOpt = {
            ...clientOptions,
            signal: abortSignal
        };
        const imagenPredictRequest = {
            instances: [
                {
                    prompt: (0, import_utils.extractText)(request),
                    image: (0, import_utils.extractImagenImage)(request)
                }
            ],
            parameters: toImagenParameters(request)
        };
        const predictApiKey = (0, import_utils.calculateApiKey)(pluginOptions?.apiKey, request.config?.apiKey);
        const response = await (0, import_client.imagenPredict)(predictApiKey, (0, import_utils.extractVersion)(ref), imagenPredictRequest, clientOpt);
        if (!response.predictions || response.predictions.length == 0) {
            throw new Error("Model returned no predictions. Possibly due to content filters.");
        }
        const message = {
            role: "model",
            content: response.predictions.map(fromImagenPrediction)
        };
        return {
            finishReason: "stop",
            message,
            usage: (0, import_model.getBasicUsageStats)(request.messages, message),
            custom: response
        };
    });
}
function fromImagenPrediction(p) {
    const b64data = p.bytesBase64Encoded;
    const mimeType = p.mimeType;
    return {
        media: {
            url: `data:${mimeType};base64,${b64data}`,
            contentType: mimeType
        }
    };
}
function toImagenParameters(request) {
    const out = {
        sampleCount: request.config?.numberOfImages ?? 1,
        ...request?.config
    };
    for(const k in out){
        if (!out[k]) delete out[k];
    }
    delete out.apiKey;
    return out;
}
const TEST_ONLY = {
    toImagenParameters,
    fromImagenPrediction,
    GENERIC_MODEL,
    KNOWN_MODELS
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    ImagenConfigSchema,
    TEST_ONLY,
    defineKnownModels,
    defineModel,
    isImagenModelName,
    listActions,
    model
}); //# sourceMappingURL=imagen.js.map
}),
"[project]/node_modules/@genkit-ai/google-genai/lib/googleai/veo.js [app-rsc] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var veo_exports = {};
__export(veo_exports, {
    TEST_ONLY: ()=>TEST_ONLY,
    VeoConfigSchema: ()=>VeoConfigSchema,
    defineKnownModels: ()=>defineKnownModels,
    defineModel: ()=>defineModel,
    isVeoModelName: ()=>isVeoModelName,
    listActions: ()=>listActions,
    model: ()=>model
});
module.exports = __toCommonJS(veo_exports);
var import_genkit = __turbopack_context__.r("[project]/node_modules/genkit/lib/index.js [app-rsc] (ecmascript)");
var import_model = __turbopack_context__.r("[project]/node_modules/genkit/lib/model.js [app-rsc] (ecmascript)");
var import_client = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/googleai/client.js [app-rsc] (ecmascript)");
var import_utils = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/googleai/utils.js [app-rsc] (ecmascript)");
const VeoConfigSchema = import_genkit.z.object({
    // NOTE: Documentation notes numberOfVideos parameter to pick the number of
    // output videos, but this setting does not seem to work
    negativePrompt: import_genkit.z.string().optional(),
    aspectRatio: import_genkit.z.enum([
        "9:16",
        "16:9"
    ]).describe("Desired aspect ratio of the output video.").optional(),
    personGeneration: import_genkit.z.enum([
        "dont_allow",
        "allow_adult",
        "allow_all"
    ]).describe("Control if/how images of people will be generated by the model.").optional(),
    durationSeconds: import_genkit.z.number().step(1).min(5).max(8).describe("Length of each output video in seconds, between 5 and 8.").optional(),
    enhancePrompt: import_genkit.z.boolean().describe("Enable or disable the prompt rewriter. Enabled by default.").optional()
}).passthrough();
function commonRef(name, info, configSchema = VeoConfigSchema) {
    return (0, import_model.modelRef)({
        name: `googleai/${name}`,
        configSchema,
        info: info ?? {
            supports: {
                media: true,
                multiturn: false,
                tools: false,
                systemRole: false,
                output: [
                    "media"
                ],
                longRunning: true
            }
        }
    });
}
const GENERIC_MODEL = commonRef("veo");
const KNOWN_MODELS = {
    "veo-3.0-generate-preview": commonRef("veo-3.0-generate-preview"),
    "veo-3.0-fast-generate-preview": commonRef("veo-3.0-fast-generate-preview"),
    "veo-2.0-generate-001": commonRef("veo-2.0-generate-001")
};
function isVeoModelName(value) {
    return !!value?.startsWith("veo-");
}
function model(version, config = {}) {
    const name = (0, import_utils.checkModelName)(version);
    return (0, import_model.modelRef)({
        name: `googleai/${name}`,
        config,
        configSchema: VeoConfigSchema,
        info: {
            ...GENERIC_MODEL.info
        }
    });
}
function listActions(models) {
    return models.filter((m)=>m.supportedGenerationMethods.includes("predictLongRunning") && isVeoModelName((0, import_utils.modelName)(m.name))).filter((m)=>!m.description || !m.description.includes("deprecated")).map((m)=>{
        const ref = model(m.name);
        return (0, import_genkit.modelActionMetadata)({
            name: ref.name,
            info: ref.info,
            configSchema: ref.configSchema
        });
    });
}
function defineKnownModels(ai, options) {
    for (const name of Object.keys(KNOWN_MODELS)){
        defineModel(ai, name, options);
    }
}
function defineModel(ai, name, pluginOptions) {
    const ref = model(name);
    const clientOptions = {
        apiVersion: pluginOptions?.apiVersion,
        baseUrl: pluginOptions?.baseUrl
    };
    return ai.defineBackgroundModel({
        name: ref.name,
        ...ref.info,
        configSchema: ref.configSchema,
        async start (request) {
            const apiKey = (0, import_utils.calculateApiKey)(pluginOptions?.apiKey, void 0);
            const veoPredictRequest = {
                instances: [
                    {
                        prompt: (0, import_utils.extractText)(request),
                        image: (0, import_utils.extractVeoImage)(request)
                    }
                ],
                parameters: toVeoParameters(request)
            };
            const response = await (0, import_client.veoPredict)(apiKey, (0, import_utils.extractVersion)(ref), veoPredictRequest, clientOptions);
            return fromVeoOperation(response);
        },
        async check (operation) {
            const apiKey = (0, import_utils.calculateApiKey)(pluginOptions?.apiKey, void 0);
            const response = await (0, import_client.veoCheckOperation)(apiKey, operation.id, clientOptions);
            return fromVeoOperation(response);
        }
    });
}
function toVeoParameters(request) {
    const out = {
        ...request?.config
    };
    for(const k in out){
        if (out[k] === null) delete out[k];
    }
    delete out.apiKey;
    delete out.version;
    return out;
}
function fromVeoOperation(apiOp) {
    const res = {
        id: apiOp.name
    };
    if (apiOp.done !== void 0) {
        res.done = apiOp.done;
    }
    if (apiOp.error) {
        res.error = {
            message: apiOp.error.message
        };
    }
    if (apiOp.response && apiOp.response.generateVideoResponse && apiOp.response.generateVideoResponse.generatedSamples) {
        res.output = {
            finishReason: "stop",
            raw: apiOp.response,
            message: {
                role: "model",
                content: apiOp.response.generateVideoResponse.generatedSamples.map((s)=>{
                    return {
                        media: {
                            url: s.video.uri
                        }
                    };
                })
            }
        };
    }
    return res;
}
const TEST_ONLY = {
    toVeoParameters,
    fromVeoOperation,
    GENERIC_MODEL,
    KNOWN_MODELS
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    TEST_ONLY,
    VeoConfigSchema,
    defineKnownModels,
    defineModel,
    isVeoModelName,
    listActions,
    model
}); //# sourceMappingURL=veo.js.map
}),
"[project]/node_modules/@genkit-ai/google-genai/lib/googleai/index.js [app-rsc] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toESM = (mod, isNodeMode, target)=>(target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(// If the importer is in node compatibility mode or this is not an ESM
    // file that has been converted to a CommonJS file using a Babel-
    // compatible transform (i.e. "__esModule" has not been set), then set
    // "default" to the CommonJS "module.exports" for node compatibility.
    isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", {
        value: mod,
        enumerable: true
    }) : target, mod));
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var googleai_exports = {};
__export(googleai_exports, {
    default: ()=>googleai_default,
    googleAI: ()=>googleAI,
    googleAIPlugin: ()=>googleAIPlugin
});
module.exports = __toCommonJS(googleai_exports);
var import_logging = __turbopack_context__.r("[project]/node_modules/genkit/lib/logging.js [app-rsc] (ecmascript)");
var import_plugin = __turbopack_context__.r("[project]/node_modules/genkit/lib/plugin.js [app-rsc] (ecmascript)");
var import_utils = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/common/utils.js [app-rsc] (ecmascript)");
var import_client = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/googleai/client.js [app-rsc] (ecmascript)");
var import_utils2 = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/googleai/utils.js [app-rsc] (ecmascript)");
var embedder = __toESM(__turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/googleai/embedder.js [app-rsc] (ecmascript)"));
var gemini = __toESM(__turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/googleai/gemini.js [app-rsc] (ecmascript)"));
var imagen = __toESM(__turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/googleai/imagen.js [app-rsc] (ecmascript)"));
var veo = __toESM(__turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/googleai/veo.js [app-rsc] (ecmascript)"));
async function initializer(ai, options) {
    imagen.defineKnownModels(ai, options);
    gemini.defineKnownModels(ai, options);
    embedder.defineKnownModels(ai, options);
    veo.defineKnownModels(ai, options);
}
async function resolver(ai, actionType, actionName, options) {
    switch(actionType){
        case "model":
            if (veo.isVeoModelName(actionName)) {} else if (imagen.isImagenModelName(actionName)) {
                imagen.defineModel(ai, actionName, options);
            } else {
                gemini.defineModel(ai, actionName, options);
            }
            break;
        case "background-model":
            if (veo.isVeoModelName(actionName)) {
                veo.defineModel(ai, actionName, options);
            }
            break;
        case "embedder":
            embedder.defineEmbedder(ai, actionName, options);
            break;
        default:
    }
}
async function listActions(options) {
    try {
        const apiKey = (0, import_utils2.calculateApiKey)(options?.apiKey, void 0);
        const allModels = await (0, import_client.listModels)(apiKey, {
            baseUrl: options?.baseUrl,
            apiVersion: options?.apiVersion
        });
        return [
            ...gemini.listActions(allModels),
            ...imagen.listActions(allModels),
            ...veo.listActions(allModels),
            ...embedder.listActions(allModels)
        ];
    } catch (e) {
        import_logging.logger.error((0, import_utils.extractErrMsg)(e));
        return [];
    }
}
function googleAIPlugin(options) {
    let listActionsCache;
    return (0, import_plugin.genkitPlugin)("googleai", async (ai)=>await initializer(ai, options), async (ai, actionType, actionName)=>await resolver(ai, actionType, actionName, options || {}), async ()=>{
        if (listActionsCache) return listActionsCache;
        listActionsCache = await listActions(options);
        return listActionsCache;
    });
}
const googleAI = googleAIPlugin;
googleAI.model = (name, config)=>{
    if (veo.isVeoModelName(name)) {
        return veo.model(name, config);
    }
    if (imagen.isImagenModelName(name)) {
        return imagen.model(name, config);
    }
    return gemini.model(name, config);
};
googleAI.embedder = (name, config)=>{
    return embedder.model(name, config);
};
var googleai_default = googleAI;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    googleAI,
    googleAIPlugin
}); //# sourceMappingURL=index.js.map
}),
"[project]/node_modules/@genkit-ai/google-genai/lib/vertexai/utils.js [app-rsc] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var utils_exports = {};
__export(utils_exports, {
    API_KEY_FALSE_ERROR: ()=>API_KEY_FALSE_ERROR,
    MISSING_API_KEY_ERROR: ()=>MISSING_API_KEY_ERROR,
    NOT_SUPPORTED_IN_EXPRESS_ERROR: ()=>NOT_SUPPORTED_IN_EXPRESS_ERROR,
    TEST_ONLY: ()=>TEST_ONLY,
    calculateApiKey: ()=>calculateApiKey,
    checkApiKey: ()=>checkApiKey,
    checkModelName: ()=>import_utils.checkModelName,
    checkSupportedMimeType: ()=>import_utils.checkSupportedMimeType,
    checkSupportedResourceMethod: ()=>checkSupportedResourceMethod,
    cleanSchema: ()=>import_utils.cleanSchema,
    extractMedia: ()=>import_utils.extractMedia,
    extractMimeType: ()=>import_utils.extractMimeType,
    extractText: ()=>import_utils.extractText,
    extractVersion: ()=>import_utils.extractVersion,
    getApiKeyFromEnvVar: ()=>getApiKeyFromEnvVar,
    getDerivedOptions: ()=>getDerivedOptions,
    modelName: ()=>import_utils.modelName
});
module.exports = __toCommonJS(utils_exports);
var import_genkit = __turbopack_context__.r("[project]/node_modules/genkit/lib/index.js [app-rsc] (ecmascript)");
var import_google_auth_library = __turbopack_context__.r("[project]/node_modules/google-auth-library/build/src/index.js [app-rsc] (ecmascript)");
var import_utils = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/common/utils.js [app-rsc] (ecmascript)");
const CLOUD_PLATFORM_OAUTH_SCOPE = "https://www.googleapis.com/auth/cloud-platform";
function parseFirebaseProjectId() {
    if (!process.env.FIREBASE_CONFIG) return void 0;
    try {
        return JSON.parse(process.env.FIREBASE_CONFIG).projectId;
    } catch  {
        return void 0;
    }
}
let __mockDerivedOptions = void 0;
function setMockDerivedOptions(options) {
    __mockDerivedOptions = options;
}
const TEST_ONLY = {
    setMockDerivedOptions
};
async function getDerivedOptions(options, AuthClass = import_google_auth_library.GoogleAuth) {
    if (__mockDerivedOptions) {
        return Promise.resolve(__mockDerivedOptions);
    }
    if (options?.location == "global") {
        return await getGlobalDerivedOptions(AuthClass, options);
    } else if (options?.location) {
        return await getRegionalDerivedOptions(AuthClass, options);
    } else if (options?.apiKey !== void 0) {
        return getExpressDerivedOptions(options);
    }
    try {
        const regionalOptions = await getRegionalDerivedOptions(AuthClass, options);
        return regionalOptions;
    } catch (e) {}
    try {
        const globalOptions = await getGlobalDerivedOptions(AuthClass, options);
        return globalOptions;
    } catch (e) {}
    try {
        const expressOptions = getExpressDerivedOptions(options);
        return expressOptions;
    } catch (e) {}
    throw new import_genkit.GenkitError({
        status: "INVALID_ARGUMENT",
        message: "Unable to determine client options. Please set either apiKey or projectId and location"
    });
}
async function getGlobalDerivedOptions(AuthClass, options) {
    let authOptions = options?.googleAuth;
    let authClient;
    const providedProjectId = options?.projectId || process.env.GCLOUD_PROJECT || parseFirebaseProjectId();
    if (process.env.GCLOUD_SERVICE_ACCOUNT_CREDS) {
        const serviceAccountCreds = JSON.parse(process.env.GCLOUD_SERVICE_ACCOUNT_CREDS);
        authOptions = {
            credentials: serviceAccountCreds,
            scopes: [
                CLOUD_PLATFORM_OAUTH_SCOPE
            ],
            projectId: providedProjectId
        };
        authClient = new AuthClass(authOptions);
    } else {
        authClient = new AuthClass(authOptions ?? {
            scopes: [
                CLOUD_PLATFORM_OAUTH_SCOPE
            ],
            projectId: providedProjectId
        });
    }
    const projectId = options?.projectId || process.env.GCLOUD_PROJECT || await authClient.getProjectId();
    if (!projectId) {
        throw new Error(`VertexAI Plugin is missing the 'project' configuration. Please set the 'GCLOUD_PROJECT' environment variable or explicitly pass 'project' into genkit config.`);
    }
    const clientOpt = {
        kind: "global",
        location: "global",
        projectId,
        authClient
    };
    if (options?.apiKey) {
        clientOpt.apiKey = options.apiKey;
    }
    return clientOpt;
}
function getExpressDerivedOptions(options) {
    const apiKey = checkApiKey(options?.apiKey);
    return {
        kind: "express",
        apiKey
    };
}
async function getRegionalDerivedOptions(AuthClass, options) {
    let authOptions = options?.googleAuth;
    let authClient;
    const providedProjectId = options?.projectId || process.env.GCLOUD_PROJECT || parseFirebaseProjectId();
    if (process.env.GCLOUD_SERVICE_ACCOUNT_CREDS) {
        const serviceAccountCreds = JSON.parse(process.env.GCLOUD_SERVICE_ACCOUNT_CREDS);
        authOptions = {
            credentials: serviceAccountCreds,
            scopes: [
                CLOUD_PLATFORM_OAUTH_SCOPE
            ],
            projectId: providedProjectId
        };
        authClient = new AuthClass(authOptions);
    } else {
        authClient = new AuthClass(authOptions ?? {
            scopes: [
                CLOUD_PLATFORM_OAUTH_SCOPE
            ],
            projectId: providedProjectId
        });
    }
    const projectId = options?.projectId || process.env.GCLOUD_PROJECT || await authClient.getProjectId();
    const location = options?.location || process.env.GCLOUD_LOCATION || "us-central1";
    if ("TURBOPACK compile-time falsy", 0) //TURBOPACK unreachable
    ;
    if (!projectId) {
        throw new Error(`VertexAI Plugin is missing the 'project' configuration. Please set the 'GCLOUD_PROJECT' environment variable or explicitly pass 'project' into genkit config.`);
    }
    const clientOpt = {
        kind: "regional",
        location,
        projectId,
        authClient
    };
    if (options?.apiKey) {
        clientOpt.apiKey = options.apiKey;
    }
    return clientOpt;
}
function getApiKeyFromEnvVar() {
    return process.env.VERTEX_API_KEY || process.env.GOOGLE_API_KEY || process.env.GOOGLE_GENAI_API_KEY;
}
const MISSING_API_KEY_ERROR = new import_genkit.GenkitError({
    status: "FAILED_PRECONDITION",
    message: "Please pass in the API key or set the VERTEX_API_KEY or GOOGLE_API_KEY environment variable.\nFor more details see https://firebase.google.com/docs/genkit/plugins/google-genai"
});
const API_KEY_FALSE_ERROR = new import_genkit.GenkitError({
    status: "INVALID_ARGUMENT",
    message: "VertexAI plugin was initialized with {apiKey: false} but no apiKey configuration was passed at call time."
});
const NOT_SUPPORTED_IN_EXPRESS_ERROR = new import_genkit.GenkitError({
    status: "PERMISSION_DENIED",
    message: "This method or model is not supported in Vertex AI Express Mode.\nFor more details see https://cloud.google.com/vertex-ai/generative-ai/docs/start/express-mode/vertex-ai-express-mode-api-reference"
});
function checkApiKey(pluginApiKey) {
    let apiKey;
    if (pluginApiKey !== false) {
        apiKey = pluginApiKey || getApiKeyFromEnvVar();
    }
    if (pluginApiKey !== false && !apiKey) {
        throw MISSING_API_KEY_ERROR;
    }
    return apiKey;
}
function calculateApiKey(pluginApiKey, requestApiKey) {
    let apiKey;
    if (pluginApiKey !== false) {
        apiKey = pluginApiKey || getApiKeyFromEnvVar();
    }
    apiKey = requestApiKey || apiKey;
    if (pluginApiKey === false && !requestApiKey) {
        throw API_KEY_FALSE_ERROR;
    }
    if (!apiKey) {
        throw MISSING_API_KEY_ERROR;
    }
    return apiKey;
}
function checkSupportedResourceMethod(params) {
    if (params.resourcePath == "") {
        return;
    }
    const supportedExpressMethods = [
        "countTokens",
        "generateContent",
        "streamGenerateContent"
    ];
    if (params.clientOptions.kind === "express" && (!supportedExpressMethods.includes(params.resourceMethod ?? "") || params.resourcePath?.includes("endpoints/"))) {
        throw NOT_SUPPORTED_IN_EXPRESS_ERROR;
    }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    API_KEY_FALSE_ERROR,
    MISSING_API_KEY_ERROR,
    NOT_SUPPORTED_IN_EXPRESS_ERROR,
    TEST_ONLY,
    calculateApiKey,
    checkApiKey,
    checkModelName,
    checkSupportedMimeType,
    checkSupportedResourceMethod,
    cleanSchema,
    extractMedia,
    extractMimeType,
    extractText,
    extractVersion,
    getApiKeyFromEnvVar,
    getDerivedOptions,
    modelName
}); //# sourceMappingURL=utils.js.map
}),
"[project]/node_modules/@genkit-ai/google-genai/lib/vertexai/client.js [app-rsc] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var client_exports = {};
__export(client_exports, {
    TEST_ONLY: ()=>TEST_ONLY,
    embedContent: ()=>embedContent,
    generateContent: ()=>generateContent,
    generateContentStream: ()=>generateContentStream,
    getVertexAIUrl: ()=>getVertexAIUrl,
    imagenPredict: ()=>imagenPredict,
    listModels: ()=>listModels,
    lyriaPredict: ()=>lyriaPredict,
    veoCheckOperation: ()=>veoCheckOperation,
    veoPredict: ()=>veoPredict
});
module.exports = __toCommonJS(client_exports);
var import_utils = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/common/utils.js [app-rsc] (ecmascript)");
var import_utils2 = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/vertexai/utils.js [app-rsc] (ecmascript)");
async function listModels(clientOptions) {
    const url = getVertexAIUrl({
        includeProjectAndLocation: false,
        resourcePath: "publishers/google/models",
        clientOptions
    });
    const fetchOptions = await getFetchOptions({
        method: "GET",
        clientOptions
    });
    const response = await makeRequest(url, fetchOptions);
    const modelResponse = await response.json();
    return modelResponse.publisherModels;
}
async function generateContent(model, generateContentRequest, clientOptions) {
    let url;
    if (model.includes("endpoints/")) {
        url = getVertexAIUrl({
            includeProjectAndLocation: !model.startsWith("projects/"),
            resourcePath: model,
            resourceMethod: "generateContent",
            clientOptions
        });
    } else {
        url = getVertexAIUrl({
            includeProjectAndLocation: true,
            resourcePath: `publishers/google/models/${model}`,
            resourceMethod: "generateContent",
            clientOptions
        });
    }
    const fetchOptions = await getFetchOptions({
        method: "POST",
        clientOptions,
        body: JSON.stringify(generateContentRequest)
    });
    const response = await makeRequest(url, fetchOptions);
    const responseJson = await response.json();
    return responseJson;
}
async function generateContentStream(model, generateContentRequest, clientOptions) {
    let url;
    if (model.includes("endpoints/")) {
        url = getVertexAIUrl({
            includeProjectAndLocation: !model.startsWith("projects/"),
            resourcePath: model,
            resourceMethod: "streamGenerateContent",
            clientOptions
        });
    } else {
        url = getVertexAIUrl({
            includeProjectAndLocation: true,
            resourcePath: `publishers/google/models/${model}`,
            resourceMethod: "streamGenerateContent",
            clientOptions
        });
    }
    const fetchOptions = await getFetchOptions({
        method: "POST",
        clientOptions,
        body: JSON.stringify(generateContentRequest)
    });
    const response = await makeRequest(url, fetchOptions);
    return (0, import_utils.processStream)(response);
}
async function internalPredict(model, body, clientOptions) {
    const url = getVertexAIUrl({
        includeProjectAndLocation: true,
        resourcePath: `publishers/google/models/${model}`,
        resourceMethod: "predict",
        clientOptions
    });
    const fetchOptions = await getFetchOptions({
        method: "POST",
        clientOptions,
        body
    });
    return await makeRequest(url, fetchOptions);
}
async function embedContent(model, embedContentRequest, clientOptions) {
    const response = await internalPredict(model, JSON.stringify(embedContentRequest), clientOptions);
    return response.json();
}
async function imagenPredict(model, imagenPredictRequest, clientOptions) {
    const response = await internalPredict(model, JSON.stringify(imagenPredictRequest), clientOptions);
    return response.json();
}
async function lyriaPredict(model, lyriaPredictRequest, clientOptions) {
    const response = await internalPredict(model, JSON.stringify(lyriaPredictRequest), clientOptions);
    return response.json();
}
async function veoPredict(model, veoPredictRequest, clientOptions) {
    const url = getVertexAIUrl({
        includeProjectAndLocation: true,
        resourcePath: `publishers/google/models/${model}`,
        resourceMethod: "predictLongRunning",
        clientOptions
    });
    const fetchOptions = await getFetchOptions({
        method: "POST",
        clientOptions,
        body: JSON.stringify(veoPredictRequest)
    });
    const response = await makeRequest(url, fetchOptions);
    return response.json();
}
async function veoCheckOperation(model, veoOperationRequest, clientOptions) {
    const url = getVertexAIUrl({
        includeProjectAndLocation: true,
        resourcePath: `publishers/google/models/${model}`,
        resourceMethod: "fetchPredictOperation",
        clientOptions
    });
    const fetchOptions = await getFetchOptions({
        method: "POST",
        clientOptions,
        body: JSON.stringify(veoOperationRequest)
    });
    const response = await makeRequest(url, fetchOptions);
    return response.json();
}
function getVertexAIUrl(params) {
    (0, import_utils2.checkSupportedResourceMethod)(params);
    const DEFAULT_API_VERSION = "v1beta1";
    const API_BASE_PATH = "aiplatform.googleapis.com";
    let basePath;
    if (params.clientOptions.kind == "regional") {
        basePath = `${params.clientOptions.location}-${API_BASE_PATH}`;
    } else {
        basePath = API_BASE_PATH;
    }
    let resourcePath = params.resourcePath;
    if (params.clientOptions.kind != "express" && params.includeProjectAndLocation) {
        const parent = `projects/${params.clientOptions.projectId}/locations/${params.clientOptions.location}`;
        resourcePath = `${parent}/${params.resourcePath}`;
    }
    let url = `https://${basePath}/${DEFAULT_API_VERSION}/${resourcePath}`;
    if (params.resourceMethod) {
        url += `:${params.resourceMethod}`;
    }
    let joiner = "?";
    if (params.queryParams) {
        url += `${joiner}${params.queryParams}`;
        joiner = "&";
    }
    if (params.resourceMethod === "streamGenerateContent") {
        url += `${joiner}alt=sse`;
        joiner = "&";
    }
    return url;
}
async function getFetchOptions(params) {
    const fetchOptions = {
        method: params.method,
        headers: await getHeaders(params.clientOptions)
    };
    if (params.body) {
        fetchOptions.body = params.body;
    }
    const signal = getAbortSignal(params.clientOptions);
    if (signal) {
        fetchOptions.signal = signal;
    }
    return fetchOptions;
}
function getAbortSignal(clientOptions) {
    const hasTimeout = (clientOptions.timeout ?? -1) >= 0;
    if (clientOptions.signal !== void 0 || hasTimeout) {
        const controller = new AbortController();
        if (hasTimeout) {
            setTimeout(()=>controller.abort(), clientOptions.timeout);
        }
        if (clientOptions?.signal) {
            clientOptions.signal.addEventListener("abort", ()=>{
                controller.abort();
            });
        }
        return controller.signal;
    }
    return void 0;
}
async function getHeaders(clientOptions) {
    if (clientOptions.kind == "express") {
        const headers = {
            "x-goog-api-key": (0, import_utils2.calculateApiKey)(clientOptions.apiKey, void 0),
            "Content-Type": "application/json",
            "X-Goog-Api-Client": (0, import_utils.getGenkitClientHeader)(),
            "User-Agent": (0, import_utils.getGenkitClientHeader)()
        };
        return headers;
    } else {
        const token = await getToken(clientOptions.authClient);
        const headers = {
            Authorization: `Bearer ${token}`,
            "x-goog-user-project": clientOptions.projectId,
            "Content-Type": "application/json",
            "X-Goog-Api-Client": (0, import_utils.getGenkitClientHeader)(),
            "User-Agent": (0, import_utils.getGenkitClientHeader)()
        };
        if (clientOptions.apiKey) {
            headers["x-goog-api-key"] = clientOptions.apiKey;
        }
        return headers;
    }
}
async function getToken(authClient) {
    const CREDENTIAL_ERROR_MESSAGE = "\nUnable to authenticate your request        \nDepending on your run time environment, you can get authentication by        \n- if in local instance or cloud shell: `!gcloud auth login`        \n- if in Colab:        \n    -`from google.colab import auth`        \n    -`auth.authenticate_user()`        \n- if in service account or other: please follow guidance in https://cloud.google.com/docs/authentication";
    const token = await authClient.getAccessToken().catch((e)=>{
        throw new Error(CREDENTIAL_ERROR_MESSAGE, e);
    });
    if (!token) {
        throw new Error(CREDENTIAL_ERROR_MESSAGE);
    }
    return token;
}
async function makeRequest(url, fetchOptions) {
    try {
        const response = await fetch(url, fetchOptions);
        if (!response.ok) {
            let errorText = await response.text();
            let errorMessage = errorText;
            try {
                const json = JSON.parse(errorText);
                if (json.error && json.error.message) {
                    errorMessage = json.error.message;
                }
            } catch (e) {}
            throw new Error(`Error fetching from ${url}: [${response.status} ${response.statusText}] ${errorMessage}`);
        }
        return response;
    } catch (e) {
        console.error(e);
        throw new Error(`Failed to fetch from ${url}: ${(0, import_utils.extractErrMsg)(e)}`);
    }
}
const TEST_ONLY = {
    getFetchOptions,
    getAbortSignal,
    getHeaders,
    makeRequest
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    TEST_ONLY,
    embedContent,
    generateContent,
    generateContentStream,
    getVertexAIUrl,
    imagenPredict,
    listModels,
    lyriaPredict,
    veoCheckOperation,
    veoPredict
}); //# sourceMappingURL=client.js.map
}),
"[project]/node_modules/@genkit-ai/google-genai/lib/vertexai/types.js [app-rsc] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var types_exports = {};
__export(types_exports, {
    FunctionCallingMode: ()=>import_types.FunctionCallingMode,
    HarmBlockThreshold: ()=>import_types.HarmBlockThreshold,
    HarmCategory: ()=>import_types.HarmCategory,
    TaskTypeSchema: ()=>import_types.TaskTypeSchema,
    isCodeExecutionTool: ()=>import_types.isCodeExecutionTool,
    isFunctionDeclarationsTool: ()=>import_types.isFunctionDeclarationsTool,
    isGoogleSearchRetrievalTool: ()=>import_types.isGoogleSearchRetrievalTool,
    isMultimodalEmbeddingPrediction: ()=>isMultimodalEmbeddingPrediction,
    isObject: ()=>import_types.isObject,
    isRetrievalTool: ()=>import_types.isRetrievalTool
});
module.exports = __toCommonJS(types_exports);
var import_types = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/common/types.js [app-rsc] (ecmascript)");
function isMultimodalEmbeddingPrediction(value) {
    if (!(0, import_types.isObject)(value)) {
        return false;
    }
    if (!value.textEmbedding && !value.imageEmbedding && !value.videoEmbeddings) {
        return false;
    }
    if (value.textEmbedding && !Array.isArray(value.textEmbedding)) {
        return false;
    }
    if (value.imageEmbedding && !Array.isArray(value.imageEmbedding)) {
        return false;
    }
    if (value.videoEmbeddings && !Array.isArray(value.videoEmbeddings)) {
        return false;
    }
    if (value.videoEmbeddings) {
        for (const emb of value.videoEmbeddings){
            if (!(0, import_types.isObject)(emb)) {
                return false;
            }
            if (!emb.embedding || !Array.isArray(emb.embedding)) {
                return false;
            }
        }
    }
    return true;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    FunctionCallingMode,
    HarmBlockThreshold,
    HarmCategory,
    TaskTypeSchema,
    isCodeExecutionTool,
    isFunctionDeclarationsTool,
    isGoogleSearchRetrievalTool,
    isMultimodalEmbeddingPrediction,
    isObject,
    isRetrievalTool
}); //# sourceMappingURL=types.js.map
}),
"[project]/node_modules/@genkit-ai/google-genai/lib/vertexai/embedder.js [app-rsc] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var embedder_exports = {};
__export(embedder_exports, {
    EmbeddingConfigSchema: ()=>EmbeddingConfigSchema,
    KNOWN_MODELS: ()=>KNOWN_MODELS,
    TEST_ONLY: ()=>TEST_ONLY,
    defineEmbedder: ()=>defineEmbedder,
    defineKnownModels: ()=>defineKnownModels,
    model: ()=>model
});
module.exports = __toCommonJS(embedder_exports);
var import_genkit = __turbopack_context__.r("[project]/node_modules/genkit/lib/index.js [app-rsc] (ecmascript)");
var import_embedder = __turbopack_context__.r("[project]/node_modules/genkit/lib/embedder.js [app-rsc] (ecmascript)");
var import_client = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/vertexai/client.js [app-rsc] (ecmascript)");
var import_types = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/vertexai/types.js [app-rsc] (ecmascript)");
var import_utils = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/vertexai/utils.js [app-rsc] (ecmascript)");
const EmbeddingConfigSchema = import_genkit.z.object({
    /**
   * The `task_type` parameter is defined as the intended downstream application
   * to help the model produce better quality embeddings.
   **/ taskType: import_types.TaskTypeSchema.optional(),
    title: import_genkit.z.string().optional(),
    location: import_genkit.z.string().optional(),
    version: import_genkit.z.string().optional(),
    /**
   * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
   * By default, the model generates embeddings with 768 dimensions.
   * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
   **/ outputDimensionality: import_genkit.z.number().min(1).optional(),
    /**
   * For newly released embedders this parameter provides a hint for the proper
   * way to call the embedder. (Multimodal embedders have a different request
   * structure than non-multimodal embedders).
   * For well-known embedders, this value will be ignored since we will already
   * know if it's multimodal or not.
   */ multimodal: import_genkit.z.boolean().optional()
}).passthrough();
function commonRef(name, info, configSchema = EmbeddingConfigSchema) {
    return (0, import_embedder.embedderRef)({
        name: `vertexai/${name}`,
        configSchema,
        info: info ?? {
            dimensions: 768,
            supports: {
                input: [
                    "text"
                ]
            }
        }
    });
}
const GENERIC_TEXT_MODEL = commonRef("text", {
    dimensions: 3072,
    supports: {
        input: [
            "text"
        ]
    }
});
const GENERIC_MULTIMODAL_MODEL = commonRef("multimodal", {
    dimensions: 768,
    supports: {
        input: [
            "text",
            "image",
            "video"
        ]
    }
});
const KNOWN_MODELS = {
    "text-embedding-005": commonRef("text-embedding-005"),
    "text-multilingual-embedding-002": commonRef("text-multilingual-embedding-002"),
    "multimodalembedding@001": commonRef("multimodalembedding@001", {
        dimensions: 768,
        supports: {
            input: [
                "text",
                "image",
                "video"
            ]
        }
    }),
    "gemini-embedding-001": commonRef("gemini-embedding-001", {
        dimensions: 3072,
        supports: {
            input: [
                "text"
            ]
        }
    })
};
function model(version, config = {}) {
    const name = (0, import_utils.checkModelName)(version);
    if (KNOWN_MODELS[name]) {
        return (0, import_embedder.embedderRef)({
            name: `vertexai/${name}`,
            configSchema: EmbeddingConfigSchema,
            config,
            info: {
                ...KNOWN_MODELS[name].info
            }
        });
    }
    if (config.multimodal) {
        return (0, import_embedder.embedderRef)({
            name: `vertexai/${name}`,
            configSchema: EmbeddingConfigSchema,
            config,
            info: {
                ...GENERIC_MULTIMODAL_MODEL.info
            }
        });
    }
    return (0, import_embedder.embedderRef)({
        name: `vertexai/${name}`,
        configSchema: EmbeddingConfigSchema,
        config,
        info: {
            ...GENERIC_TEXT_MODEL.info
        }
    });
}
function defineKnownModels(ai, clientOptions, pluginOptions) {
    for (const name of Object.keys(KNOWN_MODELS)){
        defineEmbedder(ai, name, clientOptions, pluginOptions);
    }
}
function defineEmbedder(ai, name, clientOptions, pluginOptions) {
    const ref = model(name);
    return ai.defineEmbedder({
        name: ref.name,
        configSchema: ref.configSchema,
        info: ref.info
    }, async (input, options)=>{
        const embedContentRequest = {
            instances: input.map((doc)=>toEmbeddingInstance(ref, doc, options)),
            parameters: {
                outputDimensionality: options?.outputDimensionality
            }
        };
        const response = await (0, import_client.embedContent)((0, import_utils.extractVersion)(ref), embedContentRequest, clientOptions);
        return {
            embeddings: response.predictions.map(toEmbeddingResult).reduce((accumulator, value)=>{
                return accumulator.concat(value);
            }, [])
        };
    });
}
function toEmbeddingInstance(embedder, doc, options) {
    let instance;
    if (isMultiModalEmbedder(embedder) || embedder.config?.multimodal || options?.multimodal) {
        instance = {};
        if (doc.text) {
            instance.text = doc.text;
        }
        for (var media of doc.media){
            if ((0, import_types.isObject)(media) && typeof media.url === "string" && typeof media.contentType === "string") {
                if (media.contentType?.startsWith("image/")) {
                    if (media.url.startsWith("http") || media.url.startsWith("gs://")) {
                        instance.image = {
                            gcsUri: media.url,
                            mimeType: media.contentType
                        };
                    } else {
                        instance.image = {
                            bytesBase64Encoded: media.url,
                            mimeType: media.contentType
                        };
                    }
                } else if (media.contentType.startsWith("video/")) {
                    if (media.url.startsWith("http") || media.url.startsWith("gs://")) {
                        instance.video = {
                            gcsUri: media.url
                        };
                    } else {
                        instance.video = {
                            bytesBase64Encoded: media.url
                        };
                    }
                    if (instance.video && doc.metadata && doc.metadata.videoSegmentConfig) {
                        instance.video.videoSegmentConfig = doc.metadata.videoSegmentConfig;
                    }
                } else {
                    throw new Error(`Unsupported contentType: '${media.contentType}`);
                }
            } else {
                throw new Error("Invalid media specified.");
            }
        }
    } else {
        instance = {
            content: doc.text,
            task_type: options?.taskType,
            title: options?.title
        };
    }
    return instance;
}
function toEmbeddingResult(prediction) {
    if ((0, import_types.isMultimodalEmbeddingPrediction)(prediction)) {
        const eArray = [];
        if (prediction.imageEmbedding?.length) {
            const imageResult = {
                embedding: prediction.imageEmbedding,
                metadata: {
                    embedType: "imageEmbedding"
                }
            };
            eArray.push(imageResult);
        }
        if (prediction.textEmbedding?.length) {
            const textResult = {
                embedding: prediction.textEmbedding,
                metadata: {
                    embedType: "textEmbedding"
                }
            };
            eArray.push(textResult);
        }
        if (prediction.videoEmbeddings?.length) {
            for (const ve of prediction.videoEmbeddings){
                if (ve.embedding?.length) {
                    const { embedding, ...metadata } = ve;
                    metadata.embedType = "videoEmbedding";
                    const videoResult = {
                        embedding,
                        metadata
                    };
                    eArray.push(videoResult);
                }
            }
        }
        return eArray;
    } else {
        return [
            {
                embedding: prediction.embeddings.values
            }
        ];
    }
}
function isMultiModalEmbedder(embedder) {
    if (embedder.config?.multimodal) {
        return true;
    }
    const input = embedder.info?.supports?.input || "";
    return input.includes("text") && input.includes("image") || false;
}
const TEST_ONLY = {
    KNOWN_MODELS
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    EmbeddingConfigSchema,
    KNOWN_MODELS,
    TEST_ONLY,
    defineEmbedder,
    defineKnownModels,
    model
}); //# sourceMappingURL=embedder.js.map
}),
"[project]/node_modules/@genkit-ai/google-genai/lib/vertexai/converters.js [app-rsc] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var converters_exports = {};
__export(converters_exports, {
    fromImagenResponse: ()=>fromImagenResponse,
    fromLyriaResponse: ()=>fromLyriaResponse,
    fromVeoOperation: ()=>fromVeoOperation,
    toGeminiLabels: ()=>toGeminiLabels,
    toGeminiSafetySettings: ()=>toGeminiSafetySettings,
    toImagenPredictRequest: ()=>toImagenPredictRequest,
    toLyriaPredictRequest: ()=>toLyriaPredictRequest,
    toVeoMedia: ()=>toVeoMedia,
    toVeoModel: ()=>toVeoModel,
    toVeoOperationRequest: ()=>toVeoOperationRequest,
    toVeoPredictRequest: ()=>toVeoPredictRequest
});
module.exports = __toCommonJS(converters_exports);
var import_genkit = __turbopack_context__.r("[project]/node_modules/genkit/lib/index.js [app-rsc] (ecmascript)");
var import_model = __turbopack_context__.r("[project]/node_modules/genkit/lib/model.js [app-rsc] (ecmascript)");
var import_utils = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/vertexai/utils.js [app-rsc] (ecmascript)");
function toGeminiSafetySettings(genkitSettings) {
    if (!genkitSettings) return void 0;
    return genkitSettings.map((s)=>{
        return {
            category: s.category,
            threshold: s.threshold
        };
    });
}
function toGeminiLabels(labels) {
    if (!labels) {
        return void 0;
    }
    const keys = Object.keys(labels);
    const newLabels = {};
    for (const key of keys){
        const value = labels[key];
        if (!key) {
            continue;
        }
        newLabels[key] = value;
    }
    if (Object.keys(newLabels).length == 0) {
        return void 0;
    }
    return newLabels;
}
function toImagenPredictRequest(request) {
    return {
        instances: toImagenInstances(request),
        parameters: toImagenParameters(request)
    };
}
function toImagenInstances(request) {
    let instance = {
        prompt: (0, import_utils.extractText)(request)
    };
    const imageMedia = (0, import_utils.extractMedia)(request, {
        metadataType: "image",
        isDefault: true
    });
    if (imageMedia) {
        const image = imageMedia.url.split(",")[1];
        instance.image = {
            bytesBase64Encoded: image
        };
    }
    const maskMedia = (0, import_utils.extractMedia)(request, {
        metadataType: "mask"
    });
    if (maskMedia) {
        const mask = maskMedia.url.split(",")[1];
        instance.mask = {
            image: {
                bytesBase64Encoded: mask
            }
        };
    }
    return [
        instance
    ];
}
function toImagenParameters(request) {
    const params = {
        sampleCount: request.candidates ?? 1,
        ...request?.config
    };
    for(const k in params){
        if (!params[k]) delete params[k];
    }
    return params;
}
function fromImagenPrediction(p, i) {
    const b64data = p.bytesBase64Encoded;
    const mimeType = p.mimeType;
    return {
        index: i,
        finishReason: "stop",
        message: {
            role: "model",
            content: [
                {
                    media: {
                        url: `data:${mimeType};base64,${b64data}`,
                        contentType: mimeType
                    }
                }
            ]
        }
    };
}
function fromImagenResponse(response, request) {
    const candidates = response.predictions.map(fromImagenPrediction);
    return {
        candidates,
        usage: {
            ...(0, import_model.getBasicUsageStats)(request.messages, candidates),
            custom: {
                generations: candidates.length
            }
        },
        custom: response
    };
}
function toLyriaPredictRequest(request) {
    return {
        instances: toLyriaInstances(request),
        parameters: toLyriaParameters(request)
    };
}
function toLyriaInstances(request) {
    let config = {
        ...request.config
    };
    delete config.sampleCount;
    return [
        {
            prompt: (0, import_utils.extractText)(request),
            ...config
        }
    ];
}
function toLyriaParameters(request) {
    return {
        sampleCount: request.config?.sampleCount || 1
    };
}
function fromLyriaPrediction(p, i) {
    const b64data = p.bytesBase64Encoded;
    const mimeType = p.mimeType;
    return {
        index: i,
        finishReason: "stop",
        message: {
            role: "model",
            content: [
                {
                    media: {
                        url: `data:${mimeType};base64,${b64data}`,
                        contentType: mimeType
                    }
                }
            ]
        }
    };
}
function fromLyriaResponse(response, request) {
    const candidates = response.predictions.map(fromLyriaPrediction);
    return {
        candidates,
        usage: {
            ...(0, import_model.getBasicUsageStats)(request.messages, candidates),
            custom: {
                generations: candidates.length
            }
        },
        custom: response
    };
}
function toVeoPredictRequest(request) {
    return {
        instances: toVeoInstances(request),
        parameters: {
            ...request.config
        }
    };
}
function toVeoInstances(request) {
    let instance = {
        prompt: (0, import_utils.extractText)(request)
    };
    const supportedImageTypes = [
        "image/jpeg",
        "image/png"
    ];
    const supportedVideoTypes = [
        "video/mp4"
    ];
    const imageMedia = (0, import_utils.extractMedia)(request, {
        metadataType: "image"
    });
    if (imageMedia) {
        (0, import_utils.checkSupportedMimeType)(imageMedia, supportedImageTypes);
        instance.image = toVeoMedia(imageMedia);
    }
    const lastFrameMedia = (0, import_utils.extractMedia)(request, {
        metadataType: "lastFrame"
    });
    if (lastFrameMedia) {
        (0, import_utils.checkSupportedMimeType)(lastFrameMedia, supportedImageTypes);
        instance.lastFrame = toVeoMedia(lastFrameMedia);
    }
    const videoMedia = (0, import_utils.extractMedia)(request, {
        metadataType: "video"
    });
    if (videoMedia) {
        (0, import_utils.checkSupportedMimeType)(videoMedia, supportedVideoTypes);
        instance.video = toVeoMedia(videoMedia);
    }
    return [
        instance
    ];
}
function toVeoMedia(media) {
    let mimeType = media.contentType;
    if (!mimeType) {
        mimeType = (0, import_utils.extractMimeType)(media.url);
        if (!mimeType) {
            throw new import_genkit.GenkitError({
                status: "INVALID_ARGUMENT",
                message: "Content type is required."
            });
        }
    }
    if (media.url.startsWith("data:")) {
        return {
            bytesBase64Encoded: media.url?.split(",")[1],
            mimeType
        };
    } else if (media.url.startsWith("gs://")) {
        return {
            gcsUri: media.url,
            mimeType
        };
    } else if (media.url.startsWith("http")) {
        throw new import_genkit.GenkitError({
            status: "INVALID_ARGUMENT",
            message: "Veo does not support http(s) URIs. Please specify a Cloud Storage URI."
        });
    } else {
        return {
            bytesBase64Encoded: media.url,
            mimeType
        };
    }
}
function fromVeoOperation(fromOp) {
    const toOp = {
        id: fromOp.name
    };
    if (fromOp.done !== void 0) {
        toOp.done = fromOp.done;
    }
    if (fromOp.error) {
        toOp.error = {
            message: fromOp.error.message
        };
    }
    if (fromOp.response) {
        toOp.output = {
            finishReason: "stop",
            raw: fromOp.response,
            message: {
                role: "model",
                content: fromOp.response.videos.map((veoMedia)=>{
                    if (veoMedia.bytesBase64Encoded) {
                        return {
                            media: {
                                url: `data:${veoMedia.mimeType}:base64,${veoMedia.bytesBase64Encoded}`,
                                contentType: veoMedia.mimeType
                            }
                        };
                    }
                    return {
                        media: {
                            url: veoMedia.gcsUri ?? "",
                            contentType: veoMedia.mimeType
                        }
                    };
                })
            }
        };
    }
    return toOp;
}
function toVeoModel(op) {
    return op.id.substring(op.id.indexOf("models/") + 7, op.id.indexOf("/operations/"));
}
function toVeoOperationRequest(op) {
    return {
        operationName: op.id
    };
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    fromImagenResponse,
    fromLyriaResponse,
    fromVeoOperation,
    toGeminiLabels,
    toGeminiSafetySettings,
    toImagenPredictRequest,
    toLyriaPredictRequest,
    toVeoMedia,
    toVeoModel,
    toVeoOperationRequest,
    toVeoPredictRequest
}); //# sourceMappingURL=converters.js.map
}),
"[project]/node_modules/@genkit-ai/google-genai/lib/vertexai/gemini.js [app-rsc] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var gemini_exports = {};
__export(gemini_exports, {
    GENERIC_MODEL: ()=>GENERIC_MODEL,
    GeminiConfigSchema: ()=>GeminiConfigSchema,
    KNOWN_MODELS: ()=>KNOWN_MODELS,
    SafetySettingsSchema: ()=>SafetySettingsSchema,
    TEST_ONLY: ()=>TEST_ONLY,
    defineKnownModels: ()=>defineKnownModels,
    defineModel: ()=>defineModel,
    isGeminiModelName: ()=>isGeminiModelName,
    listActions: ()=>listActions,
    model: ()=>model
});
module.exports = __toCommonJS(gemini_exports);
var import_genkit = __turbopack_context__.r("[project]/node_modules/genkit/lib/index.js [app-rsc] (ecmascript)");
var import_model = __turbopack_context__.r("[project]/node_modules/genkit/lib/model.js [app-rsc] (ecmascript)");
var import_middleware = __turbopack_context__.r("[project]/node_modules/genkit/lib/middleware.js [app-rsc] (ecmascript)");
var import_tracing = __turbopack_context__.r("[project]/node_modules/genkit/lib/tracing.js [app-rsc] (ecmascript)");
var import_converters = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/common/converters.js [app-rsc] (ecmascript)");
var import_client = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/vertexai/client.js [app-rsc] (ecmascript)");
var import_converters2 = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/vertexai/converters.js [app-rsc] (ecmascript)");
var import_utils = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/vertexai/utils.js [app-rsc] (ecmascript)");
const SafetySettingsSchema = import_genkit.z.object({
    category: import_genkit.z.enum([
        /** The harm category is unspecified. */ "HARM_CATEGORY_UNSPECIFIED",
        /** The harm category is hate speech. */ "HARM_CATEGORY_HATE_SPEECH",
        /** The harm category is dangerous content. */ "HARM_CATEGORY_DANGEROUS_CONTENT",
        /** The harm category is harassment. */ "HARM_CATEGORY_HARASSMENT",
        /** The harm category is sexually explicit content. */ "HARM_CATEGORY_SEXUALLY_EXPLICIT"
    ]),
    threshold: import_genkit.z.enum([
        "BLOCK_LOW_AND_ABOVE",
        "BLOCK_MEDIUM_AND_ABOVE",
        "BLOCK_ONLY_HIGH",
        "BLOCK_NONE"
    ])
});
const VertexRetrievalSchema = import_genkit.z.object({
    datastore: import_genkit.z.object({
        projectId: import_genkit.z.string().describe("Google Cloud Project ID.").optional(),
        location: import_genkit.z.string().describe("Google Cloud region e.g. us-central1.").optional(),
        dataStoreId: import_genkit.z.string().describe('The data store id, when project id and location are provided as separate options. Alternatively, the full path to the data store should be provided in the form: "projects/{project}/locations/{location}/collections/default_collection/dataStores/{data_store}".')
    }).describe("Vertex AI Search data store details"),
    disableAttribution: import_genkit.z.boolean().describe("Disable using the search data in detecting grounding attribution. This does not affect how the result is given to the model for generation.").optional()
});
const GoogleSearchRetrievalSchema = import_genkit.z.object({
    disableAttribution: import_genkit.z.boolean().describe("Disable using the search data in detecting grounding attribution. This does not affect how the result is given to the model for generation.").optional()
});
const GeminiConfigSchema = import_model.GenerationCommonConfigSchema.extend({
    apiKey: import_genkit.z.string().describe("Overrides the plugin-configured API key, if specified.").optional(),
    labels: import_genkit.z.record(import_genkit.z.string()).optional().describe("Key-value labels to attach to the request for cost tracking."),
    temperature: import_genkit.z.number().min(0).max(2).describe(import_model.GenerationCommonConfigDescriptions.temperature + " The default value is 1.0.").optional(),
    topP: import_genkit.z.number().min(0).max(1).describe(import_model.GenerationCommonConfigDescriptions.topP + " The default value is 0.95.").optional(),
    location: import_genkit.z.string().describe("Google Cloud region e.g. us-central1.").optional(),
    /**
   * Safety filter settings. See: https://cloud.google.com/vertex-ai/generative-ai/docs/multimodal/configure-safety-filters#configurable-filters
   *
   * E.g.
   *
   * ```js
   * config: {
   *   safetySettings: [
   *     {
   *       category: 'HARM_CATEGORY_HATE_SPEECH',
   *       threshold: 'BLOCK_LOW_AND_ABOVE',
   *     },
   *     {
   *       category: 'HARM_CATEGORY_DANGEROUS_CONTENT',
   *       threshold: 'BLOCK_MEDIUM_AND_ABOVE',
   *     },
   *     {
   *       category: 'HARM_CATEGORY_HARASSMENT',
   *       threshold: 'BLOCK_ONLY_HIGH',
   *     },
   *     {
   *       category: 'HARM_CATEGORY_SEXUALLY_EXPLICIT',
   *       threshold: 'BLOCK_NONE',
   *     },
   *   ],
   * }
   * ```
   */ safetySettings: import_genkit.z.array(SafetySettingsSchema).describe("Adjust how likely you are to see responses that could be harmful. Content is blocked based on the probability that it is harmful.").optional(),
    /**
   * Vertex retrieval options.
   *
   * E.g.
   *
   * ```js
   *   config: {
   *     vertexRetrieval: {
   *       datastore: {
   *         projectId: 'your-cloud-project',
   *         location: 'us-central1',
   *         collection: 'your-collection',
   *       },
   *       disableAttribution: true,
   *     }
   *   }
   * ```
   */ vertexRetrieval: VertexRetrievalSchema.describe("Retrieve from Vertex AI Search data store for grounding generative responses.").optional(),
    /**
   * Google Search retrieval options.
   *
   * ```js
   *   config: {
   *     googleSearchRetrieval: {
   *       disableAttribution: true,
   *     }
   *   }
   * ```
   */ googleSearchRetrieval: GoogleSearchRetrievalSchema.describe("Retrieve public web data for grounding, powered by Google Search.").optional(),
    /**
   * Function calling options.
   *
   * E.g. forced tool call:
   *
   * ```js
   *   config: {
   *     functionCallingConfig: {
   *       mode: 'ANY',
   *     }
   *   }
   * ```
   */ functionCallingConfig: import_genkit.z.object({
        mode: import_genkit.z.enum([
            "MODE_UNSPECIFIED",
            "AUTO",
            "ANY",
            "NONE"
        ]).optional(),
        allowedFunctionNames: import_genkit.z.array(import_genkit.z.string()).optional()
    }).describe("Controls how the model uses the provided tools (function declarations). With AUTO (Default) mode, the model decides whether to generate a natural language response or suggest a function call based on the prompt and context. With ANY, the model is constrained to always predict a function call and guarantee function schema adherence. With NONE, the model is prohibited from making function calls.").optional(),
    thinkingConfig: import_genkit.z.object({
        includeThoughts: import_genkit.z.boolean().describe("Indicates whether to include thoughts in the response.If true, thoughts are returned only if the model supports thought and thoughts are available.").optional(),
        thinkingBudget: import_genkit.z.number().min(0).max(24576).describe("Indicates the thinking budget in tokens. 0 is DISABLED. -1 is AUTOMATIC. The default values and allowed ranges are model dependent. The thinking budget parameter gives the model guidance on the number of thinking tokens it can use when generating a response. A greater number of tokens is typically associated with more detailed thinking, which is needed for solving more complex tasks. ").optional()
    }).optional()
}).passthrough();
function commonRef(name, info, configSchema = GeminiConfigSchema) {
    return (0, import_model.modelRef)({
        name: `vertexai/${name}`,
        configSchema,
        info: info ?? {
            supports: {
                multiturn: true,
                media: true,
                tools: true,
                toolChoice: true,
                systemRole: true,
                constrained: "no-tools"
            }
        }
    });
}
const GENERIC_MODEL = commonRef("gemini");
const KNOWN_MODELS = {
    "gemini-2.5-flash-lite": commonRef("gemini-2.5-flash-lite"),
    "gemini-2.5-pro": commonRef("gemini-2.5-pro"),
    "gemini-2.5-flash": commonRef("gemini-2.5-flash"),
    "gemini-2.0-flash-001": commonRef("gemini-2.0-flash-001"),
    "gemini-2.0-flash": commonRef("gemini-2.0-flash"),
    "gemini-2.0-flash-lite": commonRef("gemini-2.0-flash-lite"),
    "gemini-2.0-flash-lite-001": commonRef("gemini-2.0-flash-lite-001")
};
function isGeminiModelName(value) {
    return !!value?.startsWith("gemini-") && !value.includes("embedding");
}
function model(version, options = {}) {
    const name = (0, import_utils.checkModelName)(version);
    return (0, import_model.modelRef)({
        name: `vertexai/${name}`,
        config: options,
        configSchema: GeminiConfigSchema,
        info: {
            ...GENERIC_MODEL.info
        }
    });
}
function listActions(models) {
    const KNOWN_DECOMISSIONED_MODELS = [
        "gemini-pro-vision",
        "gemini-pro",
        "gemini-ultra",
        "gemini-ultra-vision"
    ];
    return models.filter((m)=>isGeminiModelName((0, import_utils.modelName)(m.name)) && !KNOWN_DECOMISSIONED_MODELS.includes((0, import_utils.modelName)(m.name) || "")).map((m)=>{
        const ref = model(m.name);
        return (0, import_genkit.modelActionMetadata)({
            name: ref.name,
            info: ref.info,
            configSchema: ref.configSchema
        });
    });
}
function defineKnownModels(ai, clientOptions, pluginOptions) {
    for (const name of Object.keys(KNOWN_MODELS)){
        defineModel(ai, name, clientOptions, pluginOptions);
    }
}
function defineModel(ai, name, clientOptions, pluginOptions) {
    const ref = model(name);
    const middlewares = [];
    if (ref.info?.supports?.media) {
        middlewares.push((0, import_middleware.downloadRequestMedia)({
            maxBytes: 1024 * 1024 * 20,
            filter: (part)=>{
                try {
                    const url = new URL(part.media.url);
                    if (// Gemini can handle these URLs
                    [
                        "www.youtube.com",
                        "youtube.com",
                        "youtu.be"
                    ].includes(url.hostname)) return false;
                } catch  {}
                return true;
            }
        }));
    }
    return ai.defineModel({
        apiVersion: "v2",
        name: ref.name,
        ...ref.info,
        configSchema: ref.configSchema,
        use: middlewares
    }, async (request, { streamingRequested, sendChunk, abortSignal })=>{
        let clientOpt = {
            ...clientOptions,
            signal: abortSignal
        };
        const messages = structuredClone(request.messages);
        if (messages.length === 0) throw new Error("No messages provided.");
        let systemInstruction = void 0;
        const systemMessage = messages.find((m)=>m.role === "system");
        if (systemMessage) {
            messages.splice(messages.indexOf(systemMessage), 1);
            systemInstruction = (0, import_converters.toGeminiSystemInstruction)(systemMessage);
        }
        const requestConfig = {
            ...request.config
        };
        const { apiKey: apiKeyFromConfig, functionCallingConfig, version: versionFromConfig, googleSearchRetrieval, tools: toolsFromConfig, vertexRetrieval, location, safetySettings, labels: labelsFromConfig, ...restOfConfig } = requestConfig;
        if (location && clientOptions.kind != "express" && clientOptions.location != location) {
            if (location == "global") {
                clientOpt = {
                    kind: "global",
                    location: "global",
                    projectId: clientOptions.projectId,
                    authClient: clientOptions.authClient,
                    apiKey: clientOptions.apiKey,
                    signal: abortSignal
                };
            } else {
                clientOpt = {
                    kind: "regional",
                    location,
                    projectId: clientOptions.projectId,
                    authClient: clientOptions.authClient,
                    apiKey: clientOptions.apiKey,
                    signal: abortSignal
                };
            }
        }
        if (clientOptions.kind == "express") {
            clientOpt.apiKey = (0, import_utils.calculateApiKey)(clientOptions.apiKey, apiKeyFromConfig);
        } else if (apiKeyFromConfig) {
            clientOpt.apiKey = apiKeyFromConfig;
        }
        const labels = (0, import_converters2.toGeminiLabels)(labelsFromConfig);
        const tools = [];
        if (request.tools?.length) {
            tools.push({
                functionDeclarations: request.tools.map(import_converters.toGeminiTool)
            });
        }
        let toolConfig;
        if (functionCallingConfig) {
            toolConfig = {
                functionCallingConfig: {
                    allowedFunctionNames: functionCallingConfig.allowedFunctionNames,
                    mode: (0, import_converters.toGeminiFunctionModeEnum)(functionCallingConfig.mode)
                }
            };
        } else if (request.toolChoice) {
            toolConfig = {
                functionCallingConfig: {
                    mode: (0, import_converters.toGeminiFunctionModeEnum)(request.toolChoice)
                }
            };
        }
        const jsonMode = (request.output?.format === "json" || !!request.output?.schema) && tools.length === 0;
        if (toolsFromConfig) {
            tools.push(...toolsFromConfig);
        }
        if (googleSearchRetrieval) {
            if (ref.name.startsWith("vertexai/gemini-1.5")) {
                tools.push({
                    googleSearchRetrieval
                });
            } else {
                tools.push({
                    googleSearch: googleSearchRetrieval
                });
            }
        }
        if (vertexRetrieval) {
            const _projectId = vertexRetrieval.datastore.projectId || (clientOptions.kind != "express" ? clientOptions.projectId : void 0);
            const _location = vertexRetrieval.datastore.location || (clientOptions.kind == "regional" ? clientOptions.location : void 0);
            const _dataStoreId = vertexRetrieval.datastore.dataStoreId;
            if (!_projectId || !_location || !_dataStoreId) {
                throw new import_genkit.GenkitError({
                    status: "INVALID_ARGUMENT",
                    message: "projectId, location and datastoreId are required for vertexRetrieval and could not be determined from configuration"
                });
            }
            const datastore = `projects/${_projectId}/locations/${_location}/collections/default_collection/dataStores/${_dataStoreId}`;
            tools.push({
                retrieval: {
                    vertexAiSearch: {
                        datastore
                    },
                    disableAttribution: vertexRetrieval.disableAttribution
                }
            });
        }
        const generateContentRequest = {
            systemInstruction,
            generationConfig: {
                ...restOfConfig,
                candidateCount: request.candidates || void 0,
                responseMimeType: jsonMode ? "application/json" : void 0
            },
            tools,
            toolConfig,
            safetySettings: (0, import_converters2.toGeminiSafetySettings)(safetySettings),
            contents: messages.map((message)=>(0, import_converters.toGeminiMessage)(message, ref)),
            labels
        };
        const modelVersion = versionFromConfig || (0, import_utils.extractVersion)(ref);
        if (jsonMode && request.output?.constrained) {
            generateContentRequest.generationConfig.responseSchema = (0, import_utils.cleanSchema)(request.output.schema);
        }
        const callGemini = async ()=>{
            let response;
            if (streamingRequested) {
                const result = await (0, import_client.generateContentStream)(modelVersion, generateContentRequest, clientOpt);
                for await (const item of result.stream){
                    item.candidates?.forEach((candidate)=>{
                        const c = (0, import_converters.fromGeminiCandidate)(candidate);
                        sendChunk({
                            index: c.index,
                            content: c.message.content
                        });
                    });
                }
                response = await result.response;
            } else {
                response = await (0, import_client.generateContent)(modelVersion, generateContentRequest, clientOpt);
            }
            if (!response.candidates?.length) {
                throw new import_genkit.GenkitError({
                    status: "FAILED_PRECONDITION",
                    message: "No valid candidates returned."
                });
            }
            const candidateData = response.candidates.map((c)=>(0, import_converters.fromGeminiCandidate)(c));
            return {
                candidates: candidateData,
                custom: response,
                usage: {
                    ...(0, import_model.getBasicUsageStats)(request.messages, candidateData),
                    inputTokens: response.usageMetadata?.promptTokenCount,
                    outputTokens: response.usageMetadata?.candidatesTokenCount,
                    thoughtsTokens: response.usageMetadata?.thoughtsTokenCount,
                    totalTokens: response.usageMetadata?.totalTokenCount,
                    cachedContentTokens: response.usageMetadata?.cachedContentTokenCount
                }
            };
        };
        const msg = (0, import_converters.toGeminiMessage)(messages[messages.length - 1], ref);
        return pluginOptions?.experimental_debugTraces ? await (0, import_tracing.runInNewSpan)(ai.registry, {
            metadata: {
                name: streamingRequested ? "sendMessageStream" : "sendMessage"
            }
        }, async (metadata)=>{
            metadata.input = {
                apiEndpoint: (0, import_client.getVertexAIUrl)({
                    includeProjectAndLocation: false,
                    resourcePath: "",
                    clientOptions: clientOpt
                }),
                cache: {},
                model: modelVersion,
                generateContentOptions: generateContentRequest,
                parts: msg.parts,
                options: clientOpt
            };
            const response = await callGemini();
            metadata.output = response.custom;
            return response;
        }) : await callGemini();
    });
}
const TEST_ONLY = {
    KNOWN_MODELS
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    GENERIC_MODEL,
    GeminiConfigSchema,
    KNOWN_MODELS,
    SafetySettingsSchema,
    TEST_ONLY,
    defineKnownModels,
    defineModel,
    isGeminiModelName,
    listActions,
    model
}); //# sourceMappingURL=gemini.js.map
}),
"[project]/node_modules/@genkit-ai/google-genai/lib/vertexai/imagen.js [app-rsc] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var imagen_exports = {};
__export(imagen_exports, {
    ImagenConfigSchema: ()=>ImagenConfigSchema,
    KNOWN_MODELS: ()=>KNOWN_MODELS,
    TEST_ONLY: ()=>TEST_ONLY,
    defineKnownModels: ()=>defineKnownModels,
    defineModel: ()=>defineModel,
    isImagenModelName: ()=>isImagenModelName,
    listActions: ()=>listActions,
    model: ()=>model
});
module.exports = __toCommonJS(imagen_exports);
var import_genkit = __turbopack_context__.r("[project]/node_modules/genkit/lib/index.js [app-rsc] (ecmascript)");
var import_model = __turbopack_context__.r("[project]/node_modules/genkit/lib/model.js [app-rsc] (ecmascript)");
var import_client = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/vertexai/client.js [app-rsc] (ecmascript)");
var import_converters = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/vertexai/converters.js [app-rsc] (ecmascript)");
var import_utils = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/vertexai/utils.js [app-rsc] (ecmascript)");
const ImagenConfigSchema = import_model.GenerationCommonConfigSchema.extend({
    // TODO: Remove common config schema extension since Imagen models don't support
    // most of the common config parameters. Also, add more parameters like sampleCount
    // from the above reference.
    language: import_genkit.z.enum([
        "auto",
        "en",
        "es",
        "hi",
        "ja",
        "ko",
        "pt",
        "zh-TW",
        "zh",
        "zh-CN"
    ]).describe("Language of the prompt text.").optional(),
    aspectRatio: import_genkit.z.enum([
        "1:1",
        "9:16",
        "16:9",
        "3:4",
        "4:3"
    ]).describe("Desired aspect ratio of the output image.").optional(),
    negativePrompt: import_genkit.z.string().describe('A description of what to discourage in the generated images. For example: "animals" (removes animals), "blurry" (makes the image clearer), "text" (removes text), or "cropped" (removes cropped images).').optional(),
    seed: import_genkit.z.number().int().min(1).max(2147483647).describe("Controls the randomization of the image generation process. Use the same seed across requests to provide consistency, or change it to introduce variety in the response.").optional(),
    location: import_genkit.z.string().describe("Google Cloud region e.g. us-central1.").optional(),
    personGeneration: import_genkit.z.enum([
        "dont_allow",
        "allow_adult",
        "allow_all"
    ]).describe("Control if/how images of people will be generated by the model.").optional(),
    safetySetting: import_genkit.z.enum([
        "block_most",
        "block_some",
        "block_few",
        "block_fewest"
    ]).describe("Adds a filter level to safety filtering.").optional(),
    addWatermark: import_genkit.z.boolean().describe("Add an invisible watermark to the generated images.").optional(),
    storageUri: import_genkit.z.string().describe("Cloud Storage URI to store the generated images.").optional(),
    mode: import_genkit.z.enum([
        "upscale"
    ]).describe("Mode must be set for upscaling requests.").optional(),
    /**
   * Describes the editing intention for the request.
   *
   * See https://cloud.google.com/vertex-ai/generative-ai/docs/model-reference/imagen-api#edit_images_2 for details.
   */ editConfig: import_genkit.z.object({
        editMode: import_genkit.z.enum([
            "inpainting-insert",
            "inpainting-remove",
            "outpainting",
            "product-image"
        ]).describe("Editing intention for the request.").optional(),
        maskMode: import_genkit.z.object({
            maskType: import_genkit.z.enum([
                "background",
                "foreground",
                "semantic"
            ]).describe('"background" automatically generates a mask for all regions except the primary subject(s) of the image, "foreground" automatically generates a mask for the primary subjects(s) of the image. "semantic" segments one or more of the segmentation classes using class ID.'),
            classes: import_genkit.z.array(import_genkit.z.number()).describe("List of class IDs for segmentation.").length(5).optional()
        }).describe("Prompts the model to generate a mask instead of you needing to provide one. Consequently, when you provide this parameter you can omit a mask object.").optional(),
        maskDilation: import_genkit.z.number().describe("Dilation percentage of the mask provided.").min(0).max(1).optional(),
        guidanceScale: import_genkit.z.number().describe("Controls how much the model adheres to the text prompt. Large values increase output and prompt alignment, but may compromise image quality. Suggested values are 0-9 (low strength), 10-20 (medium strength), 21+ (high strength).").optional(),
        productPosition: import_genkit.z.enum([
            "reposition",
            "fixed"
        ]).describe("Defines whether the product should stay fixed or be repositioned.").optional()
    }).passthrough().optional(),
    upscaleConfig: import_genkit.z.object({
        upscaleFactor: import_genkit.z.enum([
            "x2",
            "x4"
        ]).describe("The factor to upscale the image.")
    }).describe("Configuration for upscaling.").optional()
}).passthrough();
function commonRef(name, info, configSchema = ImagenConfigSchema) {
    return (0, import_model.modelRef)({
        name: `vertexai/${name}`,
        configSchema,
        info: info ?? {
            supports: {
                media: true,
                multiturn: false,
                tools: false,
                toolChoice: false,
                systemRole: false,
                output: [
                    "media"
                ]
            }
        }
    });
}
const GENERIC_MODEL = commonRef("imagen", {
    supports: {
        media: true,
        multiturn: true,
        tools: true,
        systemRole: true,
        output: [
            "media"
        ]
    }
});
const KNOWN_MODELS = {
    "imagen-3.0-generate-002": commonRef("imagen-3.0-generate-002"),
    "imagen-3.0-generate-001": commonRef("imagen-3.0-generate-001"),
    "imagen-3.0-capability-001": commonRef("imagen-3.0-capability-001"),
    "imagen-3.0-fast-generate-001": commonRef("imagen-3.0-fast-generate-001"),
    "imagen-4.0-generate-preview-06-06": commonRef("imagen-4.0-generate-preview-06-06"),
    "imagen-4.0-ultra-generate-preview-06-06": commonRef("imagen-4.0-ultra-generate-preview-06-06")
};
function isImagenModelName(value) {
    return !!value?.startsWith("imagen-");
}
function model(version, config = {}) {
    const name = (0, import_utils.checkModelName)(version);
    if (KNOWN_MODELS[name]) {
        return KNOWN_MODELS[name].withConfig(config);
    }
    return (0, import_model.modelRef)({
        name: `vertexai/${name}`,
        config,
        configSchema: ImagenConfigSchema,
        info: {
            ...GENERIC_MODEL.info
        }
    });
}
function listActions(models) {
    return models.filter((m)=>isImagenModelName((0, import_utils.modelName)(m.name))).map((m)=>{
        const ref = model(m.name);
        return (0, import_genkit.modelActionMetadata)({
            name: ref.name,
            info: ref.info,
            configSchema: ref.configSchema
        });
    });
}
function defineKnownModels(ai, clientOptions, pluginOptions) {
    for (const name of Object.keys(KNOWN_MODELS)){
        defineModel(ai, name, clientOptions, pluginOptions);
    }
}
function defineModel(ai, name, clientOptions, pluginOptions) {
    const ref = model(name);
    return ai.defineModel({
        apiVersion: "v2",
        name: ref.name,
        ...ref.info,
        configSchema: ref.configSchema
    }, async (request, { abortSignal })=>{
        const clientOpt = {
            ...clientOptions,
            signal: abortSignal
        };
        const imagenPredictRequest = (0, import_converters.toImagenPredictRequest)(request);
        const response = await (0, import_client.imagenPredict)((0, import_utils.extractVersion)(ref), imagenPredictRequest, clientOpt);
        if (!response.predictions || response.predictions.length == 0) {
            throw new Error("Model returned no predictions. Possibly due to content filters.");
        }
        return (0, import_converters.fromImagenResponse)(response, request);
    });
}
const TEST_ONLY = {
    GENERIC_MODEL,
    KNOWN_MODELS
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    ImagenConfigSchema,
    KNOWN_MODELS,
    TEST_ONLY,
    defineKnownModels,
    defineModel,
    isImagenModelName,
    listActions,
    model
}); //# sourceMappingURL=imagen.js.map
}),
"[project]/node_modules/@genkit-ai/google-genai/lib/vertexai/lyria.js [app-rsc] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var lyria_exports = {};
__export(lyria_exports, {
    LyriaConfigSchema: ()=>LyriaConfigSchema,
    TEST_ONLY: ()=>TEST_ONLY,
    defineKnownModels: ()=>defineKnownModels,
    defineModel: ()=>defineModel,
    isLyriaModelName: ()=>isLyriaModelName,
    listActions: ()=>listActions,
    model: ()=>model
});
module.exports = __toCommonJS(lyria_exports);
var import_genkit = __turbopack_context__.r("[project]/node_modules/genkit/lib/index.js [app-rsc] (ecmascript)");
var import_client = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/vertexai/client.js [app-rsc] (ecmascript)");
var import_converters = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/vertexai/converters.js [app-rsc] (ecmascript)");
var import_utils = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/vertexai/utils.js [app-rsc] (ecmascript)");
const LyriaConfigSchema = import_genkit.z.object({
    negativePrompt: import_genkit.z.string().optional().describe("Optional. A description of what to exclude from the generated audio."),
    seed: import_genkit.z.number().optional().describe("Optional. A seed for deterministic generation. If provided, the model will attempt to produce the same audio given the same prompt and other parameters. Cannot be used with sample_count in the same request."),
    sampleCount: import_genkit.z.number().optional().describe("Optional. The number of audio samples to generate. Default is 1 if not specified and seed is not used. Cannot be used with seed in the same request.")
}).passthrough();
function commonRef(name, info, configSchema = LyriaConfigSchema) {
    return (0, import_genkit.modelRef)({
        name: `vertexai/${name}`,
        configSchema,
        info: info ?? {
            supports: {
                media: true,
                multiturn: false,
                tools: false,
                systemRole: false,
                output: [
                    "media"
                ]
            }
        }
    });
}
const GENERIC_MODEL = commonRef("lyria");
const KNOWN_MODELS = {
    "lyria-002": commonRef("lyria-002")
};
function isLyriaModelName(value) {
    return !!value?.startsWith("lyria-");
}
function model(version, config = {}) {
    const name = (0, import_utils.checkModelName)(version);
    return (0, import_genkit.modelRef)({
        name: `vertexai/${name}`,
        config,
        configSchema: LyriaConfigSchema,
        info: {
            ...GENERIC_MODEL.info
        }
    });
}
function listActions(models) {
    return models.filter((m)=>isLyriaModelName(m.name)).map((m)=>{
        const ref = model(m.name);
        return (0, import_genkit.modelActionMetadata)({
            name: ref.name,
            info: ref.info,
            configSchema: ref.configSchema
        });
    });
}
function defineKnownModels(ai, clientOptions, pluginOptions) {
    for (const name of Object.keys(KNOWN_MODELS)){
        defineModel(ai, name, clientOptions, pluginOptions);
    }
}
function defineModel(ai, name, clientOptions, pluginOptions) {
    const ref = model(name);
    return ai.defineModel({
        apiVersion: "v2",
        name: ref.name,
        ...ref.info,
        configSchema: ref.configSchema
    }, async (request, { abortSignal })=>{
        const clientOpt = {
            ...clientOptions,
            signal: abortSignal
        };
        const lyriaPredictRequest = (0, import_converters.toLyriaPredictRequest)(request);
        const response = await (0, import_client.lyriaPredict)((0, import_utils.extractVersion)(ref), lyriaPredictRequest, clientOpt);
        if (!response.predictions || response.predictions.length == 0) {
            throw new Error("Model returned no predictions. Possibly due to content filters.");
        }
        return (0, import_converters.fromLyriaResponse)(response, request);
    });
}
const TEST_ONLY = {
    GENERIC_MODEL,
    KNOWN_MODELS
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    LyriaConfigSchema,
    TEST_ONLY,
    defineKnownModels,
    defineModel,
    isLyriaModelName,
    listActions,
    model
}); //# sourceMappingURL=lyria.js.map
}),
"[project]/node_modules/@genkit-ai/google-genai/lib/vertexai/veo.js [app-rsc] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var veo_exports = {};
__export(veo_exports, {
    TEST_ONLY: ()=>TEST_ONLY,
    VeoConfigSchema: ()=>VeoConfigSchema,
    defineKnownModels: ()=>defineKnownModels,
    defineModel: ()=>defineModel,
    isVeoModelName: ()=>isVeoModelName,
    listActions: ()=>listActions,
    model: ()=>model
});
module.exports = __toCommonJS(veo_exports);
var import_genkit = __turbopack_context__.r("[project]/node_modules/genkit/lib/index.js [app-rsc] (ecmascript)");
var import_client = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/vertexai/client.js [app-rsc] (ecmascript)");
var import_converters = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/vertexai/converters.js [app-rsc] (ecmascript)");
var import_utils = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/vertexai/utils.js [app-rsc] (ecmascript)");
const VeoConfigSchema = import_genkit.z.object({
    sampleCount: import_genkit.z.number().optional().describe("Number of output videos"),
    storageUri: import_genkit.z.string().optional().describe("The gcs bucket where to save the generated videos"),
    fps: import_genkit.z.number().optional().describe("Frames per second for video generation"),
    durationSeconds: import_genkit.z.number().optional().describe("Duration of the clip for video generation in seconds"),
    seed: import_genkit.z.number().optional().describe("The RNG seed. If RNG seed is exactly same for each request with unchanged inputs, the prediction results will be consistent. Otherwise, a random RNG seed will be used each time to produce a different result. If the sample count is greater than 1, random seeds will be used for each sample."),
    aspectRatio: import_genkit.z.enum([
        "9:16",
        "16:9"
    ]).optional().describe("The aspect ratio for the generated video"),
    resolution: import_genkit.z.enum([
        "720p",
        "1080p"
    ]).optional().describe("The resolution for the generated video"),
    personGeneration: import_genkit.z.enum([
        "dont_allow",
        "allow_adult",
        "allow_all"
    ]).optional().describe("Specifies the policy for generating persons in videos, including age restrictions"),
    pubsubTopic: import_genkit.z.string().optional().describe("The pubsub topic to publish the video generation progress to"),
    negativePrompt: import_genkit.z.string().optional().describe("In addition to the text context, negative prompts can be explicitly stated here to help generate the video"),
    enhancePrompt: import_genkit.z.boolean().optional().describe("If true, the prompt will be improved before it is used to generate videos. The RNG seed, if provided, will not result in consistent results if prompts are enhanced."),
    generateAudio: import_genkit.z.boolean().optional().describe("If true, audio will be generated along with the video"),
    compressionQuality: import_genkit.z.enum([
        "optimized",
        "lossless"
    ]).default("optimized").optional().describe("Compression quality of the generated video")
}).passthrough();
function commonRef(name, info, configSchema = VeoConfigSchema) {
    return (0, import_genkit.modelRef)({
        name: `vertexai/${name}`,
        configSchema,
        info: info ?? {
            supports: {
                media: true,
                multiturn: false,
                tools: false,
                systemRole: false,
                output: [
                    "media"
                ],
                longRunning: true
            }
        }
    });
}
const GENERIC_MODEL = commonRef("veo");
const KNOWN_MODELS = {
    "veo-2.0-generate-001": commonRef("veo-2.0-generate-001"),
    "veo-3.0-generate-001": commonRef("veo-3.0-generate-001"),
    "veo-3.0-fast-generate-001": commonRef("veo-3.0-fast-generate-001"),
    "veo-3.0-generate-preview": commonRef("veo-3.0-generate-preview"),
    "veo-3.0-fast-generate-preview": commonRef("veo-3.0-fast-generate-preview")
};
function isVeoModelName(value) {
    return !!value?.startsWith("veo-");
}
function model(version, config = {}) {
    const name = (0, import_utils.checkModelName)(version);
    return (0, import_genkit.modelRef)({
        name: `vertexai/${name}`,
        config,
        configSchema: VeoConfigSchema,
        info: {
            ...GENERIC_MODEL.info
        }
    });
}
function listActions(models) {
    return models.filter((m)=>isVeoModelName(m.name)).map((m)=>{
        const ref = model(m.name);
        return (0, import_genkit.modelActionMetadata)({
            name: ref.name,
            info: ref.info,
            configSchema: ref.configSchema
        });
    });
}
function defineKnownModels(ai, clientOptions, pluginOptions) {
    for (const name of Object.keys(KNOWN_MODELS)){
        defineModel(ai, name, clientOptions, pluginOptions);
    }
}
function defineModel(ai, name, clientOptions, pluginOptions) {
    const ref = model(name);
    return ai.defineBackgroundModel({
        name: ref.name,
        ...ref.info,
        configSchema: ref.configSchema,
        async start (request) {
            const veoPredictRequest = (0, import_converters.toVeoPredictRequest)(request);
            const response = await (0, import_client.veoPredict)((0, import_utils.extractVersion)(ref), veoPredictRequest, clientOptions);
            return (0, import_converters.fromVeoOperation)(response);
        },
        async check (operation) {
            const response = await (0, import_client.veoCheckOperation)((0, import_converters.toVeoModel)(operation), (0, import_converters.toVeoOperationRequest)(operation), clientOptions);
            return (0, import_converters.fromVeoOperation)(response);
        }
    });
}
const TEST_ONLY = {
    GENERIC_MODEL,
    KNOWN_MODELS
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    TEST_ONLY,
    VeoConfigSchema,
    defineKnownModels,
    defineModel,
    isVeoModelName,
    listActions,
    model
}); //# sourceMappingURL=veo.js.map
}),
"[project]/node_modules/@genkit-ai/google-genai/lib/vertexai/index.js [app-rsc] (ecmascript)", ((__turbopack_context__, module, exports) => {
"use strict";

var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toESM = (mod, isNodeMode, target)=>(target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(// If the importer is in node compatibility mode or this is not an ESM
    // file that has been converted to a CommonJS file using a Babel-
    // compatible transform (i.e. "__esModule" has not been set), then set
    // "default" to the CommonJS "module.exports" for node compatibility.
    isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", {
        value: mod,
        enumerable: true
    }) : target, mod));
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var vertexai_exports = {};
__export(vertexai_exports, {
    default: ()=>vertexai_default,
    vertexAI: ()=>vertexAI
});
module.exports = __toCommonJS(vertexai_exports);
var import_plugin = __turbopack_context__.r("[project]/node_modules/genkit/lib/plugin.js [app-rsc] (ecmascript)");
var import_client = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/vertexai/client.js [app-rsc] (ecmascript)");
var embedder = __toESM(__turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/vertexai/embedder.js [app-rsc] (ecmascript)"));
var gemini = __toESM(__turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/vertexai/gemini.js [app-rsc] (ecmascript)"));
var imagen = __toESM(__turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/vertexai/imagen.js [app-rsc] (ecmascript)"));
var lyria = __toESM(__turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/vertexai/lyria.js [app-rsc] (ecmascript)"));
var veo = __toESM(__turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/vertexai/veo.js [app-rsc] (ecmascript)"));
var import_utils = __turbopack_context__.r("[project]/node_modules/@genkit-ai/google-genai/lib/vertexai/utils.js [app-rsc] (ecmascript)");
/**
 * @license
 *
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ async function initializer(ai, pluginOptions) {
    const clientOptions = await (0, import_utils.getDerivedOptions)(pluginOptions);
    veo.defineKnownModels(ai, clientOptions, pluginOptions);
    imagen.defineKnownModels(ai, clientOptions, pluginOptions);
    lyria.defineKnownModels(ai, clientOptions, pluginOptions);
    gemini.defineKnownModels(ai, clientOptions, pluginOptions);
    embedder.defineKnownModels(ai, clientOptions, pluginOptions);
}
async function resolver(ai, actionType, actionName, pluginOptions) {
    const clientOptions = await (0, import_utils.getDerivedOptions)(pluginOptions);
    switch(actionType){
        case "model":
            if (lyria.isLyriaModelName(actionName)) {
                lyria.defineModel(ai, actionName, clientOptions, pluginOptions);
            } else if (imagen.isImagenModelName(actionName)) {
                imagen.defineModel(ai, actionName, clientOptions, pluginOptions);
            } else if (veo.isVeoModelName(actionName)) {} else {
                gemini.defineModel(ai, actionName, clientOptions, pluginOptions);
            }
            break;
        case "background-model":
            if (veo.isVeoModelName(actionName)) {
                veo.defineModel(ai, actionName, clientOptions, pluginOptions);
            }
            break;
        case "embedder":
            embedder.defineEmbedder(ai, actionName, clientOptions, pluginOptions);
            break;
        default:
    }
}
async function listActions(options) {
    try {
        const clientOptions = await (0, import_utils.getDerivedOptions)(options);
        const models = await (0, import_client.listModels)(clientOptions);
        return [
            ...gemini.listActions(models),
            ...imagen.listActions(models),
            ...lyria.listActions(models),
            ...veo.listActions(models)
        ];
    } catch (e) {
        return [];
    }
}
function vertexAIPlugin(options) {
    let listActionsCache;
    return (0, import_plugin.genkitPlugin)("vertexai", async (ai)=>await initializer(ai, options), async (ai, actionType, actionName)=>await resolver(ai, actionType, actionName, options), async ()=>{
        if (listActionsCache) return listActionsCache;
        listActionsCache = await listActions(options);
        return listActionsCache;
    });
}
const vertexAI = vertexAIPlugin;
vertexAI.model = (name, config)=>{
    if (imagen.isImagenModelName(name)) {
        return imagen.model(name, config);
    }
    if (lyria.isLyriaModelName(name)) {
        return lyria.model(name, config);
    }
    if (veo.isVeoModelName(name)) {
        return veo.model(name, config);
    }
    return gemini.model(name, config);
};
vertexAI.embedder = (name, config)=>{
    return embedder.model(name, config);
};
var vertexai_default = vertexAI;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    vertexAI
}); //# sourceMappingURL=index.js.map
}),
"[project]/node_modules/@genkit-ai/google-genai/lib/index.mjs [app-rsc] (ecmascript) <locals>", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$google$2d$genai$2f$lib$2f$googleai$2f$index$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/@genkit-ai/google-genai/lib/googleai/index.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$google$2d$genai$2f$lib$2f$vertexai$2f$index$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/@genkit-ai/google-genai/lib/vertexai/index.js [app-rsc] (ecmascript)");
;
;
;
 //# sourceMappingURL=index.mjs.map
}),
];

//# sourceMappingURL=node_modules_%40genkit-ai_google-genai_lib_36b6be9f._.js.map