import { GenkitError } from "./error.js";
const asyncContextKey = "__genkit_AsyncContext";
function getAsyncContext() {
  if (!global[asyncContextKey]) {
    throw new GenkitError({
      status: "FAILED_PRECONDITION",
      message: "Async context is not initialized."
    });
  }
  return global[asyncContextKey];
}
function setAsyncContext(context) {
  if (global[asyncContextKey]) return;
  global[asyncContextKey] = context;
}
export {
  getAsyncContext,
  setAsyncContext
};
//# sourceMappingURL=async-context.mjs.map