import { AsyncLocalStorage } from "node:async_hooks";
import { setAsyncContext } from "./async-context.js";
class NodeAsyncContext {
  asls = {};
  getStore(key) {
    return this.asls[key]?.getStore();
  }
  run(key, store, callback) {
    if (!this.asls[key]) {
      this.asls[key] = new AsyncLocalStorage();
    }
    return this.asls[key].run(store, callback);
  }
}
function initNodeAsyncContext() {
  setAsyncContext(new NodeAsyncContext());
}
export {
  NodeAsyncContext,
  initNodeAsyncContext
};
//# sourceMappingURL=node-async-context.mjs.map