import { GenkitError } from "./error.js";
import { logger } from "./logging.js";
export * from "./tracing/exporter.js";
export * from "./tracing/instrumentation.js";
export * from "./tracing/types.js";
const instrumentationKey = "__GENKIT_TELEMETRY_INSTRUMENTED";
const telemetryProviderKey = "__GENKIT_TELEMETRY_PROVIDER";
async function ensureBasicTelemetryInstrumentation() {
  await checkFirebaseMonitoringAutoInit();
  if (global[instrumentationKey]) {
    return await global[instrumentationKey];
  }
  await enableTelemetry({});
}
async function checkFirebaseMonitoringAutoInit() {
  if (!global[instrumentationKey] && process.env.ENABLE_FIREBASE_MONITORING === "true") {
    try {
      const importModule = new Function(
        "moduleName",
        "return import(moduleName)"
      );
      const firebaseModule = await importModule("@genkit-ai/firebase");
      firebaseModule.enableFirebaseTelemetry();
    } catch (e) {
      logger.warn(
        "It looks like you're trying to enable firebase monitoring, but haven't installed the firebase plugin. Please run `npm i --save @genkit-ai/firebase` and redeploy."
      );
    }
  }
}
function getTelemetryProvider() {
  if (global[telemetryProviderKey]) {
    return global[telemetryProviderKey];
  }
  throw new GenkitError({
    status: "FAILED_PRECONDITION",
    message: "TelemetryProvider is not initialized."
  });
}
function setTelemetryProvider(provider) {
  if (global[telemetryProviderKey]) return;
  global[telemetryProviderKey] = provider;
}
async function enableTelemetry(telemetryConfig) {
  global[instrumentationKey] = telemetryConfig instanceof Promise ? telemetryConfig : Promise.resolve();
  return getTelemetryProvider().enableTelemetry(telemetryConfig);
}
async function flushTracing() {
  return getTelemetryProvider().flushTracing();
}
export {
  enableTelemetry,
  ensureBasicTelemetryInstrumentation,
  flushTracing,
  setTelemetryProvider
};
//# sourceMappingURL=tracing.mjs.map