import { GcpTelemetryConfigOptions } from './types.js';
export { GcpLogger, __addTransportStreamForTesting, __useJsonFormatForTesting } from './gcpLogger.js';
export { GcpOpenTelemetry, __forceFlushSpansForTesting, __getMetricExporterForTesting, __getSpanExporterForTesting } from './gcpOpenTelemetry.js';
import '@opentelemetry/auto-instrumentations-node';
import '@opentelemetry/instrumentation';
import '@opentelemetry/sdk-trace-base';
import 'google-auth-library';
import 'winston';
import 'stream';
import '@opentelemetry/sdk-metrics';
import '@opentelemetry/sdk-node';

/**
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Enables telemetry export to the Google Cloud Observability suite.
 *
 * @param options configuration options
 */
declare function enableGoogleCloudTelemetry(options?: GcpTelemetryConfigOptions): Promise<void>;

export { GcpTelemetryConfigOptions, enableGoogleCloudTelemetry };
