"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __reExport = (target, mod, secondTarget) => (__copyProps(target, mod, "default"), secondTarget && __copyProps(secondTarget, mod, "default"));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var index_exports = {};
__export(index_exports, {
  enableGoogleCloudTelemetry: () => enableGoogleCloudTelemetry
});
module.exports = __toCommonJS(index_exports);
var import_genkit = require("genkit");
var import_logging = require("genkit/logging");
var import_tracing = require("genkit/tracing");
var import_auth = require("./auth.js");
var import_gcpLogger = require("./gcpLogger.js");
var import_gcpOpenTelemetry = require("./gcpOpenTelemetry.js");
var import_defaults = require("./telemetry/defaults.js");
__reExport(index_exports, require("./gcpLogger.js"), module.exports);
__reExport(index_exports, require("./gcpOpenTelemetry.js"), module.exports);
function enableGoogleCloudTelemetry(options) {
  return (0, import_tracing.enableTelemetry)(
    configureGcpPlugin(options).then(async (pluginConfig) => {
      import_logging.logger.init(await new import_gcpLogger.GcpLogger(pluginConfig).getLogger((0, import_genkit.getCurrentEnv)()));
      return new import_gcpOpenTelemetry.GcpOpenTelemetry(pluginConfig).getConfig();
    })
  );
}
async function configureGcpPlugin(options) {
  const envOptions = await (0, import_auth.credentialsFromEnvironment)();
  return {
    projectId: options?.projectId || envOptions.projectId,
    credentials: options?.credentials || envOptions.credentials,
    ...import_defaults.TelemetryConfigs.defaults(options)
  };
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  enableGoogleCloudTelemetry,
  ...require("./gcpLogger.js"),
  ...require("./gcpOpenTelemetry.js")
});
//# sourceMappingURL=index.js.map