"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var engagement_exports = {};
__export(engagement_exports, {
  engagementTelemetry: () => engagementTelemetry
});
module.exports = __toCommonJS(engagement_exports);
var import_api = require("@opentelemetry/api");
var import_genkit = require("genkit");
var import_logging = require("genkit/logging");
var import_metrics = require("../metrics.js");
var import_utils = require("../utils.js");
class EngagementTelemetry {
  /**
   * Wraps the declared metrics in a Genkit-specific, internal namespace.
   */
  _N = import_metrics.internalMetricNamespaceWrap.bind(null, "engagement");
  feedbackCounter = new import_metrics.MetricCounter(this._N("feedback"), {
    description: "Counts calls to genkit flows.",
    valueType: import_api.ValueType.INT
  });
  acceptanceCounter = new import_metrics.MetricCounter(this._N("acceptance"), {
    description: "Tracks unique flow paths per flow.",
    valueType: import_api.ValueType.INT
  });
  tick(span, logInputAndOutput, projectId) {
    const subtype = span.attributes["genkit:metadata:subtype"];
    if (subtype === "userFeedback") {
      this.writeUserFeedback(span, projectId);
      return;
    }
    if (subtype === "userAcceptance") {
      this.writeUserAcceptance(span, projectId);
      return;
    }
    import_logging.logger.warn(`Unknown user engagement subtype: ${subtype}`);
  }
  writeUserFeedback(span, projectId) {
    const attributes = span.attributes;
    const name = this.extractTraceName(attributes);
    const dimensions = {
      name,
      value: attributes["genkit:metadata:feedbackValue"],
      hasText: !!attributes["genkit:metadata:textFeedback"],
      source: "ts",
      sourceVersion: import_genkit.GENKIT_VERSION
    };
    this.feedbackCounter.add(1, dimensions);
    const metadata = {
      ...(0, import_utils.createCommonLogAttributes)(span, projectId),
      feedbackValue: attributes["genkit:metadata:feedbackValue"]
    };
    if (attributes["genkit:metadata:textFeedback"]) {
      metadata["textFeedback"] = (0, import_utils.truncate)(
        attributes["genkit:metadata:textFeedback"]
      );
    }
    import_logging.logger.logStructured(`UserFeedback[${name}]`, metadata);
  }
  writeUserAcceptance(span, projectId) {
    const attributes = span.attributes;
    const name = this.extractTraceName(attributes);
    const dimensions = {
      name,
      value: attributes["genkit:metadata:acceptanceValue"],
      source: "ts",
      sourceVersion: import_genkit.GENKIT_VERSION
    };
    this.acceptanceCounter.add(1, dimensions);
    const metadata = {
      ...(0, import_utils.createCommonLogAttributes)(span, projectId),
      acceptanceValue: attributes["genkit:metadata:acceptanceValue"]
    };
    import_logging.logger.logStructured(`UserAcceptance[${name}]`, metadata);
  }
  extractTraceName(attributes) {
    const path = attributes["genkit:path"];
    if (!path || path === "<unknown>") {
      return "<unknown>";
    }
    const name = path.match("/{(.+)}+");
    return name ? name[1] : "<unknown>";
  }
}
const engagementTelemetry = new EngagementTelemetry();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  engagementTelemetry
});
//# sourceMappingURL=engagement.js.map