"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var feature_exports = {};
__export(feature_exports, {
  featuresTelemetry: () => featuresTelemetry
});
module.exports = __toCommonJS(feature_exports);
var import_api = require("@opentelemetry/api");
var import_core = require("@opentelemetry/core");
var import_genkit = require("genkit");
var import_logging = require("genkit/logging");
var import_tracing = require("genkit/tracing");
var import_metrics = require("../metrics.js");
var import_utils = require("../utils.js");
class FeaturesTelemetry {
  /**
   * Wraps the declared metrics in a Genkit-specific, internal namespace.
   */
  _N = import_metrics.internalMetricNamespaceWrap.bind(null, "feature");
  featureCounter = new import_metrics.MetricCounter(this._N("requests"), {
    description: "Counts calls to genkit features.",
    valueType: import_api.ValueType.INT
  });
  featureLatencies = new import_metrics.MetricHistogram(this._N("latency"), {
    description: "Latencies when calling Genkit features.",
    valueType: import_api.ValueType.DOUBLE,
    unit: "ms"
  });
  tick(span, logInputAndOutput, projectId) {
    const attributes = span.attributes;
    const name = attributes["genkit:name"];
    const path = attributes["genkit:path"];
    const latencyMs = (0, import_core.hrTimeToMilliseconds)(
      (0, import_core.hrTimeDuration)(span.startTime, span.endTime)
    );
    const isRoot = attributes["genkit:isRoot"];
    if (!isRoot) {
      throw new import_genkit.GenkitError({
        status: "FAILED_PRECONDITION",
        message: "FeatureTelemetry tick called with non-root span."
      });
    }
    const state = attributes["genkit:state"];
    if (state === "success") {
      this.writeFeatureSuccess(name, latencyMs);
    } else if (state === "error") {
      const errorName = (0, import_utils.extractErrorName)(span.events) || "<unknown>";
      this.writeFeatureFailure(name, latencyMs, errorName);
    } else {
      import_logging.logger.warn(`Unknown state; ${state}`);
      return;
    }
    if (logInputAndOutput) {
      const input = (0, import_utils.truncate)(attributes["genkit:input"]);
      const output = (0, import_utils.truncate)(attributes["genkit:output"]);
      const sessionId = attributes["genkit:sessionId"];
      const threadName = attributes["genkit:threadName"];
      if (input) {
        this.writeLog(
          span,
          "Input",
          name,
          path,
          input,
          projectId,
          sessionId,
          threadName
        );
      }
      if (output) {
        this.writeLog(
          span,
          "Output",
          name,
          path,
          output,
          projectId,
          sessionId,
          threadName
        );
      }
    }
  }
  writeFeatureSuccess(featureName, latencyMs) {
    const dimensions = {
      name: featureName,
      status: "success",
      source: "ts",
      sourceVersion: import_genkit.GENKIT_VERSION
    };
    this.featureCounter.add(1, dimensions);
    this.featureLatencies.record(latencyMs, dimensions);
  }
  writeFeatureFailure(featureName, latencyMs, errorName) {
    const dimensions = {
      name: featureName,
      status: "failure",
      source: "ts",
      sourceVersion: import_genkit.GENKIT_VERSION,
      error: errorName
    };
    this.featureCounter.add(1, dimensions);
    this.featureLatencies.record(latencyMs, dimensions);
  }
  writeLog(span, tag, featureName, qualifiedPath, content, projectId, sessionId, threadName) {
    const path = (0, import_utils.truncatePath)((0, import_tracing.toDisplayPath)(qualifiedPath));
    const sharedMetadata = {
      ...(0, import_utils.createCommonLogAttributes)(span, projectId),
      path,
      qualifiedPath,
      featureName,
      sessionId,
      threadName
    };
    import_logging.logger.logStructured(`${tag}[${path}, ${featureName}]`, {
      ...sharedMetadata,
      content
    });
  }
}
const featuresTelemetry = new FeaturesTelemetry();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  featuresTelemetry
});
//# sourceMappingURL=feature.js.map