"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var path_exports = {};
__export(path_exports, {
  pathsTelemetry: () => pathsTelemetry
});
module.exports = __toCommonJS(path_exports);
var import_api = require("@opentelemetry/api");
var import_core = require("@opentelemetry/core");
var import_genkit = require("genkit");
var import_logging = require("genkit/logging");
var import_tracing = require("genkit/tracing");
var import_metrics = require("../metrics.js");
var import_utils = require("../utils.js");
class PathsTelemetry {
  /**
   * Wraps the declared metrics in a Genkit-specific, internal namespace.
   */
  _N = import_metrics.internalMetricNamespaceWrap.bind(null, "feature");
  pathCounter = new import_metrics.MetricCounter(this._N("path/requests"), {
    description: "Tracks unique flow paths per flow.",
    valueType: import_api.ValueType.INT
  });
  pathLatencies = new import_metrics.MetricHistogram(this._N("path/latency"), {
    description: "Latencies per flow path.",
    ValueType: import_api.ValueType.DOUBLE,
    unit: "ms"
  });
  tick(span, logInputAndOutput, projectId) {
    const attributes = span.attributes;
    const path = attributes["genkit:path"];
    const isFailureSource = !!span.attributes["genkit:isFailureSource"];
    const state = attributes["genkit:state"];
    if (!path || !isFailureSource || state !== "error") {
      return;
    }
    const sessionId = attributes["genkit:sessionId"];
    const threadName = attributes["genkit:threadName"];
    const errorName = (0, import_utils.extractErrorName)(span.events) || "<unknown>";
    const errorMessage = (0, import_utils.extractErrorMessage)(span.events) || "<unknown>";
    const errorStack = (0, import_utils.extractErrorStack)(span.events) || "";
    const latency = (0, import_core.hrTimeToMilliseconds)(
      (0, import_core.hrTimeDuration)(span.startTime, span.endTime)
    );
    const pathDimensions = {
      featureName: (0, import_utils.extractOuterFeatureNameFromPath)(path),
      status: "failure",
      error: errorName,
      path,
      source: "ts",
      sourceVersion: import_genkit.GENKIT_VERSION
    };
    this.pathCounter.add(1, pathDimensions);
    this.pathLatencies.record(latency, pathDimensions);
    const displayPath = (0, import_utils.truncatePath)((0, import_tracing.toDisplayPath)(path));
    import_logging.logger.logStructuredError(`Error[${displayPath}, ${errorName}]`, {
      ...(0, import_utils.createCommonLogAttributes)(span, projectId),
      path: displayPath,
      qualifiedPath: path,
      name: errorName,
      message: errorMessage,
      stack: errorStack,
      source: "ts",
      sourceVersion: import_genkit.GENKIT_VERSION,
      sessionId,
      threadName
    });
  }
}
const pathsTelemetry = new PathsTelemetry();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  pathsTelemetry
});
//# sourceMappingURL=path.js.map