"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var gemini_exports = {};
__export(gemini_exports, {
  GeminiConfigSchema: () => GeminiConfigSchema,
  GeminiTtsConfigSchema: () => GeminiTtsConfigSchema,
  GemmaConfigSchema: () => GemmaConfigSchema,
  TEST_ONLY: () => TEST_ONLY,
  defineKnownModels: () => defineKnownModels,
  defineModel: () => defineModel,
  isGeminiModelName: () => isGeminiModelName,
  isGemmaModelName: () => isGemmaModelName,
  isTTSModelName: () => isTTSModelName,
  listActions: () => listActions,
  model: () => model
});
module.exports = __toCommonJS(gemini_exports);
var import_genkit = require("genkit");
var import_model = require("genkit/model");
var import_middleware = require("genkit/model/middleware");
var import_tracing = require("genkit/tracing");
var import_converters = require("../common/converters.js");
var import_client = require("./client.js");
var import_utils = require("./utils.js");
const SafetySettingsSchema = import_genkit.z.object({
  category: import_genkit.z.enum([
    "HARM_CATEGORY_UNSPECIFIED",
    "HARM_CATEGORY_HATE_SPEECH",
    "HARM_CATEGORY_SEXUALLY_EXPLICIT",
    "HARM_CATEGORY_HARASSMENT",
    "HARM_CATEGORY_DANGEROUS_CONTENT"
  ]),
  threshold: import_genkit.z.enum([
    "BLOCK_LOW_AND_ABOVE",
    "BLOCK_MEDIUM_AND_ABOVE",
    "BLOCK_ONLY_HIGH",
    "BLOCK_NONE"
  ])
});
const VoiceConfigSchema = import_genkit.z.object({
  prebuiltVoiceConfig: import_genkit.z.object({
    // TODO: Make this an array of objects so we can also specify the description
    // for each voiceName.
    voiceName: import_genkit.z.union([
      import_genkit.z.enum([
        "Zephyr",
        "Puck",
        "Charon",
        "Kore",
        "Fenrir",
        "Leda",
        "Orus",
        "Aoede",
        "Callirrhoe",
        "Autonoe",
        "Enceladus",
        "Iapetus",
        "Umbriel",
        "Algieba",
        "Despina",
        "Erinome",
        "Algenib",
        "Rasalgethi",
        "Laomedeia",
        "Achernar",
        "Alnilam",
        "Schedar",
        "Gacrux",
        "Pulcherrima",
        "Achird",
        "Zubenelgenubi",
        "Vindemiatrix",
        "Sadachbia",
        "Sadaltager",
        "Sulafat"
      ]),
      // To allow any new string values
      import_genkit.z.string()
    ]).describe("Name of the preset voice to use").optional()
  }).describe("Configuration for the prebuilt speaker to use").passthrough().optional()
}).describe("Configuration for the voice to use").passthrough();
const GeminiConfigSchema = import_model.GenerationCommonConfigSchema.extend({
  apiKey: import_genkit.z.string().describe("Overrides the plugin-configured API key, if specified.").optional(),
  safetySettings: import_genkit.z.array(SafetySettingsSchema).describe(
    "Adjust how likely you are to see responses that could be harmful. Content is blocked based on the probability that it is harmful."
  ).optional(),
  codeExecution: import_genkit.z.union([import_genkit.z.boolean(), import_genkit.z.object({}).strict()]).describe("Enables the model to generate and run code.").optional(),
  contextCache: import_genkit.z.boolean().describe(
    "Context caching allows you to save and reuse precomputed input tokens that you wish to use repeatedly."
  ).optional(),
  functionCallingConfig: import_genkit.z.object({
    mode: import_genkit.z.enum(["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]).optional(),
    allowedFunctionNames: import_genkit.z.array(import_genkit.z.string()).optional()
  }).describe(
    "Controls how the model uses the provided tools (function declarations). With AUTO (Default) mode, the model decides whether to generate a natural language response or suggest a function call based on the prompt and context. With ANY, the model is constrained to always predict a function call and guarantee function schema adherence. With NONE, the model is prohibited from making function calls."
  ).optional(),
  responseModalities: import_genkit.z.array(import_genkit.z.enum(["TEXT", "IMAGE", "AUDIO"])).describe(
    "The modalities to be used in response. Only supported for 'gemini-2.0-flash-exp' model at present."
  ).optional(),
  googleSearchRetrieval: import_genkit.z.union([import_genkit.z.boolean(), import_genkit.z.object({}).passthrough()]).describe(
    "Retrieve public web data for grounding, powered by Google Search."
  ).optional(),
  temperature: import_genkit.z.number().min(0).max(2).describe(
    import_model.GenerationCommonConfigDescriptions.temperature + " The default value is 1.0."
  ).optional(),
  topP: import_genkit.z.number().min(0).max(1).describe(
    import_model.GenerationCommonConfigDescriptions.topP + " The default value is 0.95."
  ).optional(),
  thinkingConfig: import_genkit.z.object({
    includeThoughts: import_genkit.z.boolean().describe(
      "Indicates whether to include thoughts in the response.If true, thoughts are returned only if the model supports thought and thoughts are available."
    ).optional(),
    thinkingBudget: import_genkit.z.number().min(0).max(24576).describe(
      "Indicates the thinking budget in tokens. 0 is DISABLED. -1 is AUTOMATIC. The default values and allowed ranges are model dependent. The thinking budget parameter gives the model guidance on the number of thinking tokens it can use when generating a response. A greater number of tokens is typically associated with more detailed thinking, which is needed for solving more complex tasks. "
    ).optional()
  }).optional()
}).passthrough();
const GeminiTtsConfigSchema = GeminiConfigSchema.extend({
  speechConfig: import_genkit.z.object({
    voiceConfig: VoiceConfigSchema.optional(),
    multiSpeakerVoiceConfig: import_genkit.z.object({
      speakerVoiceConfigs: import_genkit.z.array(
        import_genkit.z.object({
          speaker: import_genkit.z.string().describe("Name of the speaker to use"),
          voiceConfig: VoiceConfigSchema
        }).describe(
          "Configuration for a single speaker in a multi speaker setup"
        ).passthrough()
      ).describe("Configuration for all the enabled speaker voices")
    }).describe("Configuration for multi-speaker setup").passthrough().optional()
  }).describe("Speech generation config").passthrough().optional()
}).passthrough();
const GemmaConfigSchema = GeminiConfigSchema.extend({
  temperature: import_genkit.z.number().min(0).max(1).describe(
    import_model.GenerationCommonConfigDescriptions.temperature + " The default value is 1.0."
  ).optional()
}).passthrough();
function commonRef(name, info, configSchema = GeminiConfigSchema) {
  return (0, import_model.modelRef)({
    name: `googleai/${name}`,
    configSchema,
    info: info ?? {
      supports: {
        multiturn: true,
        media: true,
        tools: true,
        toolChoice: true,
        systemRole: true,
        constrained: "no-tools",
        output: ["text", "json"]
      }
    }
  });
}
const GENERIC_MODEL = commonRef("gemini");
const GENERIC_TTS_MODEL = commonRef(
  "gemini-tts",
  {
    supports: {
      multiturn: false,
      media: false,
      tools: false,
      toolChoice: false,
      systemRole: false,
      constrained: "no-tools"
    }
  },
  GeminiTtsConfigSchema
);
const GENERIC_GEMMA_MODEL = commonRef(
  "gemma-generic",
  void 0,
  GemmaConfigSchema
);
const KNOWN_GEMINI_MODELS = {
  "gemini-2.5-pro": commonRef("gemini-2.5-pro"),
  "gemini-2.5-flash": commonRef("gemini-2.5-flash"),
  "gemini-2.5-flash-lite": commonRef("gemini-2.5-flash-lite"),
  "gemini-2.5-flash-image-preview": commonRef("gemini-2.5-flash-image-preview"),
  "gemini-2.0-flash": commonRef("gemini-2.0-flash"),
  "gemini-2.0-flash-preview-image-generation": commonRef(
    "gemini-2.0-flash-preview-image-generation"
  ),
  "gemini-2.0-flash-lite": commonRef("gemini-2.0-flash-lite")
};
function isGeminiModelName(value) {
  return value.startsWith("gemini-") && !value.endsWith("-tts");
}
const KNOWN_TTS_MODELS = {
  "gemini-2.5-flash-preview-tts": commonRef(
    "gemini-2.5-flash-preview-tts",
    { ...GENERIC_TTS_MODEL.info },
    GeminiTtsConfigSchema
  ),
  "gemini-2.5-pro-preview-tts": commonRef(
    "gemini-2.5-pro-preview-tts",
    { ...GENERIC_TTS_MODEL.info },
    GeminiTtsConfigSchema
  )
};
function isTTSModelName(value) {
  return value.startsWith("gemini-") && value.endsWith("-tts");
}
const KNOWN_GEMMA_MODELS = {
  "gemma-3-12b-it": commonRef("gemma-3-12b-it", void 0, GemmaConfigSchema),
  "gemma-3-1b-it": commonRef("gemma-3-1b-it", void 0, GemmaConfigSchema),
  "gemma-3-27b-it": commonRef("gemma-3-27b-it", void 0, GemmaConfigSchema),
  "gemma-3-4b-it": commonRef("gemma-3-4b-it", void 0, GemmaConfigSchema),
  "gemma-3n-e4b-it": commonRef("gemma-3n-e4b-it", void 0, GemmaConfigSchema)
};
function isGemmaModelName(value) {
  return value.startsWith("gemma-");
}
const KNOWN_MODELS = {
  ...KNOWN_GEMINI_MODELS,
  ...KNOWN_TTS_MODELS,
  ...KNOWN_GEMMA_MODELS
};
function model(version, config = {}) {
  const name = (0, import_utils.checkModelName)(version);
  if (isTTSModelName(name)) {
    return (0, import_model.modelRef)({
      name: `googleai/${name}`,
      config,
      configSchema: GeminiTtsConfigSchema,
      info: { ...GENERIC_TTS_MODEL.info }
    });
  }
  if (isGemmaModelName(name)) {
    return (0, import_model.modelRef)({
      name: `googleai/${name}`,
      config,
      configSchema: GemmaConfigSchema,
      info: { ...GENERIC_GEMMA_MODEL.info }
    });
  }
  return (0, import_model.modelRef)({
    name: `googleai/${name}`,
    config,
    configSchema: GeminiConfigSchema,
    info: { ...GENERIC_MODEL.info }
  });
}
function listActions(models) {
  return models.filter((m) => m.supportedGenerationMethods.includes("generateContent")).filter((m) => !m.description || !m.description.includes("deprecated")).map((m) => {
    const ref = model(m.name);
    return (0, import_genkit.modelActionMetadata)({
      name: ref.name,
      info: ref.info,
      configSchema: ref.configSchema
    });
  });
}
function defineKnownModels(ai, options) {
  for (const name of Object.keys(KNOWN_MODELS)) {
    defineModel(ai, name, options);
  }
}
function defineModel(ai, name, pluginOptions) {
  (0, import_utils.checkApiKey)(pluginOptions?.apiKey);
  const ref = model(name);
  const clientOptions = {
    apiVersion: pluginOptions?.apiVersion,
    baseUrl: pluginOptions?.baseUrl
  };
  const middleware = [];
  if (ref.info?.supports?.media) {
    middleware.push(
      (0, import_middleware.downloadRequestMedia)({
        maxBytes: 1024 * 1024 * 10,
        // don't downlaod files that have been uploaded using the Files API
        filter: (part) => {
          try {
            const url = new URL(part.media.url);
            if (
              // Gemini can handle these URLs
              [
                "generativelanguage.googleapis.com",
                "www.youtube.com",
                "youtube.com",
                "youtu.be"
              ].includes(url.hostname)
            )
              return false;
          } catch {
          }
          return true;
        }
      })
    );
  }
  return ai.defineModel(
    {
      apiVersion: "v2",
      name: ref.name,
      ...ref.info,
      configSchema: ref.configSchema,
      use: middleware
    },
    async (request, { streamingRequested, sendChunk, abortSignal }) => {
      const clientOpt = { ...clientOptions, signal: abortSignal };
      const messages = [...request.messages];
      if (messages.length === 0) throw new Error("No messages provided.");
      let systemInstruction = void 0;
      const systemMessage = messages.find((m) => m.role === "system");
      if (systemMessage) {
        messages.splice(messages.indexOf(systemMessage), 1);
        systemInstruction = (0, import_converters.toGeminiSystemInstruction)(systemMessage);
      }
      const tools = [];
      if (request.tools?.length) {
        tools.push({
          functionDeclarations: request.tools.map(import_converters.toGeminiTool)
        });
      }
      const requestOptions = {
        ...request.config
      };
      const {
        apiKey: apiKeyFromConfig,
        safetySettings: safetySettingsFromConfig,
        codeExecution: codeExecutionFromConfig,
        version: versionFromConfig,
        functionCallingConfig,
        googleSearchRetrieval,
        tools: toolsFromConfig,
        ...restOfConfigOptions
      } = requestOptions;
      if (codeExecutionFromConfig) {
        tools.push({
          codeExecution: codeExecutionFromConfig === true ? {} : codeExecutionFromConfig
        });
      }
      if (toolsFromConfig) {
        tools.push(...toolsFromConfig);
      }
      if (googleSearchRetrieval) {
        tools.push({
          googleSearch: googleSearchRetrieval === true ? {} : googleSearchRetrieval
        });
      }
      let toolConfig;
      if (functionCallingConfig) {
        toolConfig = {
          functionCallingConfig: {
            allowedFunctionNames: functionCallingConfig.allowedFunctionNames,
            mode: (0, import_converters.toGeminiFunctionModeEnum)(functionCallingConfig.mode)
          }
        };
      } else if (request.toolChoice) {
        toolConfig = {
          functionCallingConfig: {
            mode: (0, import_converters.toGeminiFunctionModeEnum)(request.toolChoice)
          }
        };
      }
      const jsonMode = request.output?.format === "json" || request.output?.contentType === "application/json" && tools.length === 0;
      const generationConfig = {
        ...restOfConfigOptions,
        candidateCount: request.candidates || void 0,
        responseMimeType: jsonMode ? "application/json" : void 0
      };
      if (request.output?.constrained && jsonMode) {
        generationConfig.responseSchema = (0, import_utils.cleanSchema)(request.output.schema);
      }
      const msg = (0, import_converters.toGeminiMessage)(messages[messages.length - 1], ref);
      let generateContentRequest = {
        systemInstruction,
        generationConfig,
        tools: tools.length ? tools : void 0,
        toolConfig,
        safetySettings: safetySettingsFromConfig?.filter(
          (setting) => setting.category !== "HARM_CATEGORY_UNSPECIFIED"
        ),
        contents: messages.map((message) => (0, import_converters.toGeminiMessage)(message, ref))
      };
      const modelVersion = versionFromConfig || (0, import_utils.extractVersion)(ref);
      const generateApiKey = (0, import_utils.calculateApiKey)(
        pluginOptions?.apiKey,
        requestOptions.apiKey
      );
      const callGemini = async () => {
        let response;
        if (streamingRequested) {
          const result = await (0, import_client.generateContentStream)(
            generateApiKey,
            modelVersion,
            generateContentRequest,
            clientOpt
          );
          for await (const item of result.stream) {
            item.candidates?.forEach((candidate) => {
              const c = (0, import_converters.fromGeminiCandidate)(candidate);
              sendChunk({
                index: c.index,
                content: c.message.content
              });
            });
          }
          response = await result.response;
        } else {
          response = await (0, import_client.generateContent)(
            generateApiKey,
            modelVersion,
            generateContentRequest,
            clientOpt
          );
        }
        const candidates = response.candidates || [];
        if (response.candidates?.["undefined"]) {
          candidates.push(response.candidates["undefined"]);
        }
        if (!candidates.length) {
          throw new import_genkit.GenkitError({
            status: "FAILED_PRECONDITION",
            message: "No valid candidates returned."
          });
        }
        const candidateData = candidates.map(import_converters.fromGeminiCandidate) || [];
        return {
          candidates: candidateData,
          custom: response,
          usage: {
            ...(0, import_model.getBasicUsageStats)(request.messages, candidateData),
            inputTokens: response.usageMetadata?.promptTokenCount,
            outputTokens: response.usageMetadata?.candidatesTokenCount,
            thoughtsTokens: response.usageMetadata?.thoughtsTokenCount,
            totalTokens: response.usageMetadata?.totalTokenCount,
            cachedContentTokens: response.usageMetadata?.cachedContentTokenCount
          }
        };
      };
      return pluginOptions?.experimental_debugTraces ? await (0, import_tracing.runInNewSpan)(
        ai.registry,
        {
          metadata: {
            name: streamingRequested ? "sendMessageStream" : "sendMessage"
          }
        },
        async (metadata) => {
          metadata.input = {
            apiEndpoint: (0, import_client.getGoogleAIUrl)({
              resourcePath: "",
              clientOptions: clientOpt
            }),
            cache: {},
            model: modelVersion,
            generateContentOptions: generateContentRequest,
            parts: msg.parts,
            options: clientOpt
          };
          const response = await callGemini();
          metadata.output = response.custom;
          return response;
        }
      ) : await callGemini();
    }
  );
}
const TEST_ONLY = { KNOWN_MODELS };
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  GeminiConfigSchema,
  GeminiTtsConfigSchema,
  GemmaConfigSchema,
  TEST_ONLY,
  defineKnownModels,
  defineModel,
  isGeminiModelName,
  isGemmaModelName,
  isTTSModelName,
  listActions,
  model
});
//# sourceMappingURL=gemini.js.map