"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var googleai_exports = {};
__export(googleai_exports, {
  default: () => googleai_default,
  googleAI: () => googleAI,
  googleAIPlugin: () => googleAIPlugin
});
module.exports = __toCommonJS(googleai_exports);
var import_logging = require("genkit/logging");
var import_plugin = require("genkit/plugin");
var import_utils = require("../common/utils.js");
var import_client = require("./client.js");
var import_utils2 = require("./utils.js");
var embedder = __toESM(require("./embedder.js"));
var gemini = __toESM(require("./gemini.js"));
var imagen = __toESM(require("./imagen.js"));
var veo = __toESM(require("./veo.js"));
async function initializer(ai, options) {
  imagen.defineKnownModels(ai, options);
  gemini.defineKnownModels(ai, options);
  embedder.defineKnownModels(ai, options);
  veo.defineKnownModels(ai, options);
}
async function resolver(ai, actionType, actionName, options) {
  switch (actionType) {
    case "model":
      if (veo.isVeoModelName(actionName)) {
      } else if (imagen.isImagenModelName(actionName)) {
        imagen.defineModel(ai, actionName, options);
      } else {
        gemini.defineModel(ai, actionName, options);
      }
      break;
    case "background-model":
      if (veo.isVeoModelName(actionName)) {
        veo.defineModel(ai, actionName, options);
      }
      break;
    case "embedder":
      embedder.defineEmbedder(ai, actionName, options);
      break;
    default:
  }
}
async function listActions(options) {
  try {
    const apiKey = (0, import_utils2.calculateApiKey)(options?.apiKey, void 0);
    const allModels = await (0, import_client.listModels)(apiKey, {
      baseUrl: options?.baseUrl,
      apiVersion: options?.apiVersion
    });
    return [
      ...gemini.listActions(allModels),
      ...imagen.listActions(allModels),
      ...veo.listActions(allModels),
      ...embedder.listActions(allModels)
    ];
  } catch (e) {
    import_logging.logger.error((0, import_utils.extractErrMsg)(e));
    return [];
  }
}
function googleAIPlugin(options) {
  let listActionsCache;
  return (0, import_plugin.genkitPlugin)(
    "googleai",
    async (ai) => await initializer(ai, options),
    async (ai, actionType, actionName) => await resolver(ai, actionType, actionName, options || {}),
    async () => {
      if (listActionsCache) return listActionsCache;
      listActionsCache = await listActions(options);
      return listActionsCache;
    }
  );
}
const googleAI = googleAIPlugin;
googleAI.model = (name, config) => {
  if (veo.isVeoModelName(name)) {
    return veo.model(name, config);
  }
  if (imagen.isImagenModelName(name)) {
    return imagen.model(name, config);
  }
  return gemini.model(name, config);
};
googleAI.embedder = (name, config) => {
  return embedder.model(name, config);
};
var googleai_default = googleAI;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  googleAI,
  googleAIPlugin
});
//# sourceMappingURL=index.js.map