"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var utils_exports = {};
__export(utils_exports, {
  API_KEY_FALSE_ERROR: () => API_KEY_FALSE_ERROR,
  MISSING_API_KEY_ERROR: () => MISSING_API_KEY_ERROR,
  calculateApiKey: () => calculateApiKey,
  checkApiKey: () => checkApiKey,
  checkModelName: () => import_utils2.checkModelName,
  cleanSchema: () => import_utils2.cleanSchema,
  extractImagenImage: () => extractImagenImage,
  extractText: () => import_utils2.extractText,
  extractVeoImage: () => extractVeoImage,
  extractVersion: () => import_utils2.extractVersion,
  getApiKeyFromEnvVar: () => getApiKeyFromEnvVar,
  modelName: () => import_utils2.modelName
});
module.exports = __toCommonJS(utils_exports);
var import_genkit = require("genkit");
var import_process = __toESM(require("process"));
var import_utils = require("../common/utils.js");
var import_utils2 = require("../common/utils.js");
function getApiKeyFromEnvVar() {
  return import_process.default.env.GEMINI_API_KEY || import_process.default.env.GOOGLE_API_KEY || import_process.default.env.GOOGLE_GENAI_API_KEY;
}
const MISSING_API_KEY_ERROR = new import_genkit.GenkitError({
  status: "FAILED_PRECONDITION",
  message: "Please pass in the API key or set the GEMINI_API_KEY or GOOGLE_API_KEY environment variable.\nFor more details see https://genkit.dev/docs/plugins/google-genai/"
});
const API_KEY_FALSE_ERROR = new import_genkit.GenkitError({
  status: "INVALID_ARGUMENT",
  message: "GoogleAI plugin was initialized with {apiKey: false} but no apiKey configuration was passed at call time."
});
function checkApiKey(pluginApiKey) {
  let apiKey;
  if (pluginApiKey !== false) {
    apiKey = pluginApiKey || getApiKeyFromEnvVar();
  }
  if (pluginApiKey !== false && !apiKey) {
    throw MISSING_API_KEY_ERROR;
  }
  return apiKey;
}
function calculateApiKey(pluginApiKey, requestApiKey) {
  let apiKey;
  if (pluginApiKey !== false) {
    apiKey = pluginApiKey || getApiKeyFromEnvVar();
  }
  apiKey = requestApiKey || apiKey;
  if (pluginApiKey === false && !requestApiKey) {
    throw API_KEY_FALSE_ERROR;
  }
  if (!apiKey) {
    throw MISSING_API_KEY_ERROR;
  }
  return apiKey;
}
function extractVeoImage(request) {
  const media = request.messages.at(-1)?.content.find((p) => !!p.media)?.media;
  if (media) {
    const img = media.url.split(",")[1];
    if (img && media.contentType) {
      return {
        bytesBase64Encoded: img,
        mimeType: media.contentType
      };
    } else if (img) {
      throw new import_genkit.GenkitError({
        status: "INVALID_ARGUMENT",
        message: "content type is required for images"
      });
    }
  }
  return void 0;
}
function extractImagenImage(request) {
  const image = (0, import_utils.extractMedia)(request, {
    metadataType: "base",
    isDefault: true
  })?.url.split(",")[1];
  if (image) {
    return { bytesBase64Encoded: image };
  }
  return void 0;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  API_KEY_FALSE_ERROR,
  MISSING_API_KEY_ERROR,
  calculateApiKey,
  checkApiKey,
  checkModelName,
  cleanSchema,
  extractImagenImage,
  extractText,
  extractVeoImage,
  extractVersion,
  getApiKeyFromEnvVar,
  modelName
});
//# sourceMappingURL=utils.js.map