import { GenkitError } from "genkit";
import process from "process";
import { extractMedia } from "../common/utils.js";
import {
  checkModelName,
  cleanSchema,
  extractText,
  extractVersion,
  modelName
} from "../common/utils.js";
function getApiKeyFromEnvVar() {
  return process.env.GEMINI_API_KEY || process.env.GOOGLE_API_KEY || process.env.GOOGLE_GENAI_API_KEY;
}
const MISSING_API_KEY_ERROR = new GenkitError({
  status: "FAILED_PRECONDITION",
  message: "Please pass in the API key or set the GEMINI_API_KEY or GOOGLE_API_KEY environment variable.\nFor more details see https://genkit.dev/docs/plugins/google-genai/"
});
const API_KEY_FALSE_ERROR = new GenkitError({
  status: "INVALID_ARGUMENT",
  message: "GoogleAI plugin was initialized with {apiKey: false} but no apiKey configuration was passed at call time."
});
function checkApiKey(pluginApiKey) {
  let apiKey;
  if (pluginApiKey !== false) {
    apiKey = pluginApiKey || getApiKeyFromEnvVar();
  }
  if (pluginApiKey !== false && !apiKey) {
    throw MISSING_API_KEY_ERROR;
  }
  return apiKey;
}
function calculateApiKey(pluginApiKey, requestApiKey) {
  let apiKey;
  if (pluginApiKey !== false) {
    apiKey = pluginApiKey || getApiKeyFromEnvVar();
  }
  apiKey = requestApiKey || apiKey;
  if (pluginApiKey === false && !requestApiKey) {
    throw API_KEY_FALSE_ERROR;
  }
  if (!apiKey) {
    throw MISSING_API_KEY_ERROR;
  }
  return apiKey;
}
function extractVeoImage(request) {
  const media = request.messages.at(-1)?.content.find((p) => !!p.media)?.media;
  if (media) {
    const img = media.url.split(",")[1];
    if (img && media.contentType) {
      return {
        bytesBase64Encoded: img,
        mimeType: media.contentType
      };
    } else if (img) {
      throw new GenkitError({
        status: "INVALID_ARGUMENT",
        message: "content type is required for images"
      });
    }
  }
  return void 0;
}
function extractImagenImage(request) {
  const image = extractMedia(request, {
    metadataType: "base",
    isDefault: true
  })?.url.split(",")[1];
  if (image) {
    return { bytesBase64Encoded: image };
  }
  return void 0;
}
export {
  API_KEY_FALSE_ERROR,
  MISSING_API_KEY_ERROR,
  calculateApiKey,
  checkApiKey,
  checkModelName,
  cleanSchema,
  extractImagenImage,
  extractText,
  extractVeoImage,
  extractVersion,
  getApiKeyFromEnvVar,
  modelName
};
//# sourceMappingURL=utils.mjs.map