"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var veo_exports = {};
__export(veo_exports, {
  TEST_ONLY: () => TEST_ONLY,
  VeoConfigSchema: () => VeoConfigSchema,
  defineKnownModels: () => defineKnownModels,
  defineModel: () => defineModel,
  isVeoModelName: () => isVeoModelName,
  listActions: () => listActions,
  model: () => model
});
module.exports = __toCommonJS(veo_exports);
var import_genkit = require("genkit");
var import_model = require("genkit/model");
var import_client = require("./client.js");
var import_utils = require("./utils.js");
const VeoConfigSchema = import_genkit.z.object({
  // NOTE: Documentation notes numberOfVideos parameter to pick the number of
  // output videos, but this setting does not seem to work
  negativePrompt: import_genkit.z.string().optional(),
  aspectRatio: import_genkit.z.enum(["9:16", "16:9"]).describe("Desired aspect ratio of the output video.").optional(),
  personGeneration: import_genkit.z.enum(["dont_allow", "allow_adult", "allow_all"]).describe(
    "Control if/how images of people will be generated by the model."
  ).optional(),
  durationSeconds: import_genkit.z.number().step(1).min(5).max(8).describe("Length of each output video in seconds, between 5 and 8.").optional(),
  enhancePrompt: import_genkit.z.boolean().describe("Enable or disable the prompt rewriter. Enabled by default.").optional()
}).passthrough();
function commonRef(name, info, configSchema = VeoConfigSchema) {
  return (0, import_model.modelRef)({
    name: `googleai/${name}`,
    configSchema,
    info: info ?? {
      supports: {
        media: true,
        multiturn: false,
        tools: false,
        systemRole: false,
        output: ["media"],
        longRunning: true
      }
    }
    // TODO(ifielker): Remove this cast if we fix longRunning
  });
}
const GENERIC_MODEL = commonRef("veo");
const KNOWN_MODELS = {
  "veo-3.0-generate-preview": commonRef("veo-3.0-generate-preview"),
  "veo-3.0-fast-generate-preview": commonRef("veo-3.0-fast-generate-preview"),
  "veo-2.0-generate-001": commonRef("veo-2.0-generate-001")
};
function isVeoModelName(value) {
  return !!value?.startsWith("veo-");
}
function model(version, config = {}) {
  const name = (0, import_utils.checkModelName)(version);
  return (0, import_model.modelRef)({
    name: `googleai/${name}`,
    config,
    configSchema: VeoConfigSchema,
    info: { ...GENERIC_MODEL.info }
  });
}
function listActions(models) {
  return models.filter(
    (m) => m.supportedGenerationMethods.includes("predictLongRunning") && isVeoModelName((0, import_utils.modelName)(m.name))
  ).filter((m) => !m.description || !m.description.includes("deprecated")).map((m) => {
    const ref = model(m.name);
    return (0, import_genkit.modelActionMetadata)({
      name: ref.name,
      info: ref.info,
      configSchema: ref.configSchema
    });
  });
}
function defineKnownModels(ai, options) {
  for (const name of Object.keys(KNOWN_MODELS)) {
    defineModel(ai, name, options);
  }
}
function defineModel(ai, name, pluginOptions) {
  const ref = model(name);
  const clientOptions = {
    apiVersion: pluginOptions?.apiVersion,
    baseUrl: pluginOptions?.baseUrl
  };
  return ai.defineBackgroundModel({
    name: ref.name,
    ...ref.info,
    configSchema: ref.configSchema,
    async start(request) {
      const apiKey = (0, import_utils.calculateApiKey)(pluginOptions?.apiKey, void 0);
      const veoPredictRequest = {
        instances: [
          {
            prompt: (0, import_utils.extractText)(request),
            image: (0, import_utils.extractVeoImage)(request)
          }
        ],
        parameters: toVeoParameters(request)
      };
      const response = await (0, import_client.veoPredict)(
        apiKey,
        (0, import_utils.extractVersion)(ref),
        veoPredictRequest,
        clientOptions
      );
      return fromVeoOperation(response);
    },
    async check(operation) {
      const apiKey = (0, import_utils.calculateApiKey)(pluginOptions?.apiKey, void 0);
      const response = await (0, import_client.veoCheckOperation)(
        apiKey,
        operation.id,
        clientOptions
      );
      return fromVeoOperation(response);
    }
  });
}
function toVeoParameters(request) {
  const out = {
    ...request?.config
  };
  for (const k in out) {
    if (out[k] === null) delete out[k];
  }
  delete out.apiKey;
  delete out.version;
  return out;
}
function fromVeoOperation(apiOp) {
  const res = { id: apiOp.name };
  if (apiOp.done !== void 0) {
    res.done = apiOp.done;
  }
  if (apiOp.error) {
    res.error = { message: apiOp.error.message };
  }
  if (apiOp.response && apiOp.response.generateVideoResponse && apiOp.response.generateVideoResponse.generatedSamples) {
    res.output = {
      finishReason: "stop",
      raw: apiOp.response,
      message: {
        role: "model",
        content: apiOp.response.generateVideoResponse.generatedSamples.map(
          (s) => {
            return {
              media: {
                url: s.video.uri
              }
            };
          }
        )
      }
    };
  }
  return res;
}
const TEST_ONLY = {
  toVeoParameters,
  fromVeoOperation,
  GENERIC_MODEL,
  KNOWN_MODELS
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  TEST_ONLY,
  VeoConfigSchema,
  defineKnownModels,
  defineModel,
  isVeoModelName,
  listActions,
  model
});
//# sourceMappingURL=veo.js.map