import { z, Genkit } from 'genkit';
import { EmbedderReference, EmbedderAction } from 'genkit/embedder';
import { ClientOptions, VertexPluginOptions } from './types.js';
import 'google-auth-library';
import '../common/types.js';

/**
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

declare const EmbeddingConfigSchema: z.ZodObject<{
    /**
     * The `task_type` parameter is defined as the intended downstream application
     * to help the model produce better quality embeddings.
     **/
    taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
    title: z.ZodOptional<z.ZodString>;
    location: z.ZodOptional<z.ZodString>;
    version: z.ZodOptional<z.ZodString>;
    /**
     * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
     * By default, the model generates embeddings with 768 dimensions.
     * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
     **/
    outputDimensionality: z.ZodOptional<z.ZodNumber>;
    /**
     * For newly released embedders this parameter provides a hint for the proper
     * way to call the embedder. (Multimodal embedders have a different request
     * structure than non-multimodal embedders).
     * For well-known embedders, this value will be ignored since we will already
     * know if it's multimodal or not.
     */
    multimodal: z.ZodOptional<z.ZodBoolean>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    /**
     * The `task_type` parameter is defined as the intended downstream application
     * to help the model produce better quality embeddings.
     **/
    taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
    title: z.ZodOptional<z.ZodString>;
    location: z.ZodOptional<z.ZodString>;
    version: z.ZodOptional<z.ZodString>;
    /**
     * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
     * By default, the model generates embeddings with 768 dimensions.
     * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
     **/
    outputDimensionality: z.ZodOptional<z.ZodNumber>;
    /**
     * For newly released embedders this parameter provides a hint for the proper
     * way to call the embedder. (Multimodal embedders have a different request
     * structure than non-multimodal embedders).
     * For well-known embedders, this value will be ignored since we will already
     * know if it's multimodal or not.
     */
    multimodal: z.ZodOptional<z.ZodBoolean>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    /**
     * The `task_type` parameter is defined as the intended downstream application
     * to help the model produce better quality embeddings.
     **/
    taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
    title: z.ZodOptional<z.ZodString>;
    location: z.ZodOptional<z.ZodString>;
    version: z.ZodOptional<z.ZodString>;
    /**
     * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
     * By default, the model generates embeddings with 768 dimensions.
     * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
     **/
    outputDimensionality: z.ZodOptional<z.ZodNumber>;
    /**
     * For newly released embedders this parameter provides a hint for the proper
     * way to call the embedder. (Multimodal embedders have a different request
     * structure than non-multimodal embedders).
     * For well-known embedders, this value will be ignored since we will already
     * know if it's multimodal or not.
     */
    multimodal: z.ZodOptional<z.ZodBoolean>;
}, z.ZodTypeAny, "passthrough">>;
type EmbeddingConfigSchemaType = typeof EmbeddingConfigSchema;
type EmbeddingConfig = z.infer<EmbeddingConfigSchemaType>;
type ConfigSchemaType = EmbeddingConfigSchemaType;
declare const KNOWN_MODELS: {
    readonly 'text-embedding-005': EmbedderReference<z.ZodObject<{
        /**
         * The `task_type` parameter is defined as the intended downstream application
         * to help the model produce better quality embeddings.
         **/
        taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
        title: z.ZodOptional<z.ZodString>;
        location: z.ZodOptional<z.ZodString>;
        version: z.ZodOptional<z.ZodString>;
        /**
         * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
         * By default, the model generates embeddings with 768 dimensions.
         * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
         **/
        outputDimensionality: z.ZodOptional<z.ZodNumber>;
        /**
         * For newly released embedders this parameter provides a hint for the proper
         * way to call the embedder. (Multimodal embedders have a different request
         * structure than non-multimodal embedders).
         * For well-known embedders, this value will be ignored since we will already
         * know if it's multimodal or not.
         */
        multimodal: z.ZodOptional<z.ZodBoolean>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * The `task_type` parameter is defined as the intended downstream application
         * to help the model produce better quality embeddings.
         **/
        taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
        title: z.ZodOptional<z.ZodString>;
        location: z.ZodOptional<z.ZodString>;
        version: z.ZodOptional<z.ZodString>;
        /**
         * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
         * By default, the model generates embeddings with 768 dimensions.
         * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
         **/
        outputDimensionality: z.ZodOptional<z.ZodNumber>;
        /**
         * For newly released embedders this parameter provides a hint for the proper
         * way to call the embedder. (Multimodal embedders have a different request
         * structure than non-multimodal embedders).
         * For well-known embedders, this value will be ignored since we will already
         * know if it's multimodal or not.
         */
        multimodal: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * The `task_type` parameter is defined as the intended downstream application
         * to help the model produce better quality embeddings.
         **/
        taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
        title: z.ZodOptional<z.ZodString>;
        location: z.ZodOptional<z.ZodString>;
        version: z.ZodOptional<z.ZodString>;
        /**
         * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
         * By default, the model generates embeddings with 768 dimensions.
         * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
         **/
        outputDimensionality: z.ZodOptional<z.ZodNumber>;
        /**
         * For newly released embedders this parameter provides a hint for the proper
         * way to call the embedder. (Multimodal embedders have a different request
         * structure than non-multimodal embedders).
         * For well-known embedders, this value will be ignored since we will already
         * know if it's multimodal or not.
         */
        multimodal: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">>>;
    readonly 'text-multilingual-embedding-002': EmbedderReference<z.ZodObject<{
        /**
         * The `task_type` parameter is defined as the intended downstream application
         * to help the model produce better quality embeddings.
         **/
        taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
        title: z.ZodOptional<z.ZodString>;
        location: z.ZodOptional<z.ZodString>;
        version: z.ZodOptional<z.ZodString>;
        /**
         * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
         * By default, the model generates embeddings with 768 dimensions.
         * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
         **/
        outputDimensionality: z.ZodOptional<z.ZodNumber>;
        /**
         * For newly released embedders this parameter provides a hint for the proper
         * way to call the embedder. (Multimodal embedders have a different request
         * structure than non-multimodal embedders).
         * For well-known embedders, this value will be ignored since we will already
         * know if it's multimodal or not.
         */
        multimodal: z.ZodOptional<z.ZodBoolean>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * The `task_type` parameter is defined as the intended downstream application
         * to help the model produce better quality embeddings.
         **/
        taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
        title: z.ZodOptional<z.ZodString>;
        location: z.ZodOptional<z.ZodString>;
        version: z.ZodOptional<z.ZodString>;
        /**
         * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
         * By default, the model generates embeddings with 768 dimensions.
         * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
         **/
        outputDimensionality: z.ZodOptional<z.ZodNumber>;
        /**
         * For newly released embedders this parameter provides a hint for the proper
         * way to call the embedder. (Multimodal embedders have a different request
         * structure than non-multimodal embedders).
         * For well-known embedders, this value will be ignored since we will already
         * know if it's multimodal or not.
         */
        multimodal: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * The `task_type` parameter is defined as the intended downstream application
         * to help the model produce better quality embeddings.
         **/
        taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
        title: z.ZodOptional<z.ZodString>;
        location: z.ZodOptional<z.ZodString>;
        version: z.ZodOptional<z.ZodString>;
        /**
         * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
         * By default, the model generates embeddings with 768 dimensions.
         * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
         **/
        outputDimensionality: z.ZodOptional<z.ZodNumber>;
        /**
         * For newly released embedders this parameter provides a hint for the proper
         * way to call the embedder. (Multimodal embedders have a different request
         * structure than non-multimodal embedders).
         * For well-known embedders, this value will be ignored since we will already
         * know if it's multimodal or not.
         */
        multimodal: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">>>;
    readonly 'multimodalembedding@001': EmbedderReference<z.ZodObject<{
        /**
         * The `task_type` parameter is defined as the intended downstream application
         * to help the model produce better quality embeddings.
         **/
        taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
        title: z.ZodOptional<z.ZodString>;
        location: z.ZodOptional<z.ZodString>;
        version: z.ZodOptional<z.ZodString>;
        /**
         * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
         * By default, the model generates embeddings with 768 dimensions.
         * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
         **/
        outputDimensionality: z.ZodOptional<z.ZodNumber>;
        /**
         * For newly released embedders this parameter provides a hint for the proper
         * way to call the embedder. (Multimodal embedders have a different request
         * structure than non-multimodal embedders).
         * For well-known embedders, this value will be ignored since we will already
         * know if it's multimodal or not.
         */
        multimodal: z.ZodOptional<z.ZodBoolean>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * The `task_type` parameter is defined as the intended downstream application
         * to help the model produce better quality embeddings.
         **/
        taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
        title: z.ZodOptional<z.ZodString>;
        location: z.ZodOptional<z.ZodString>;
        version: z.ZodOptional<z.ZodString>;
        /**
         * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
         * By default, the model generates embeddings with 768 dimensions.
         * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
         **/
        outputDimensionality: z.ZodOptional<z.ZodNumber>;
        /**
         * For newly released embedders this parameter provides a hint for the proper
         * way to call the embedder. (Multimodal embedders have a different request
         * structure than non-multimodal embedders).
         * For well-known embedders, this value will be ignored since we will already
         * know if it's multimodal or not.
         */
        multimodal: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * The `task_type` parameter is defined as the intended downstream application
         * to help the model produce better quality embeddings.
         **/
        taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
        title: z.ZodOptional<z.ZodString>;
        location: z.ZodOptional<z.ZodString>;
        version: z.ZodOptional<z.ZodString>;
        /**
         * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
         * By default, the model generates embeddings with 768 dimensions.
         * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
         **/
        outputDimensionality: z.ZodOptional<z.ZodNumber>;
        /**
         * For newly released embedders this parameter provides a hint for the proper
         * way to call the embedder. (Multimodal embedders have a different request
         * structure than non-multimodal embedders).
         * For well-known embedders, this value will be ignored since we will already
         * know if it's multimodal or not.
         */
        multimodal: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">>>;
    readonly 'gemini-embedding-001': EmbedderReference<z.ZodObject<{
        /**
         * The `task_type` parameter is defined as the intended downstream application
         * to help the model produce better quality embeddings.
         **/
        taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
        title: z.ZodOptional<z.ZodString>;
        location: z.ZodOptional<z.ZodString>;
        version: z.ZodOptional<z.ZodString>;
        /**
         * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
         * By default, the model generates embeddings with 768 dimensions.
         * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
         **/
        outputDimensionality: z.ZodOptional<z.ZodNumber>;
        /**
         * For newly released embedders this parameter provides a hint for the proper
         * way to call the embedder. (Multimodal embedders have a different request
         * structure than non-multimodal embedders).
         * For well-known embedders, this value will be ignored since we will already
         * know if it's multimodal or not.
         */
        multimodal: z.ZodOptional<z.ZodBoolean>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * The `task_type` parameter is defined as the intended downstream application
         * to help the model produce better quality embeddings.
         **/
        taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
        title: z.ZodOptional<z.ZodString>;
        location: z.ZodOptional<z.ZodString>;
        version: z.ZodOptional<z.ZodString>;
        /**
         * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
         * By default, the model generates embeddings with 768 dimensions.
         * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
         **/
        outputDimensionality: z.ZodOptional<z.ZodNumber>;
        /**
         * For newly released embedders this parameter provides a hint for the proper
         * way to call the embedder. (Multimodal embedders have a different request
         * structure than non-multimodal embedders).
         * For well-known embedders, this value will be ignored since we will already
         * know if it's multimodal or not.
         */
        multimodal: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * The `task_type` parameter is defined as the intended downstream application
         * to help the model produce better quality embeddings.
         **/
        taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
        title: z.ZodOptional<z.ZodString>;
        location: z.ZodOptional<z.ZodString>;
        version: z.ZodOptional<z.ZodString>;
        /**
         * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
         * By default, the model generates embeddings with 768 dimensions.
         * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
         **/
        outputDimensionality: z.ZodOptional<z.ZodNumber>;
        /**
         * For newly released embedders this parameter provides a hint for the proper
         * way to call the embedder. (Multimodal embedders have a different request
         * structure than non-multimodal embedders).
         * For well-known embedders, this value will be ignored since we will already
         * know if it's multimodal or not.
         */
        multimodal: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">>>;
};
declare function model(version: string, config?: EmbeddingConfig): EmbedderReference<ConfigSchemaType>;
declare function defineKnownModels(ai: Genkit, clientOptions: ClientOptions, pluginOptions?: VertexPluginOptions): void;
declare function defineEmbedder(ai: Genkit, name: string, clientOptions: ClientOptions, pluginOptions?: VertexPluginOptions): EmbedderAction<any>;
declare const TEST_ONLY: {
    KNOWN_MODELS: {
        readonly 'text-embedding-005': EmbedderReference<z.ZodObject<{
            /**
             * The `task_type` parameter is defined as the intended downstream application
             * to help the model produce better quality embeddings.
             **/
            taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
            title: z.ZodOptional<z.ZodString>;
            location: z.ZodOptional<z.ZodString>;
            version: z.ZodOptional<z.ZodString>;
            /**
             * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
             * By default, the model generates embeddings with 768 dimensions.
             * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
             **/
            outputDimensionality: z.ZodOptional<z.ZodNumber>;
            /**
             * For newly released embedders this parameter provides a hint for the proper
             * way to call the embedder. (Multimodal embedders have a different request
             * structure than non-multimodal embedders).
             * For well-known embedders, this value will be ignored since we will already
             * know if it's multimodal or not.
             */
            multimodal: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * The `task_type` parameter is defined as the intended downstream application
             * to help the model produce better quality embeddings.
             **/
            taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
            title: z.ZodOptional<z.ZodString>;
            location: z.ZodOptional<z.ZodString>;
            version: z.ZodOptional<z.ZodString>;
            /**
             * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
             * By default, the model generates embeddings with 768 dimensions.
             * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
             **/
            outputDimensionality: z.ZodOptional<z.ZodNumber>;
            /**
             * For newly released embedders this parameter provides a hint for the proper
             * way to call the embedder. (Multimodal embedders have a different request
             * structure than non-multimodal embedders).
             * For well-known embedders, this value will be ignored since we will already
             * know if it's multimodal or not.
             */
            multimodal: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * The `task_type` parameter is defined as the intended downstream application
             * to help the model produce better quality embeddings.
             **/
            taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
            title: z.ZodOptional<z.ZodString>;
            location: z.ZodOptional<z.ZodString>;
            version: z.ZodOptional<z.ZodString>;
            /**
             * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
             * By default, the model generates embeddings with 768 dimensions.
             * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
             **/
            outputDimensionality: z.ZodOptional<z.ZodNumber>;
            /**
             * For newly released embedders this parameter provides a hint for the proper
             * way to call the embedder. (Multimodal embedders have a different request
             * structure than non-multimodal embedders).
             * For well-known embedders, this value will be ignored since we will already
             * know if it's multimodal or not.
             */
            multimodal: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>>;
        readonly 'text-multilingual-embedding-002': EmbedderReference<z.ZodObject<{
            /**
             * The `task_type` parameter is defined as the intended downstream application
             * to help the model produce better quality embeddings.
             **/
            taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
            title: z.ZodOptional<z.ZodString>;
            location: z.ZodOptional<z.ZodString>;
            version: z.ZodOptional<z.ZodString>;
            /**
             * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
             * By default, the model generates embeddings with 768 dimensions.
             * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
             **/
            outputDimensionality: z.ZodOptional<z.ZodNumber>;
            /**
             * For newly released embedders this parameter provides a hint for the proper
             * way to call the embedder. (Multimodal embedders have a different request
             * structure than non-multimodal embedders).
             * For well-known embedders, this value will be ignored since we will already
             * know if it's multimodal or not.
             */
            multimodal: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * The `task_type` parameter is defined as the intended downstream application
             * to help the model produce better quality embeddings.
             **/
            taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
            title: z.ZodOptional<z.ZodString>;
            location: z.ZodOptional<z.ZodString>;
            version: z.ZodOptional<z.ZodString>;
            /**
             * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
             * By default, the model generates embeddings with 768 dimensions.
             * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
             **/
            outputDimensionality: z.ZodOptional<z.ZodNumber>;
            /**
             * For newly released embedders this parameter provides a hint for the proper
             * way to call the embedder. (Multimodal embedders have a different request
             * structure than non-multimodal embedders).
             * For well-known embedders, this value will be ignored since we will already
             * know if it's multimodal or not.
             */
            multimodal: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * The `task_type` parameter is defined as the intended downstream application
             * to help the model produce better quality embeddings.
             **/
            taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
            title: z.ZodOptional<z.ZodString>;
            location: z.ZodOptional<z.ZodString>;
            version: z.ZodOptional<z.ZodString>;
            /**
             * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
             * By default, the model generates embeddings with 768 dimensions.
             * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
             **/
            outputDimensionality: z.ZodOptional<z.ZodNumber>;
            /**
             * For newly released embedders this parameter provides a hint for the proper
             * way to call the embedder. (Multimodal embedders have a different request
             * structure than non-multimodal embedders).
             * For well-known embedders, this value will be ignored since we will already
             * know if it's multimodal or not.
             */
            multimodal: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>>;
        readonly 'multimodalembedding@001': EmbedderReference<z.ZodObject<{
            /**
             * The `task_type` parameter is defined as the intended downstream application
             * to help the model produce better quality embeddings.
             **/
            taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
            title: z.ZodOptional<z.ZodString>;
            location: z.ZodOptional<z.ZodString>;
            version: z.ZodOptional<z.ZodString>;
            /**
             * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
             * By default, the model generates embeddings with 768 dimensions.
             * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
             **/
            outputDimensionality: z.ZodOptional<z.ZodNumber>;
            /**
             * For newly released embedders this parameter provides a hint for the proper
             * way to call the embedder. (Multimodal embedders have a different request
             * structure than non-multimodal embedders).
             * For well-known embedders, this value will be ignored since we will already
             * know if it's multimodal or not.
             */
            multimodal: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * The `task_type` parameter is defined as the intended downstream application
             * to help the model produce better quality embeddings.
             **/
            taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
            title: z.ZodOptional<z.ZodString>;
            location: z.ZodOptional<z.ZodString>;
            version: z.ZodOptional<z.ZodString>;
            /**
             * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
             * By default, the model generates embeddings with 768 dimensions.
             * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
             **/
            outputDimensionality: z.ZodOptional<z.ZodNumber>;
            /**
             * For newly released embedders this parameter provides a hint for the proper
             * way to call the embedder. (Multimodal embedders have a different request
             * structure than non-multimodal embedders).
             * For well-known embedders, this value will be ignored since we will already
             * know if it's multimodal or not.
             */
            multimodal: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * The `task_type` parameter is defined as the intended downstream application
             * to help the model produce better quality embeddings.
             **/
            taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
            title: z.ZodOptional<z.ZodString>;
            location: z.ZodOptional<z.ZodString>;
            version: z.ZodOptional<z.ZodString>;
            /**
             * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
             * By default, the model generates embeddings with 768 dimensions.
             * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
             **/
            outputDimensionality: z.ZodOptional<z.ZodNumber>;
            /**
             * For newly released embedders this parameter provides a hint for the proper
             * way to call the embedder. (Multimodal embedders have a different request
             * structure than non-multimodal embedders).
             * For well-known embedders, this value will be ignored since we will already
             * know if it's multimodal or not.
             */
            multimodal: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>>;
        readonly 'gemini-embedding-001': EmbedderReference<z.ZodObject<{
            /**
             * The `task_type` parameter is defined as the intended downstream application
             * to help the model produce better quality embeddings.
             **/
            taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
            title: z.ZodOptional<z.ZodString>;
            location: z.ZodOptional<z.ZodString>;
            version: z.ZodOptional<z.ZodString>;
            /**
             * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
             * By default, the model generates embeddings with 768 dimensions.
             * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
             **/
            outputDimensionality: z.ZodOptional<z.ZodNumber>;
            /**
             * For newly released embedders this parameter provides a hint for the proper
             * way to call the embedder. (Multimodal embedders have a different request
             * structure than non-multimodal embedders).
             * For well-known embedders, this value will be ignored since we will already
             * know if it's multimodal or not.
             */
            multimodal: z.ZodOptional<z.ZodBoolean>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * The `task_type` parameter is defined as the intended downstream application
             * to help the model produce better quality embeddings.
             **/
            taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
            title: z.ZodOptional<z.ZodString>;
            location: z.ZodOptional<z.ZodString>;
            version: z.ZodOptional<z.ZodString>;
            /**
             * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
             * By default, the model generates embeddings with 768 dimensions.
             * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
             **/
            outputDimensionality: z.ZodOptional<z.ZodNumber>;
            /**
             * For newly released embedders this parameter provides a hint for the proper
             * way to call the embedder. (Multimodal embedders have a different request
             * structure than non-multimodal embedders).
             * For well-known embedders, this value will be ignored since we will already
             * know if it's multimodal or not.
             */
            multimodal: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * The `task_type` parameter is defined as the intended downstream application
             * to help the model produce better quality embeddings.
             **/
            taskType: z.ZodOptional<z.ZodEnum<["RETRIEVAL_DOCUMENT", "RETRIEVAL_QUERY", "SEMANTIC_SIMILARITY", "CLASSIFICATION", "CLUSTERING"]>>;
            title: z.ZodOptional<z.ZodString>;
            location: z.ZodOptional<z.ZodString>;
            version: z.ZodOptional<z.ZodString>;
            /**
             * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
             * By default, the model generates embeddings with 768 dimensions.
             * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
             **/
            outputDimensionality: z.ZodOptional<z.ZodNumber>;
            /**
             * For newly released embedders this parameter provides a hint for the proper
             * way to call the embedder. (Multimodal embedders have a different request
             * structure than non-multimodal embedders).
             * For well-known embedders, this value will be ignored since we will already
             * know if it's multimodal or not.
             */
            multimodal: z.ZodOptional<z.ZodBoolean>;
        }, z.ZodTypeAny, "passthrough">>>;
    };
};

export { type EmbeddingConfig, EmbeddingConfigSchema, type EmbeddingConfigSchemaType, KNOWN_MODELS, TEST_ONLY, defineEmbedder, defineKnownModels, model };
