"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var embedder_exports = {};
__export(embedder_exports, {
  EmbeddingConfigSchema: () => EmbeddingConfigSchema,
  KNOWN_MODELS: () => KNOWN_MODELS,
  TEST_ONLY: () => TEST_ONLY,
  defineEmbedder: () => defineEmbedder,
  defineKnownModels: () => defineKnownModels,
  model: () => model
});
module.exports = __toCommonJS(embedder_exports);
var import_genkit = require("genkit");
var import_embedder = require("genkit/embedder");
var import_client = require("./client.js");
var import_types = require("./types.js");
var import_utils = require("./utils.js");
const EmbeddingConfigSchema = import_genkit.z.object({
  /**
   * The `task_type` parameter is defined as the intended downstream application
   * to help the model produce better quality embeddings.
   **/
  taskType: import_types.TaskTypeSchema.optional(),
  title: import_genkit.z.string().optional(),
  location: import_genkit.z.string().optional(),
  version: import_genkit.z.string().optional(),
  /**
   * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
   * By default, the model generates embeddings with 768 dimensions.
   * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
   **/
  outputDimensionality: import_genkit.z.number().min(1).optional(),
  /**
   * For newly released embedders this parameter provides a hint for the proper
   * way to call the embedder. (Multimodal embedders have a different request
   * structure than non-multimodal embedders).
   * For well-known embedders, this value will be ignored since we will already
   * know if it's multimodal or not.
   */
  multimodal: import_genkit.z.boolean().optional()
}).passthrough();
function commonRef(name, info, configSchema = EmbeddingConfigSchema) {
  return (0, import_embedder.embedderRef)({
    name: `vertexai/${name}`,
    configSchema,
    info: info ?? {
      dimensions: 768,
      supports: {
        input: ["text"]
      }
    }
  });
}
const GENERIC_TEXT_MODEL = commonRef("text", {
  dimensions: 3072,
  supports: { input: ["text"] }
});
const GENERIC_MULTIMODAL_MODEL = commonRef("multimodal", {
  dimensions: 768,
  supports: { input: ["text", "image", "video"] }
});
const KNOWN_MODELS = {
  "text-embedding-005": commonRef("text-embedding-005"),
  "text-multilingual-embedding-002": commonRef(
    "text-multilingual-embedding-002"
  ),
  "multimodalembedding@001": commonRef("multimodalembedding@001", {
    dimensions: 768,
    supports: { input: ["text", "image", "video"] }
  }),
  "gemini-embedding-001": commonRef("gemini-embedding-001", {
    dimensions: 3072,
    supports: { input: ["text"] }
  })
};
function model(version, config = {}) {
  const name = (0, import_utils.checkModelName)(version);
  if (KNOWN_MODELS[name]) {
    return (0, import_embedder.embedderRef)({
      name: `vertexai/${name}`,
      configSchema: EmbeddingConfigSchema,
      config,
      info: {
        ...KNOWN_MODELS[name].info
      }
    });
  }
  if (config.multimodal) {
    return (0, import_embedder.embedderRef)({
      name: `vertexai/${name}`,
      configSchema: EmbeddingConfigSchema,
      config,
      info: {
        ...GENERIC_MULTIMODAL_MODEL.info
      }
    });
  }
  return (0, import_embedder.embedderRef)({
    name: `vertexai/${name}`,
    configSchema: EmbeddingConfigSchema,
    config,
    info: {
      ...GENERIC_TEXT_MODEL.info
    }
  });
}
function defineKnownModels(ai, clientOptions, pluginOptions) {
  for (const name of Object.keys(KNOWN_MODELS)) {
    defineEmbedder(ai, name, clientOptions, pluginOptions);
  }
}
function defineEmbedder(ai, name, clientOptions, pluginOptions) {
  const ref = model(name);
  return ai.defineEmbedder(
    {
      name: ref.name,
      configSchema: ref.configSchema,
      info: ref.info
    },
    async (input, options) => {
      const embedContentRequest = {
        instances: input.map(
          (doc) => toEmbeddingInstance(ref, doc, options)
        ),
        parameters: { outputDimensionality: options?.outputDimensionality }
      };
      const response = await (0, import_client.embedContent)(
        (0, import_utils.extractVersion)(ref),
        embedContentRequest,
        clientOptions
      );
      return {
        embeddings: response.predictions.map(toEmbeddingResult).reduce((accumulator, value) => {
          return accumulator.concat(value);
        }, [])
      };
    }
  );
}
function toEmbeddingInstance(embedder, doc, options) {
  let instance;
  if (isMultiModalEmbedder(embedder) || embedder.config?.multimodal || options?.multimodal) {
    instance = {};
    if (doc.text) {
      instance.text = doc.text;
    }
    for (var media of doc.media) {
      if ((0, import_types.isObject)(media) && typeof media.url === "string" && typeof media.contentType === "string") {
        if (media.contentType?.startsWith("image/")) {
          if (media.url.startsWith("http") || media.url.startsWith("gs://")) {
            instance.image = {
              gcsUri: media.url,
              mimeType: media.contentType
            };
          } else {
            instance.image = {
              bytesBase64Encoded: media.url,
              mimeType: media.contentType
            };
          }
        } else if (media.contentType.startsWith("video/")) {
          if (media.url.startsWith("http") || media.url.startsWith("gs://")) {
            instance.video = {
              gcsUri: media.url
            };
          } else {
            instance.video = {
              bytesBase64Encoded: media.url
            };
          }
          if (instance.video && doc.metadata && doc.metadata.videoSegmentConfig) {
            instance.video.videoSegmentConfig = doc.metadata.videoSegmentConfig;
          }
        } else {
          throw new Error(`Unsupported contentType: '${media.contentType}`);
        }
      } else {
        throw new Error("Invalid media specified.");
      }
    }
  } else {
    instance = {
      content: doc.text,
      task_type: options?.taskType,
      title: options?.title
    };
  }
  return instance;
}
function toEmbeddingResult(prediction) {
  if ((0, import_types.isMultimodalEmbeddingPrediction)(prediction)) {
    const eArray = [];
    if (prediction.imageEmbedding?.length) {
      const imageResult = {
        embedding: prediction.imageEmbedding,
        metadata: { embedType: "imageEmbedding" }
      };
      eArray.push(imageResult);
    }
    if (prediction.textEmbedding?.length) {
      const textResult = {
        embedding: prediction.textEmbedding,
        metadata: { embedType: "textEmbedding" }
      };
      eArray.push(textResult);
    }
    if (prediction.videoEmbeddings?.length) {
      for (const ve of prediction.videoEmbeddings) {
        if (ve.embedding?.length) {
          const { embedding, ...metadata } = ve;
          metadata.embedType = "videoEmbedding";
          const videoResult = {
            embedding,
            metadata
          };
          eArray.push(videoResult);
        }
      }
    }
    return eArray;
  } else {
    return [
      {
        embedding: prediction.embeddings.values
      }
    ];
  }
}
function isMultiModalEmbedder(embedder) {
  if (embedder.config?.multimodal) {
    return true;
  }
  const input = embedder.info?.supports?.input || "";
  return input.includes("text") && input.includes("image") || false;
}
const TEST_ONLY = { KNOWN_MODELS };
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  EmbeddingConfigSchema,
  KNOWN_MODELS,
  TEST_ONLY,
  defineEmbedder,
  defineKnownModels,
  model
});
//# sourceMappingURL=embedder.js.map