import { z, ActionMetadata, Genkit } from 'genkit';
import { ModelReference, ModelAction } from 'genkit/model';
import { Model, ClientOptions, VertexPluginOptions } from './types.mjs';
import 'google-auth-library';
import '../common/types.mjs';

/**
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

declare const SafetySettingsSchema: z.ZodObject<{
    category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
    threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
}, "strip", z.ZodTypeAny, {
    category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
    threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
}, {
    category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
    threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
}>;
/**
 * Zod schema of Gemini model options.
 * Please refer to: https://cloud.google.com/vertex-ai/generative-ai/docs/model-reference/inference#generationconfig, for further information.
 */
declare const GeminiConfigSchema: z.ZodObject<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    apiKey: z.ZodOptional<z.ZodString>;
    labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    location: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    vertexRetrieval: z.ZodOptional<z.ZodObject<{
        datastore: z.ZodObject<{
            projectId: z.ZodOptional<z.ZodString>;
            location: z.ZodOptional<z.ZodString>;
            dataStoreId: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            dataStoreId: string;
            location?: string | undefined;
            projectId?: string | undefined;
        }, {
            dataStoreId: string;
            location?: string | undefined;
            projectId?: string | undefined;
        }>;
        disableAttribution: z.ZodOptional<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        datastore: {
            dataStoreId: string;
            location?: string | undefined;
            projectId?: string | undefined;
        };
        disableAttribution?: boolean | undefined;
    }, {
        datastore: {
            dataStoreId: string;
            location?: string | undefined;
            projectId?: string | undefined;
        };
        disableAttribution?: boolean | undefined;
    }>>;
    googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
        disableAttribution: z.ZodOptional<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        disableAttribution?: boolean | undefined;
    }, {
        disableAttribution?: boolean | undefined;
    }>>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    apiKey: z.ZodOptional<z.ZodString>;
    labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    location: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    vertexRetrieval: z.ZodOptional<z.ZodObject<{
        datastore: z.ZodObject<{
            projectId: z.ZodOptional<z.ZodString>;
            location: z.ZodOptional<z.ZodString>;
            dataStoreId: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            dataStoreId: string;
            location?: string | undefined;
            projectId?: string | undefined;
        }, {
            dataStoreId: string;
            location?: string | undefined;
            projectId?: string | undefined;
        }>;
        disableAttribution: z.ZodOptional<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        datastore: {
            dataStoreId: string;
            location?: string | undefined;
            projectId?: string | undefined;
        };
        disableAttribution?: boolean | undefined;
    }, {
        datastore: {
            dataStoreId: string;
            location?: string | undefined;
            projectId?: string | undefined;
        };
        disableAttribution?: boolean | undefined;
    }>>;
    googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
        disableAttribution: z.ZodOptional<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        disableAttribution?: boolean | undefined;
    }, {
        disableAttribution?: boolean | undefined;
    }>>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    apiKey: z.ZodOptional<z.ZodString>;
    labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    location: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    vertexRetrieval: z.ZodOptional<z.ZodObject<{
        datastore: z.ZodObject<{
            projectId: z.ZodOptional<z.ZodString>;
            location: z.ZodOptional<z.ZodString>;
            dataStoreId: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            dataStoreId: string;
            location?: string | undefined;
            projectId?: string | undefined;
        }, {
            dataStoreId: string;
            location?: string | undefined;
            projectId?: string | undefined;
        }>;
        disableAttribution: z.ZodOptional<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        datastore: {
            dataStoreId: string;
            location?: string | undefined;
            projectId?: string | undefined;
        };
        disableAttribution?: boolean | undefined;
    }, {
        datastore: {
            dataStoreId: string;
            location?: string | undefined;
            projectId?: string | undefined;
        };
        disableAttribution?: boolean | undefined;
    }>>;
    googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
        disableAttribution: z.ZodOptional<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        disableAttribution?: boolean | undefined;
    }, {
        disableAttribution?: boolean | undefined;
    }>>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, z.ZodTypeAny, "passthrough">>;
type GeminiConfigSchemaType = typeof GeminiConfigSchema;
/**
 * Gemini model configuration options.
 *
 * E.g.
 * ```js
 *   config: {
 *     temperature: 0.9,
 *     maxOutputTokens: 300,
 *     safetySettings: [
 *       {
 *         category: 'HARM_CATEGORY_HATE_SPEECH',
 *         threshold: 'BLOCK_LOW_AND_ABOVE',
 *       },
 *       {
 *         category: 'HARM_CATEGORY_DANGEROUS_CONTENT',
 *         threshold: 'BLOCK_MEDIUM_AND_ABOVE',
 *       },
 *       {
 *         category: 'HARM_CATEGORY_HARASSMENT',
 *         threshold: 'BLOCK_ONLY_HIGH',
 *       },
 *       {
 *         category: 'HARM_CATEGORY_SEXUALLY_EXPLICIT',
 *         threshold: 'BLOCK_NONE',
 *       },
 *     ],
 *     functionCallingConfig: {
 *       mode: 'ANY',
 *     }
 *   }
 * ```
 */
type GeminiConfig = z.infer<GeminiConfigSchemaType>;
declare const GENERIC_MODEL: ModelReference<z.ZodObject<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    apiKey: z.ZodOptional<z.ZodString>;
    labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    location: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    vertexRetrieval: z.ZodOptional<z.ZodObject<{
        datastore: z.ZodObject<{
            projectId: z.ZodOptional<z.ZodString>;
            location: z.ZodOptional<z.ZodString>;
            dataStoreId: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            dataStoreId: string;
            location?: string | undefined;
            projectId?: string | undefined;
        }, {
            dataStoreId: string;
            location?: string | undefined;
            projectId?: string | undefined;
        }>;
        disableAttribution: z.ZodOptional<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        datastore: {
            dataStoreId: string;
            location?: string | undefined;
            projectId?: string | undefined;
        };
        disableAttribution?: boolean | undefined;
    }, {
        datastore: {
            dataStoreId: string;
            location?: string | undefined;
            projectId?: string | undefined;
        };
        disableAttribution?: boolean | undefined;
    }>>;
    googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
        disableAttribution: z.ZodOptional<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        disableAttribution?: boolean | undefined;
    }, {
        disableAttribution?: boolean | undefined;
    }>>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    apiKey: z.ZodOptional<z.ZodString>;
    labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    location: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    vertexRetrieval: z.ZodOptional<z.ZodObject<{
        datastore: z.ZodObject<{
            projectId: z.ZodOptional<z.ZodString>;
            location: z.ZodOptional<z.ZodString>;
            dataStoreId: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            dataStoreId: string;
            location?: string | undefined;
            projectId?: string | undefined;
        }, {
            dataStoreId: string;
            location?: string | undefined;
            projectId?: string | undefined;
        }>;
        disableAttribution: z.ZodOptional<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        datastore: {
            dataStoreId: string;
            location?: string | undefined;
            projectId?: string | undefined;
        };
        disableAttribution?: boolean | undefined;
    }, {
        datastore: {
            dataStoreId: string;
            location?: string | undefined;
            projectId?: string | undefined;
        };
        disableAttribution?: boolean | undefined;
    }>>;
    googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
        disableAttribution: z.ZodOptional<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        disableAttribution?: boolean | undefined;
    }, {
        disableAttribution?: boolean | undefined;
    }>>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    version: z.ZodOptional<z.ZodString>;
    maxOutputTokens: z.ZodOptional<z.ZodNumber>;
    topK: z.ZodOptional<z.ZodNumber>;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    apiKey: z.ZodOptional<z.ZodString>;
    labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    temperature: z.ZodOptional<z.ZodNumber>;
    topP: z.ZodOptional<z.ZodNumber>;
    location: z.ZodOptional<z.ZodString>;
    safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
        category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
        threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
    }, "strip", z.ZodTypeAny, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }, {
        category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
        threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
    }>, "many">>;
    vertexRetrieval: z.ZodOptional<z.ZodObject<{
        datastore: z.ZodObject<{
            projectId: z.ZodOptional<z.ZodString>;
            location: z.ZodOptional<z.ZodString>;
            dataStoreId: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            dataStoreId: string;
            location?: string | undefined;
            projectId?: string | undefined;
        }, {
            dataStoreId: string;
            location?: string | undefined;
            projectId?: string | undefined;
        }>;
        disableAttribution: z.ZodOptional<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        datastore: {
            dataStoreId: string;
            location?: string | undefined;
            projectId?: string | undefined;
        };
        disableAttribution?: boolean | undefined;
    }, {
        datastore: {
            dataStoreId: string;
            location?: string | undefined;
            projectId?: string | undefined;
        };
        disableAttribution?: boolean | undefined;
    }>>;
    googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
        disableAttribution: z.ZodOptional<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        disableAttribution?: boolean | undefined;
    }, {
        disableAttribution?: boolean | undefined;
    }>>;
    functionCallingConfig: z.ZodOptional<z.ZodObject<{
        mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
        allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }, {
        mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
        allowedFunctionNames?: string[] | undefined;
    }>>;
    thinkingConfig: z.ZodOptional<z.ZodObject<{
        includeThoughts: z.ZodOptional<z.ZodBoolean>;
        thinkingBudget: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }, {
        includeThoughts?: boolean | undefined;
        thinkingBudget?: number | undefined;
    }>>;
}, z.ZodTypeAny, "passthrough">>>;
declare const KNOWN_MODELS: {
    readonly 'gemini-2.5-flash-lite': ModelReference<z.ZodObject<{
        version: z.ZodOptional<z.ZodString>;
        maxOutputTokens: z.ZodOptional<z.ZodNumber>;
        topK: z.ZodOptional<z.ZodNumber>;
        stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    } & {
        apiKey: z.ZodOptional<z.ZodString>;
        labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
        temperature: z.ZodOptional<z.ZodNumber>;
        topP: z.ZodOptional<z.ZodNumber>;
        location: z.ZodOptional<z.ZodString>;
        safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
            category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
            threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
        }, "strip", z.ZodTypeAny, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }>, "many">>;
        vertexRetrieval: z.ZodOptional<z.ZodObject<{
            datastore: z.ZodObject<{
                projectId: z.ZodOptional<z.ZodString>;
                location: z.ZodOptional<z.ZodString>;
                dataStoreId: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }>;
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }>>;
        googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            disableAttribution?: boolean | undefined;
        }, {
            disableAttribution?: boolean | undefined;
        }>>;
        functionCallingConfig: z.ZodOptional<z.ZodObject<{
            mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
            allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }>>;
        thinkingConfig: z.ZodOptional<z.ZodObject<{
            includeThoughts: z.ZodOptional<z.ZodBoolean>;
            thinkingBudget: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        version: z.ZodOptional<z.ZodString>;
        maxOutputTokens: z.ZodOptional<z.ZodNumber>;
        topK: z.ZodOptional<z.ZodNumber>;
        stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    } & {
        apiKey: z.ZodOptional<z.ZodString>;
        labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
        temperature: z.ZodOptional<z.ZodNumber>;
        topP: z.ZodOptional<z.ZodNumber>;
        location: z.ZodOptional<z.ZodString>;
        safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
            category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
            threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
        }, "strip", z.ZodTypeAny, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }>, "many">>;
        vertexRetrieval: z.ZodOptional<z.ZodObject<{
            datastore: z.ZodObject<{
                projectId: z.ZodOptional<z.ZodString>;
                location: z.ZodOptional<z.ZodString>;
                dataStoreId: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }>;
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }>>;
        googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            disableAttribution?: boolean | undefined;
        }, {
            disableAttribution?: boolean | undefined;
        }>>;
        functionCallingConfig: z.ZodOptional<z.ZodObject<{
            mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
            allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }>>;
        thinkingConfig: z.ZodOptional<z.ZodObject<{
            includeThoughts: z.ZodOptional<z.ZodBoolean>;
            thinkingBudget: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        version: z.ZodOptional<z.ZodString>;
        maxOutputTokens: z.ZodOptional<z.ZodNumber>;
        topK: z.ZodOptional<z.ZodNumber>;
        stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    } & {
        apiKey: z.ZodOptional<z.ZodString>;
        labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
        temperature: z.ZodOptional<z.ZodNumber>;
        topP: z.ZodOptional<z.ZodNumber>;
        location: z.ZodOptional<z.ZodString>;
        safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
            category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
            threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
        }, "strip", z.ZodTypeAny, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }>, "many">>;
        vertexRetrieval: z.ZodOptional<z.ZodObject<{
            datastore: z.ZodObject<{
                projectId: z.ZodOptional<z.ZodString>;
                location: z.ZodOptional<z.ZodString>;
                dataStoreId: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }>;
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }>>;
        googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            disableAttribution?: boolean | undefined;
        }, {
            disableAttribution?: boolean | undefined;
        }>>;
        functionCallingConfig: z.ZodOptional<z.ZodObject<{
            mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
            allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }>>;
        thinkingConfig: z.ZodOptional<z.ZodObject<{
            includeThoughts: z.ZodOptional<z.ZodBoolean>;
            thinkingBudget: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }>>;
    }, z.ZodTypeAny, "passthrough">>>;
    readonly 'gemini-2.5-pro': ModelReference<z.ZodObject<{
        version: z.ZodOptional<z.ZodString>;
        maxOutputTokens: z.ZodOptional<z.ZodNumber>;
        topK: z.ZodOptional<z.ZodNumber>;
        stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    } & {
        apiKey: z.ZodOptional<z.ZodString>;
        labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
        temperature: z.ZodOptional<z.ZodNumber>;
        topP: z.ZodOptional<z.ZodNumber>;
        location: z.ZodOptional<z.ZodString>;
        safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
            category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
            threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
        }, "strip", z.ZodTypeAny, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }>, "many">>;
        vertexRetrieval: z.ZodOptional<z.ZodObject<{
            datastore: z.ZodObject<{
                projectId: z.ZodOptional<z.ZodString>;
                location: z.ZodOptional<z.ZodString>;
                dataStoreId: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }>;
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }>>;
        googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            disableAttribution?: boolean | undefined;
        }, {
            disableAttribution?: boolean | undefined;
        }>>;
        functionCallingConfig: z.ZodOptional<z.ZodObject<{
            mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
            allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }>>;
        thinkingConfig: z.ZodOptional<z.ZodObject<{
            includeThoughts: z.ZodOptional<z.ZodBoolean>;
            thinkingBudget: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        version: z.ZodOptional<z.ZodString>;
        maxOutputTokens: z.ZodOptional<z.ZodNumber>;
        topK: z.ZodOptional<z.ZodNumber>;
        stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    } & {
        apiKey: z.ZodOptional<z.ZodString>;
        labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
        temperature: z.ZodOptional<z.ZodNumber>;
        topP: z.ZodOptional<z.ZodNumber>;
        location: z.ZodOptional<z.ZodString>;
        safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
            category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
            threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
        }, "strip", z.ZodTypeAny, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }>, "many">>;
        vertexRetrieval: z.ZodOptional<z.ZodObject<{
            datastore: z.ZodObject<{
                projectId: z.ZodOptional<z.ZodString>;
                location: z.ZodOptional<z.ZodString>;
                dataStoreId: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }>;
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }>>;
        googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            disableAttribution?: boolean | undefined;
        }, {
            disableAttribution?: boolean | undefined;
        }>>;
        functionCallingConfig: z.ZodOptional<z.ZodObject<{
            mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
            allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }>>;
        thinkingConfig: z.ZodOptional<z.ZodObject<{
            includeThoughts: z.ZodOptional<z.ZodBoolean>;
            thinkingBudget: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        version: z.ZodOptional<z.ZodString>;
        maxOutputTokens: z.ZodOptional<z.ZodNumber>;
        topK: z.ZodOptional<z.ZodNumber>;
        stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    } & {
        apiKey: z.ZodOptional<z.ZodString>;
        labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
        temperature: z.ZodOptional<z.ZodNumber>;
        topP: z.ZodOptional<z.ZodNumber>;
        location: z.ZodOptional<z.ZodString>;
        safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
            category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
            threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
        }, "strip", z.ZodTypeAny, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }>, "many">>;
        vertexRetrieval: z.ZodOptional<z.ZodObject<{
            datastore: z.ZodObject<{
                projectId: z.ZodOptional<z.ZodString>;
                location: z.ZodOptional<z.ZodString>;
                dataStoreId: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }>;
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }>>;
        googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            disableAttribution?: boolean | undefined;
        }, {
            disableAttribution?: boolean | undefined;
        }>>;
        functionCallingConfig: z.ZodOptional<z.ZodObject<{
            mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
            allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }>>;
        thinkingConfig: z.ZodOptional<z.ZodObject<{
            includeThoughts: z.ZodOptional<z.ZodBoolean>;
            thinkingBudget: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }>>;
    }, z.ZodTypeAny, "passthrough">>>;
    readonly 'gemini-2.5-flash': ModelReference<z.ZodObject<{
        version: z.ZodOptional<z.ZodString>;
        maxOutputTokens: z.ZodOptional<z.ZodNumber>;
        topK: z.ZodOptional<z.ZodNumber>;
        stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    } & {
        apiKey: z.ZodOptional<z.ZodString>;
        labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
        temperature: z.ZodOptional<z.ZodNumber>;
        topP: z.ZodOptional<z.ZodNumber>;
        location: z.ZodOptional<z.ZodString>;
        safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
            category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
            threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
        }, "strip", z.ZodTypeAny, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }>, "many">>;
        vertexRetrieval: z.ZodOptional<z.ZodObject<{
            datastore: z.ZodObject<{
                projectId: z.ZodOptional<z.ZodString>;
                location: z.ZodOptional<z.ZodString>;
                dataStoreId: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }>;
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }>>;
        googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            disableAttribution?: boolean | undefined;
        }, {
            disableAttribution?: boolean | undefined;
        }>>;
        functionCallingConfig: z.ZodOptional<z.ZodObject<{
            mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
            allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }>>;
        thinkingConfig: z.ZodOptional<z.ZodObject<{
            includeThoughts: z.ZodOptional<z.ZodBoolean>;
            thinkingBudget: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        version: z.ZodOptional<z.ZodString>;
        maxOutputTokens: z.ZodOptional<z.ZodNumber>;
        topK: z.ZodOptional<z.ZodNumber>;
        stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    } & {
        apiKey: z.ZodOptional<z.ZodString>;
        labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
        temperature: z.ZodOptional<z.ZodNumber>;
        topP: z.ZodOptional<z.ZodNumber>;
        location: z.ZodOptional<z.ZodString>;
        safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
            category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
            threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
        }, "strip", z.ZodTypeAny, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }>, "many">>;
        vertexRetrieval: z.ZodOptional<z.ZodObject<{
            datastore: z.ZodObject<{
                projectId: z.ZodOptional<z.ZodString>;
                location: z.ZodOptional<z.ZodString>;
                dataStoreId: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }>;
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }>>;
        googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            disableAttribution?: boolean | undefined;
        }, {
            disableAttribution?: boolean | undefined;
        }>>;
        functionCallingConfig: z.ZodOptional<z.ZodObject<{
            mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
            allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }>>;
        thinkingConfig: z.ZodOptional<z.ZodObject<{
            includeThoughts: z.ZodOptional<z.ZodBoolean>;
            thinkingBudget: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        version: z.ZodOptional<z.ZodString>;
        maxOutputTokens: z.ZodOptional<z.ZodNumber>;
        topK: z.ZodOptional<z.ZodNumber>;
        stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    } & {
        apiKey: z.ZodOptional<z.ZodString>;
        labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
        temperature: z.ZodOptional<z.ZodNumber>;
        topP: z.ZodOptional<z.ZodNumber>;
        location: z.ZodOptional<z.ZodString>;
        safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
            category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
            threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
        }, "strip", z.ZodTypeAny, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }>, "many">>;
        vertexRetrieval: z.ZodOptional<z.ZodObject<{
            datastore: z.ZodObject<{
                projectId: z.ZodOptional<z.ZodString>;
                location: z.ZodOptional<z.ZodString>;
                dataStoreId: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }>;
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }>>;
        googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            disableAttribution?: boolean | undefined;
        }, {
            disableAttribution?: boolean | undefined;
        }>>;
        functionCallingConfig: z.ZodOptional<z.ZodObject<{
            mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
            allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }>>;
        thinkingConfig: z.ZodOptional<z.ZodObject<{
            includeThoughts: z.ZodOptional<z.ZodBoolean>;
            thinkingBudget: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }>>;
    }, z.ZodTypeAny, "passthrough">>>;
    readonly 'gemini-2.0-flash-001': ModelReference<z.ZodObject<{
        version: z.ZodOptional<z.ZodString>;
        maxOutputTokens: z.ZodOptional<z.ZodNumber>;
        topK: z.ZodOptional<z.ZodNumber>;
        stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    } & {
        apiKey: z.ZodOptional<z.ZodString>;
        labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
        temperature: z.ZodOptional<z.ZodNumber>;
        topP: z.ZodOptional<z.ZodNumber>;
        location: z.ZodOptional<z.ZodString>;
        safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
            category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
            threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
        }, "strip", z.ZodTypeAny, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }>, "many">>;
        vertexRetrieval: z.ZodOptional<z.ZodObject<{
            datastore: z.ZodObject<{
                projectId: z.ZodOptional<z.ZodString>;
                location: z.ZodOptional<z.ZodString>;
                dataStoreId: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }>;
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }>>;
        googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            disableAttribution?: boolean | undefined;
        }, {
            disableAttribution?: boolean | undefined;
        }>>;
        functionCallingConfig: z.ZodOptional<z.ZodObject<{
            mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
            allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }>>;
        thinkingConfig: z.ZodOptional<z.ZodObject<{
            includeThoughts: z.ZodOptional<z.ZodBoolean>;
            thinkingBudget: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        version: z.ZodOptional<z.ZodString>;
        maxOutputTokens: z.ZodOptional<z.ZodNumber>;
        topK: z.ZodOptional<z.ZodNumber>;
        stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    } & {
        apiKey: z.ZodOptional<z.ZodString>;
        labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
        temperature: z.ZodOptional<z.ZodNumber>;
        topP: z.ZodOptional<z.ZodNumber>;
        location: z.ZodOptional<z.ZodString>;
        safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
            category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
            threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
        }, "strip", z.ZodTypeAny, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }>, "many">>;
        vertexRetrieval: z.ZodOptional<z.ZodObject<{
            datastore: z.ZodObject<{
                projectId: z.ZodOptional<z.ZodString>;
                location: z.ZodOptional<z.ZodString>;
                dataStoreId: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }>;
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }>>;
        googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            disableAttribution?: boolean | undefined;
        }, {
            disableAttribution?: boolean | undefined;
        }>>;
        functionCallingConfig: z.ZodOptional<z.ZodObject<{
            mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
            allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }>>;
        thinkingConfig: z.ZodOptional<z.ZodObject<{
            includeThoughts: z.ZodOptional<z.ZodBoolean>;
            thinkingBudget: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        version: z.ZodOptional<z.ZodString>;
        maxOutputTokens: z.ZodOptional<z.ZodNumber>;
        topK: z.ZodOptional<z.ZodNumber>;
        stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    } & {
        apiKey: z.ZodOptional<z.ZodString>;
        labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
        temperature: z.ZodOptional<z.ZodNumber>;
        topP: z.ZodOptional<z.ZodNumber>;
        location: z.ZodOptional<z.ZodString>;
        safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
            category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
            threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
        }, "strip", z.ZodTypeAny, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }>, "many">>;
        vertexRetrieval: z.ZodOptional<z.ZodObject<{
            datastore: z.ZodObject<{
                projectId: z.ZodOptional<z.ZodString>;
                location: z.ZodOptional<z.ZodString>;
                dataStoreId: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }>;
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }>>;
        googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            disableAttribution?: boolean | undefined;
        }, {
            disableAttribution?: boolean | undefined;
        }>>;
        functionCallingConfig: z.ZodOptional<z.ZodObject<{
            mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
            allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }>>;
        thinkingConfig: z.ZodOptional<z.ZodObject<{
            includeThoughts: z.ZodOptional<z.ZodBoolean>;
            thinkingBudget: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }>>;
    }, z.ZodTypeAny, "passthrough">>>;
    readonly 'gemini-2.0-flash': ModelReference<z.ZodObject<{
        version: z.ZodOptional<z.ZodString>;
        maxOutputTokens: z.ZodOptional<z.ZodNumber>;
        topK: z.ZodOptional<z.ZodNumber>;
        stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    } & {
        apiKey: z.ZodOptional<z.ZodString>;
        labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
        temperature: z.ZodOptional<z.ZodNumber>;
        topP: z.ZodOptional<z.ZodNumber>;
        location: z.ZodOptional<z.ZodString>;
        safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
            category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
            threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
        }, "strip", z.ZodTypeAny, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }>, "many">>;
        vertexRetrieval: z.ZodOptional<z.ZodObject<{
            datastore: z.ZodObject<{
                projectId: z.ZodOptional<z.ZodString>;
                location: z.ZodOptional<z.ZodString>;
                dataStoreId: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }>;
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }>>;
        googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            disableAttribution?: boolean | undefined;
        }, {
            disableAttribution?: boolean | undefined;
        }>>;
        functionCallingConfig: z.ZodOptional<z.ZodObject<{
            mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
            allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }>>;
        thinkingConfig: z.ZodOptional<z.ZodObject<{
            includeThoughts: z.ZodOptional<z.ZodBoolean>;
            thinkingBudget: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        version: z.ZodOptional<z.ZodString>;
        maxOutputTokens: z.ZodOptional<z.ZodNumber>;
        topK: z.ZodOptional<z.ZodNumber>;
        stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    } & {
        apiKey: z.ZodOptional<z.ZodString>;
        labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
        temperature: z.ZodOptional<z.ZodNumber>;
        topP: z.ZodOptional<z.ZodNumber>;
        location: z.ZodOptional<z.ZodString>;
        safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
            category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
            threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
        }, "strip", z.ZodTypeAny, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }>, "many">>;
        vertexRetrieval: z.ZodOptional<z.ZodObject<{
            datastore: z.ZodObject<{
                projectId: z.ZodOptional<z.ZodString>;
                location: z.ZodOptional<z.ZodString>;
                dataStoreId: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }>;
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }>>;
        googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            disableAttribution?: boolean | undefined;
        }, {
            disableAttribution?: boolean | undefined;
        }>>;
        functionCallingConfig: z.ZodOptional<z.ZodObject<{
            mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
            allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }>>;
        thinkingConfig: z.ZodOptional<z.ZodObject<{
            includeThoughts: z.ZodOptional<z.ZodBoolean>;
            thinkingBudget: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        version: z.ZodOptional<z.ZodString>;
        maxOutputTokens: z.ZodOptional<z.ZodNumber>;
        topK: z.ZodOptional<z.ZodNumber>;
        stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    } & {
        apiKey: z.ZodOptional<z.ZodString>;
        labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
        temperature: z.ZodOptional<z.ZodNumber>;
        topP: z.ZodOptional<z.ZodNumber>;
        location: z.ZodOptional<z.ZodString>;
        safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
            category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
            threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
        }, "strip", z.ZodTypeAny, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }>, "many">>;
        vertexRetrieval: z.ZodOptional<z.ZodObject<{
            datastore: z.ZodObject<{
                projectId: z.ZodOptional<z.ZodString>;
                location: z.ZodOptional<z.ZodString>;
                dataStoreId: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }>;
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }>>;
        googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            disableAttribution?: boolean | undefined;
        }, {
            disableAttribution?: boolean | undefined;
        }>>;
        functionCallingConfig: z.ZodOptional<z.ZodObject<{
            mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
            allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }>>;
        thinkingConfig: z.ZodOptional<z.ZodObject<{
            includeThoughts: z.ZodOptional<z.ZodBoolean>;
            thinkingBudget: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }>>;
    }, z.ZodTypeAny, "passthrough">>>;
    readonly 'gemini-2.0-flash-lite': ModelReference<z.ZodObject<{
        version: z.ZodOptional<z.ZodString>;
        maxOutputTokens: z.ZodOptional<z.ZodNumber>;
        topK: z.ZodOptional<z.ZodNumber>;
        stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    } & {
        apiKey: z.ZodOptional<z.ZodString>;
        labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
        temperature: z.ZodOptional<z.ZodNumber>;
        topP: z.ZodOptional<z.ZodNumber>;
        location: z.ZodOptional<z.ZodString>;
        safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
            category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
            threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
        }, "strip", z.ZodTypeAny, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }>, "many">>;
        vertexRetrieval: z.ZodOptional<z.ZodObject<{
            datastore: z.ZodObject<{
                projectId: z.ZodOptional<z.ZodString>;
                location: z.ZodOptional<z.ZodString>;
                dataStoreId: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }>;
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }>>;
        googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            disableAttribution?: boolean | undefined;
        }, {
            disableAttribution?: boolean | undefined;
        }>>;
        functionCallingConfig: z.ZodOptional<z.ZodObject<{
            mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
            allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }>>;
        thinkingConfig: z.ZodOptional<z.ZodObject<{
            includeThoughts: z.ZodOptional<z.ZodBoolean>;
            thinkingBudget: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        version: z.ZodOptional<z.ZodString>;
        maxOutputTokens: z.ZodOptional<z.ZodNumber>;
        topK: z.ZodOptional<z.ZodNumber>;
        stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    } & {
        apiKey: z.ZodOptional<z.ZodString>;
        labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
        temperature: z.ZodOptional<z.ZodNumber>;
        topP: z.ZodOptional<z.ZodNumber>;
        location: z.ZodOptional<z.ZodString>;
        safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
            category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
            threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
        }, "strip", z.ZodTypeAny, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }>, "many">>;
        vertexRetrieval: z.ZodOptional<z.ZodObject<{
            datastore: z.ZodObject<{
                projectId: z.ZodOptional<z.ZodString>;
                location: z.ZodOptional<z.ZodString>;
                dataStoreId: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }>;
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }>>;
        googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            disableAttribution?: boolean | undefined;
        }, {
            disableAttribution?: boolean | undefined;
        }>>;
        functionCallingConfig: z.ZodOptional<z.ZodObject<{
            mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
            allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }>>;
        thinkingConfig: z.ZodOptional<z.ZodObject<{
            includeThoughts: z.ZodOptional<z.ZodBoolean>;
            thinkingBudget: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        version: z.ZodOptional<z.ZodString>;
        maxOutputTokens: z.ZodOptional<z.ZodNumber>;
        topK: z.ZodOptional<z.ZodNumber>;
        stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    } & {
        apiKey: z.ZodOptional<z.ZodString>;
        labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
        temperature: z.ZodOptional<z.ZodNumber>;
        topP: z.ZodOptional<z.ZodNumber>;
        location: z.ZodOptional<z.ZodString>;
        safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
            category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
            threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
        }, "strip", z.ZodTypeAny, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }>, "many">>;
        vertexRetrieval: z.ZodOptional<z.ZodObject<{
            datastore: z.ZodObject<{
                projectId: z.ZodOptional<z.ZodString>;
                location: z.ZodOptional<z.ZodString>;
                dataStoreId: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }>;
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }>>;
        googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            disableAttribution?: boolean | undefined;
        }, {
            disableAttribution?: boolean | undefined;
        }>>;
        functionCallingConfig: z.ZodOptional<z.ZodObject<{
            mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
            allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }>>;
        thinkingConfig: z.ZodOptional<z.ZodObject<{
            includeThoughts: z.ZodOptional<z.ZodBoolean>;
            thinkingBudget: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }>>;
    }, z.ZodTypeAny, "passthrough">>>;
    readonly 'gemini-2.0-flash-lite-001': ModelReference<z.ZodObject<{
        version: z.ZodOptional<z.ZodString>;
        maxOutputTokens: z.ZodOptional<z.ZodNumber>;
        topK: z.ZodOptional<z.ZodNumber>;
        stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    } & {
        apiKey: z.ZodOptional<z.ZodString>;
        labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
        temperature: z.ZodOptional<z.ZodNumber>;
        topP: z.ZodOptional<z.ZodNumber>;
        location: z.ZodOptional<z.ZodString>;
        safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
            category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
            threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
        }, "strip", z.ZodTypeAny, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }>, "many">>;
        vertexRetrieval: z.ZodOptional<z.ZodObject<{
            datastore: z.ZodObject<{
                projectId: z.ZodOptional<z.ZodString>;
                location: z.ZodOptional<z.ZodString>;
                dataStoreId: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }>;
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }>>;
        googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            disableAttribution?: boolean | undefined;
        }, {
            disableAttribution?: boolean | undefined;
        }>>;
        functionCallingConfig: z.ZodOptional<z.ZodObject<{
            mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
            allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }>>;
        thinkingConfig: z.ZodOptional<z.ZodObject<{
            includeThoughts: z.ZodOptional<z.ZodBoolean>;
            thinkingBudget: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        version: z.ZodOptional<z.ZodString>;
        maxOutputTokens: z.ZodOptional<z.ZodNumber>;
        topK: z.ZodOptional<z.ZodNumber>;
        stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    } & {
        apiKey: z.ZodOptional<z.ZodString>;
        labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
        temperature: z.ZodOptional<z.ZodNumber>;
        topP: z.ZodOptional<z.ZodNumber>;
        location: z.ZodOptional<z.ZodString>;
        safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
            category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
            threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
        }, "strip", z.ZodTypeAny, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }>, "many">>;
        vertexRetrieval: z.ZodOptional<z.ZodObject<{
            datastore: z.ZodObject<{
                projectId: z.ZodOptional<z.ZodString>;
                location: z.ZodOptional<z.ZodString>;
                dataStoreId: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }>;
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }>>;
        googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            disableAttribution?: boolean | undefined;
        }, {
            disableAttribution?: boolean | undefined;
        }>>;
        functionCallingConfig: z.ZodOptional<z.ZodObject<{
            mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
            allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }>>;
        thinkingConfig: z.ZodOptional<z.ZodObject<{
            includeThoughts: z.ZodOptional<z.ZodBoolean>;
            thinkingBudget: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        version: z.ZodOptional<z.ZodString>;
        maxOutputTokens: z.ZodOptional<z.ZodNumber>;
        topK: z.ZodOptional<z.ZodNumber>;
        stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    } & {
        apiKey: z.ZodOptional<z.ZodString>;
        labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
        temperature: z.ZodOptional<z.ZodNumber>;
        topP: z.ZodOptional<z.ZodNumber>;
        location: z.ZodOptional<z.ZodString>;
        safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
            category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
            threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
        }, "strip", z.ZodTypeAny, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }, {
            category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
            threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
        }>, "many">>;
        vertexRetrieval: z.ZodOptional<z.ZodObject<{
            datastore: z.ZodObject<{
                projectId: z.ZodOptional<z.ZodString>;
                location: z.ZodOptional<z.ZodString>;
                dataStoreId: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }, {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            }>;
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }, {
            datastore: {
                dataStoreId: string;
                location?: string | undefined;
                projectId?: string | undefined;
            };
            disableAttribution?: boolean | undefined;
        }>>;
        googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
            disableAttribution: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            disableAttribution?: boolean | undefined;
        }, {
            disableAttribution?: boolean | undefined;
        }>>;
        functionCallingConfig: z.ZodOptional<z.ZodObject<{
            mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
            allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }, {
            mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
            allowedFunctionNames?: string[] | undefined;
        }>>;
        thinkingConfig: z.ZodOptional<z.ZodObject<{
            includeThoughts: z.ZodOptional<z.ZodBoolean>;
            thinkingBudget: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }, {
            includeThoughts?: boolean | undefined;
            thinkingBudget?: number | undefined;
        }>>;
    }, z.ZodTypeAny, "passthrough">>>;
};
type KnownModels = keyof typeof KNOWN_MODELS;
type GeminiModelName = `gemini-${string}`;
declare function isGeminiModelName(value?: string): value is GeminiModelName;
declare function model(version: string, options?: GeminiConfig): ModelReference<typeof GeminiConfigSchema>;
declare function listActions(models: Model[]): ActionMetadata[];
declare function defineKnownModels(ai: Genkit, clientOptions: ClientOptions, pluginOptions?: VertexPluginOptions): void;
/**
 * Define a Vertex AI Gemini model.
 */
declare function defineModel(ai: Genkit, name: string, clientOptions: ClientOptions, pluginOptions?: VertexPluginOptions): ModelAction;
declare const TEST_ONLY: {
    KNOWN_MODELS: {
        readonly 'gemini-2.5-flash-lite': ModelReference<z.ZodObject<{
            version: z.ZodOptional<z.ZodString>;
            maxOutputTokens: z.ZodOptional<z.ZodNumber>;
            topK: z.ZodOptional<z.ZodNumber>;
            stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        } & {
            apiKey: z.ZodOptional<z.ZodString>;
            labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
            temperature: z.ZodOptional<z.ZodNumber>;
            topP: z.ZodOptional<z.ZodNumber>;
            location: z.ZodOptional<z.ZodString>;
            safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
                category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
                threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
            }, "strip", z.ZodTypeAny, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }>, "many">>;
            vertexRetrieval: z.ZodOptional<z.ZodObject<{
                datastore: z.ZodObject<{
                    projectId: z.ZodOptional<z.ZodString>;
                    location: z.ZodOptional<z.ZodString>;
                    dataStoreId: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }>;
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }>>;
            googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                disableAttribution?: boolean | undefined;
            }, {
                disableAttribution?: boolean | undefined;
            }>>;
            functionCallingConfig: z.ZodOptional<z.ZodObject<{
                mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
                allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "strip", z.ZodTypeAny, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }>>;
            thinkingConfig: z.ZodOptional<z.ZodObject<{
                includeThoughts: z.ZodOptional<z.ZodBoolean>;
                thinkingBudget: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            version: z.ZodOptional<z.ZodString>;
            maxOutputTokens: z.ZodOptional<z.ZodNumber>;
            topK: z.ZodOptional<z.ZodNumber>;
            stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        } & {
            apiKey: z.ZodOptional<z.ZodString>;
            labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
            temperature: z.ZodOptional<z.ZodNumber>;
            topP: z.ZodOptional<z.ZodNumber>;
            location: z.ZodOptional<z.ZodString>;
            safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
                category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
                threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
            }, "strip", z.ZodTypeAny, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }>, "many">>;
            vertexRetrieval: z.ZodOptional<z.ZodObject<{
                datastore: z.ZodObject<{
                    projectId: z.ZodOptional<z.ZodString>;
                    location: z.ZodOptional<z.ZodString>;
                    dataStoreId: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }>;
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }>>;
            googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                disableAttribution?: boolean | undefined;
            }, {
                disableAttribution?: boolean | undefined;
            }>>;
            functionCallingConfig: z.ZodOptional<z.ZodObject<{
                mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
                allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "strip", z.ZodTypeAny, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }>>;
            thinkingConfig: z.ZodOptional<z.ZodObject<{
                includeThoughts: z.ZodOptional<z.ZodBoolean>;
                thinkingBudget: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            version: z.ZodOptional<z.ZodString>;
            maxOutputTokens: z.ZodOptional<z.ZodNumber>;
            topK: z.ZodOptional<z.ZodNumber>;
            stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        } & {
            apiKey: z.ZodOptional<z.ZodString>;
            labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
            temperature: z.ZodOptional<z.ZodNumber>;
            topP: z.ZodOptional<z.ZodNumber>;
            location: z.ZodOptional<z.ZodString>;
            safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
                category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
                threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
            }, "strip", z.ZodTypeAny, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }>, "many">>;
            vertexRetrieval: z.ZodOptional<z.ZodObject<{
                datastore: z.ZodObject<{
                    projectId: z.ZodOptional<z.ZodString>;
                    location: z.ZodOptional<z.ZodString>;
                    dataStoreId: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }>;
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }>>;
            googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                disableAttribution?: boolean | undefined;
            }, {
                disableAttribution?: boolean | undefined;
            }>>;
            functionCallingConfig: z.ZodOptional<z.ZodObject<{
                mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
                allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "strip", z.ZodTypeAny, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }>>;
            thinkingConfig: z.ZodOptional<z.ZodObject<{
                includeThoughts: z.ZodOptional<z.ZodBoolean>;
                thinkingBudget: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }>>;
        }, z.ZodTypeAny, "passthrough">>>;
        readonly 'gemini-2.5-pro': ModelReference<z.ZodObject<{
            version: z.ZodOptional<z.ZodString>;
            maxOutputTokens: z.ZodOptional<z.ZodNumber>;
            topK: z.ZodOptional<z.ZodNumber>;
            stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        } & {
            apiKey: z.ZodOptional<z.ZodString>;
            labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
            temperature: z.ZodOptional<z.ZodNumber>;
            topP: z.ZodOptional<z.ZodNumber>;
            location: z.ZodOptional<z.ZodString>;
            safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
                category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
                threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
            }, "strip", z.ZodTypeAny, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }>, "many">>;
            vertexRetrieval: z.ZodOptional<z.ZodObject<{
                datastore: z.ZodObject<{
                    projectId: z.ZodOptional<z.ZodString>;
                    location: z.ZodOptional<z.ZodString>;
                    dataStoreId: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }>;
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }>>;
            googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                disableAttribution?: boolean | undefined;
            }, {
                disableAttribution?: boolean | undefined;
            }>>;
            functionCallingConfig: z.ZodOptional<z.ZodObject<{
                mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
                allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "strip", z.ZodTypeAny, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }>>;
            thinkingConfig: z.ZodOptional<z.ZodObject<{
                includeThoughts: z.ZodOptional<z.ZodBoolean>;
                thinkingBudget: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            version: z.ZodOptional<z.ZodString>;
            maxOutputTokens: z.ZodOptional<z.ZodNumber>;
            topK: z.ZodOptional<z.ZodNumber>;
            stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        } & {
            apiKey: z.ZodOptional<z.ZodString>;
            labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
            temperature: z.ZodOptional<z.ZodNumber>;
            topP: z.ZodOptional<z.ZodNumber>;
            location: z.ZodOptional<z.ZodString>;
            safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
                category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
                threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
            }, "strip", z.ZodTypeAny, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }>, "many">>;
            vertexRetrieval: z.ZodOptional<z.ZodObject<{
                datastore: z.ZodObject<{
                    projectId: z.ZodOptional<z.ZodString>;
                    location: z.ZodOptional<z.ZodString>;
                    dataStoreId: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }>;
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }>>;
            googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                disableAttribution?: boolean | undefined;
            }, {
                disableAttribution?: boolean | undefined;
            }>>;
            functionCallingConfig: z.ZodOptional<z.ZodObject<{
                mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
                allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "strip", z.ZodTypeAny, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }>>;
            thinkingConfig: z.ZodOptional<z.ZodObject<{
                includeThoughts: z.ZodOptional<z.ZodBoolean>;
                thinkingBudget: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            version: z.ZodOptional<z.ZodString>;
            maxOutputTokens: z.ZodOptional<z.ZodNumber>;
            topK: z.ZodOptional<z.ZodNumber>;
            stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        } & {
            apiKey: z.ZodOptional<z.ZodString>;
            labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
            temperature: z.ZodOptional<z.ZodNumber>;
            topP: z.ZodOptional<z.ZodNumber>;
            location: z.ZodOptional<z.ZodString>;
            safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
                category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
                threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
            }, "strip", z.ZodTypeAny, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }>, "many">>;
            vertexRetrieval: z.ZodOptional<z.ZodObject<{
                datastore: z.ZodObject<{
                    projectId: z.ZodOptional<z.ZodString>;
                    location: z.ZodOptional<z.ZodString>;
                    dataStoreId: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }>;
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }>>;
            googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                disableAttribution?: boolean | undefined;
            }, {
                disableAttribution?: boolean | undefined;
            }>>;
            functionCallingConfig: z.ZodOptional<z.ZodObject<{
                mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
                allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "strip", z.ZodTypeAny, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }>>;
            thinkingConfig: z.ZodOptional<z.ZodObject<{
                includeThoughts: z.ZodOptional<z.ZodBoolean>;
                thinkingBudget: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }>>;
        }, z.ZodTypeAny, "passthrough">>>;
        readonly 'gemini-2.5-flash': ModelReference<z.ZodObject<{
            version: z.ZodOptional<z.ZodString>;
            maxOutputTokens: z.ZodOptional<z.ZodNumber>;
            topK: z.ZodOptional<z.ZodNumber>;
            stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        } & {
            apiKey: z.ZodOptional<z.ZodString>;
            labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
            temperature: z.ZodOptional<z.ZodNumber>;
            topP: z.ZodOptional<z.ZodNumber>;
            location: z.ZodOptional<z.ZodString>;
            safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
                category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
                threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
            }, "strip", z.ZodTypeAny, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }>, "many">>;
            vertexRetrieval: z.ZodOptional<z.ZodObject<{
                datastore: z.ZodObject<{
                    projectId: z.ZodOptional<z.ZodString>;
                    location: z.ZodOptional<z.ZodString>;
                    dataStoreId: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }>;
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }>>;
            googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                disableAttribution?: boolean | undefined;
            }, {
                disableAttribution?: boolean | undefined;
            }>>;
            functionCallingConfig: z.ZodOptional<z.ZodObject<{
                mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
                allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "strip", z.ZodTypeAny, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }>>;
            thinkingConfig: z.ZodOptional<z.ZodObject<{
                includeThoughts: z.ZodOptional<z.ZodBoolean>;
                thinkingBudget: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            version: z.ZodOptional<z.ZodString>;
            maxOutputTokens: z.ZodOptional<z.ZodNumber>;
            topK: z.ZodOptional<z.ZodNumber>;
            stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        } & {
            apiKey: z.ZodOptional<z.ZodString>;
            labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
            temperature: z.ZodOptional<z.ZodNumber>;
            topP: z.ZodOptional<z.ZodNumber>;
            location: z.ZodOptional<z.ZodString>;
            safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
                category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
                threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
            }, "strip", z.ZodTypeAny, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }>, "many">>;
            vertexRetrieval: z.ZodOptional<z.ZodObject<{
                datastore: z.ZodObject<{
                    projectId: z.ZodOptional<z.ZodString>;
                    location: z.ZodOptional<z.ZodString>;
                    dataStoreId: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }>;
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }>>;
            googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                disableAttribution?: boolean | undefined;
            }, {
                disableAttribution?: boolean | undefined;
            }>>;
            functionCallingConfig: z.ZodOptional<z.ZodObject<{
                mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
                allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "strip", z.ZodTypeAny, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }>>;
            thinkingConfig: z.ZodOptional<z.ZodObject<{
                includeThoughts: z.ZodOptional<z.ZodBoolean>;
                thinkingBudget: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            version: z.ZodOptional<z.ZodString>;
            maxOutputTokens: z.ZodOptional<z.ZodNumber>;
            topK: z.ZodOptional<z.ZodNumber>;
            stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        } & {
            apiKey: z.ZodOptional<z.ZodString>;
            labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
            temperature: z.ZodOptional<z.ZodNumber>;
            topP: z.ZodOptional<z.ZodNumber>;
            location: z.ZodOptional<z.ZodString>;
            safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
                category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
                threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
            }, "strip", z.ZodTypeAny, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }>, "many">>;
            vertexRetrieval: z.ZodOptional<z.ZodObject<{
                datastore: z.ZodObject<{
                    projectId: z.ZodOptional<z.ZodString>;
                    location: z.ZodOptional<z.ZodString>;
                    dataStoreId: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }>;
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }>>;
            googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                disableAttribution?: boolean | undefined;
            }, {
                disableAttribution?: boolean | undefined;
            }>>;
            functionCallingConfig: z.ZodOptional<z.ZodObject<{
                mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
                allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "strip", z.ZodTypeAny, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }>>;
            thinkingConfig: z.ZodOptional<z.ZodObject<{
                includeThoughts: z.ZodOptional<z.ZodBoolean>;
                thinkingBudget: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }>>;
        }, z.ZodTypeAny, "passthrough">>>;
        readonly 'gemini-2.0-flash-001': ModelReference<z.ZodObject<{
            version: z.ZodOptional<z.ZodString>;
            maxOutputTokens: z.ZodOptional<z.ZodNumber>;
            topK: z.ZodOptional<z.ZodNumber>;
            stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        } & {
            apiKey: z.ZodOptional<z.ZodString>;
            labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
            temperature: z.ZodOptional<z.ZodNumber>;
            topP: z.ZodOptional<z.ZodNumber>;
            location: z.ZodOptional<z.ZodString>;
            safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
                category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
                threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
            }, "strip", z.ZodTypeAny, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }>, "many">>;
            vertexRetrieval: z.ZodOptional<z.ZodObject<{
                datastore: z.ZodObject<{
                    projectId: z.ZodOptional<z.ZodString>;
                    location: z.ZodOptional<z.ZodString>;
                    dataStoreId: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }>;
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }>>;
            googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                disableAttribution?: boolean | undefined;
            }, {
                disableAttribution?: boolean | undefined;
            }>>;
            functionCallingConfig: z.ZodOptional<z.ZodObject<{
                mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
                allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "strip", z.ZodTypeAny, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }>>;
            thinkingConfig: z.ZodOptional<z.ZodObject<{
                includeThoughts: z.ZodOptional<z.ZodBoolean>;
                thinkingBudget: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            version: z.ZodOptional<z.ZodString>;
            maxOutputTokens: z.ZodOptional<z.ZodNumber>;
            topK: z.ZodOptional<z.ZodNumber>;
            stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        } & {
            apiKey: z.ZodOptional<z.ZodString>;
            labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
            temperature: z.ZodOptional<z.ZodNumber>;
            topP: z.ZodOptional<z.ZodNumber>;
            location: z.ZodOptional<z.ZodString>;
            safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
                category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
                threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
            }, "strip", z.ZodTypeAny, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }>, "many">>;
            vertexRetrieval: z.ZodOptional<z.ZodObject<{
                datastore: z.ZodObject<{
                    projectId: z.ZodOptional<z.ZodString>;
                    location: z.ZodOptional<z.ZodString>;
                    dataStoreId: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }>;
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }>>;
            googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                disableAttribution?: boolean | undefined;
            }, {
                disableAttribution?: boolean | undefined;
            }>>;
            functionCallingConfig: z.ZodOptional<z.ZodObject<{
                mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
                allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "strip", z.ZodTypeAny, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }>>;
            thinkingConfig: z.ZodOptional<z.ZodObject<{
                includeThoughts: z.ZodOptional<z.ZodBoolean>;
                thinkingBudget: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            version: z.ZodOptional<z.ZodString>;
            maxOutputTokens: z.ZodOptional<z.ZodNumber>;
            topK: z.ZodOptional<z.ZodNumber>;
            stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        } & {
            apiKey: z.ZodOptional<z.ZodString>;
            labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
            temperature: z.ZodOptional<z.ZodNumber>;
            topP: z.ZodOptional<z.ZodNumber>;
            location: z.ZodOptional<z.ZodString>;
            safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
                category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
                threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
            }, "strip", z.ZodTypeAny, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }>, "many">>;
            vertexRetrieval: z.ZodOptional<z.ZodObject<{
                datastore: z.ZodObject<{
                    projectId: z.ZodOptional<z.ZodString>;
                    location: z.ZodOptional<z.ZodString>;
                    dataStoreId: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }>;
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }>>;
            googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                disableAttribution?: boolean | undefined;
            }, {
                disableAttribution?: boolean | undefined;
            }>>;
            functionCallingConfig: z.ZodOptional<z.ZodObject<{
                mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
                allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "strip", z.ZodTypeAny, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }>>;
            thinkingConfig: z.ZodOptional<z.ZodObject<{
                includeThoughts: z.ZodOptional<z.ZodBoolean>;
                thinkingBudget: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }>>;
        }, z.ZodTypeAny, "passthrough">>>;
        readonly 'gemini-2.0-flash': ModelReference<z.ZodObject<{
            version: z.ZodOptional<z.ZodString>;
            maxOutputTokens: z.ZodOptional<z.ZodNumber>;
            topK: z.ZodOptional<z.ZodNumber>;
            stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        } & {
            apiKey: z.ZodOptional<z.ZodString>;
            labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
            temperature: z.ZodOptional<z.ZodNumber>;
            topP: z.ZodOptional<z.ZodNumber>;
            location: z.ZodOptional<z.ZodString>;
            safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
                category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
                threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
            }, "strip", z.ZodTypeAny, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }>, "many">>;
            vertexRetrieval: z.ZodOptional<z.ZodObject<{
                datastore: z.ZodObject<{
                    projectId: z.ZodOptional<z.ZodString>;
                    location: z.ZodOptional<z.ZodString>;
                    dataStoreId: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }>;
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }>>;
            googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                disableAttribution?: boolean | undefined;
            }, {
                disableAttribution?: boolean | undefined;
            }>>;
            functionCallingConfig: z.ZodOptional<z.ZodObject<{
                mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
                allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "strip", z.ZodTypeAny, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }>>;
            thinkingConfig: z.ZodOptional<z.ZodObject<{
                includeThoughts: z.ZodOptional<z.ZodBoolean>;
                thinkingBudget: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            version: z.ZodOptional<z.ZodString>;
            maxOutputTokens: z.ZodOptional<z.ZodNumber>;
            topK: z.ZodOptional<z.ZodNumber>;
            stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        } & {
            apiKey: z.ZodOptional<z.ZodString>;
            labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
            temperature: z.ZodOptional<z.ZodNumber>;
            topP: z.ZodOptional<z.ZodNumber>;
            location: z.ZodOptional<z.ZodString>;
            safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
                category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
                threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
            }, "strip", z.ZodTypeAny, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }>, "many">>;
            vertexRetrieval: z.ZodOptional<z.ZodObject<{
                datastore: z.ZodObject<{
                    projectId: z.ZodOptional<z.ZodString>;
                    location: z.ZodOptional<z.ZodString>;
                    dataStoreId: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }>;
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }>>;
            googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                disableAttribution?: boolean | undefined;
            }, {
                disableAttribution?: boolean | undefined;
            }>>;
            functionCallingConfig: z.ZodOptional<z.ZodObject<{
                mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
                allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "strip", z.ZodTypeAny, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }>>;
            thinkingConfig: z.ZodOptional<z.ZodObject<{
                includeThoughts: z.ZodOptional<z.ZodBoolean>;
                thinkingBudget: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            version: z.ZodOptional<z.ZodString>;
            maxOutputTokens: z.ZodOptional<z.ZodNumber>;
            topK: z.ZodOptional<z.ZodNumber>;
            stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        } & {
            apiKey: z.ZodOptional<z.ZodString>;
            labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
            temperature: z.ZodOptional<z.ZodNumber>;
            topP: z.ZodOptional<z.ZodNumber>;
            location: z.ZodOptional<z.ZodString>;
            safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
                category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
                threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
            }, "strip", z.ZodTypeAny, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }>, "many">>;
            vertexRetrieval: z.ZodOptional<z.ZodObject<{
                datastore: z.ZodObject<{
                    projectId: z.ZodOptional<z.ZodString>;
                    location: z.ZodOptional<z.ZodString>;
                    dataStoreId: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }>;
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }>>;
            googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                disableAttribution?: boolean | undefined;
            }, {
                disableAttribution?: boolean | undefined;
            }>>;
            functionCallingConfig: z.ZodOptional<z.ZodObject<{
                mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
                allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "strip", z.ZodTypeAny, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }>>;
            thinkingConfig: z.ZodOptional<z.ZodObject<{
                includeThoughts: z.ZodOptional<z.ZodBoolean>;
                thinkingBudget: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }>>;
        }, z.ZodTypeAny, "passthrough">>>;
        readonly 'gemini-2.0-flash-lite': ModelReference<z.ZodObject<{
            version: z.ZodOptional<z.ZodString>;
            maxOutputTokens: z.ZodOptional<z.ZodNumber>;
            topK: z.ZodOptional<z.ZodNumber>;
            stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        } & {
            apiKey: z.ZodOptional<z.ZodString>;
            labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
            temperature: z.ZodOptional<z.ZodNumber>;
            topP: z.ZodOptional<z.ZodNumber>;
            location: z.ZodOptional<z.ZodString>;
            safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
                category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
                threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
            }, "strip", z.ZodTypeAny, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }>, "many">>;
            vertexRetrieval: z.ZodOptional<z.ZodObject<{
                datastore: z.ZodObject<{
                    projectId: z.ZodOptional<z.ZodString>;
                    location: z.ZodOptional<z.ZodString>;
                    dataStoreId: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }>;
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }>>;
            googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                disableAttribution?: boolean | undefined;
            }, {
                disableAttribution?: boolean | undefined;
            }>>;
            functionCallingConfig: z.ZodOptional<z.ZodObject<{
                mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
                allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "strip", z.ZodTypeAny, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }>>;
            thinkingConfig: z.ZodOptional<z.ZodObject<{
                includeThoughts: z.ZodOptional<z.ZodBoolean>;
                thinkingBudget: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            version: z.ZodOptional<z.ZodString>;
            maxOutputTokens: z.ZodOptional<z.ZodNumber>;
            topK: z.ZodOptional<z.ZodNumber>;
            stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        } & {
            apiKey: z.ZodOptional<z.ZodString>;
            labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
            temperature: z.ZodOptional<z.ZodNumber>;
            topP: z.ZodOptional<z.ZodNumber>;
            location: z.ZodOptional<z.ZodString>;
            safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
                category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
                threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
            }, "strip", z.ZodTypeAny, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }>, "many">>;
            vertexRetrieval: z.ZodOptional<z.ZodObject<{
                datastore: z.ZodObject<{
                    projectId: z.ZodOptional<z.ZodString>;
                    location: z.ZodOptional<z.ZodString>;
                    dataStoreId: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }>;
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }>>;
            googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                disableAttribution?: boolean | undefined;
            }, {
                disableAttribution?: boolean | undefined;
            }>>;
            functionCallingConfig: z.ZodOptional<z.ZodObject<{
                mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
                allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "strip", z.ZodTypeAny, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }>>;
            thinkingConfig: z.ZodOptional<z.ZodObject<{
                includeThoughts: z.ZodOptional<z.ZodBoolean>;
                thinkingBudget: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            version: z.ZodOptional<z.ZodString>;
            maxOutputTokens: z.ZodOptional<z.ZodNumber>;
            topK: z.ZodOptional<z.ZodNumber>;
            stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        } & {
            apiKey: z.ZodOptional<z.ZodString>;
            labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
            temperature: z.ZodOptional<z.ZodNumber>;
            topP: z.ZodOptional<z.ZodNumber>;
            location: z.ZodOptional<z.ZodString>;
            safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
                category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
                threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
            }, "strip", z.ZodTypeAny, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }>, "many">>;
            vertexRetrieval: z.ZodOptional<z.ZodObject<{
                datastore: z.ZodObject<{
                    projectId: z.ZodOptional<z.ZodString>;
                    location: z.ZodOptional<z.ZodString>;
                    dataStoreId: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }>;
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }>>;
            googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                disableAttribution?: boolean | undefined;
            }, {
                disableAttribution?: boolean | undefined;
            }>>;
            functionCallingConfig: z.ZodOptional<z.ZodObject<{
                mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
                allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "strip", z.ZodTypeAny, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }>>;
            thinkingConfig: z.ZodOptional<z.ZodObject<{
                includeThoughts: z.ZodOptional<z.ZodBoolean>;
                thinkingBudget: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }>>;
        }, z.ZodTypeAny, "passthrough">>>;
        readonly 'gemini-2.0-flash-lite-001': ModelReference<z.ZodObject<{
            version: z.ZodOptional<z.ZodString>;
            maxOutputTokens: z.ZodOptional<z.ZodNumber>;
            topK: z.ZodOptional<z.ZodNumber>;
            stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        } & {
            apiKey: z.ZodOptional<z.ZodString>;
            labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
            temperature: z.ZodOptional<z.ZodNumber>;
            topP: z.ZodOptional<z.ZodNumber>;
            location: z.ZodOptional<z.ZodString>;
            safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
                category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
                threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
            }, "strip", z.ZodTypeAny, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }>, "many">>;
            vertexRetrieval: z.ZodOptional<z.ZodObject<{
                datastore: z.ZodObject<{
                    projectId: z.ZodOptional<z.ZodString>;
                    location: z.ZodOptional<z.ZodString>;
                    dataStoreId: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }>;
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }>>;
            googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                disableAttribution?: boolean | undefined;
            }, {
                disableAttribution?: boolean | undefined;
            }>>;
            functionCallingConfig: z.ZodOptional<z.ZodObject<{
                mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
                allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "strip", z.ZodTypeAny, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }>>;
            thinkingConfig: z.ZodOptional<z.ZodObject<{
                includeThoughts: z.ZodOptional<z.ZodBoolean>;
                thinkingBudget: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            version: z.ZodOptional<z.ZodString>;
            maxOutputTokens: z.ZodOptional<z.ZodNumber>;
            topK: z.ZodOptional<z.ZodNumber>;
            stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        } & {
            apiKey: z.ZodOptional<z.ZodString>;
            labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
            temperature: z.ZodOptional<z.ZodNumber>;
            topP: z.ZodOptional<z.ZodNumber>;
            location: z.ZodOptional<z.ZodString>;
            safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
                category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
                threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
            }, "strip", z.ZodTypeAny, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }>, "many">>;
            vertexRetrieval: z.ZodOptional<z.ZodObject<{
                datastore: z.ZodObject<{
                    projectId: z.ZodOptional<z.ZodString>;
                    location: z.ZodOptional<z.ZodString>;
                    dataStoreId: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }>;
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }>>;
            googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                disableAttribution?: boolean | undefined;
            }, {
                disableAttribution?: boolean | undefined;
            }>>;
            functionCallingConfig: z.ZodOptional<z.ZodObject<{
                mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
                allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "strip", z.ZodTypeAny, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }>>;
            thinkingConfig: z.ZodOptional<z.ZodObject<{
                includeThoughts: z.ZodOptional<z.ZodBoolean>;
                thinkingBudget: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            version: z.ZodOptional<z.ZodString>;
            maxOutputTokens: z.ZodOptional<z.ZodNumber>;
            topK: z.ZodOptional<z.ZodNumber>;
            stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        } & {
            apiKey: z.ZodOptional<z.ZodString>;
            labels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
            temperature: z.ZodOptional<z.ZodNumber>;
            topP: z.ZodOptional<z.ZodNumber>;
            location: z.ZodOptional<z.ZodString>;
            safetySettings: z.ZodOptional<z.ZodArray<z.ZodObject<{
                category: z.ZodEnum<["HARM_CATEGORY_UNSPECIFIED", "HARM_CATEGORY_HATE_SPEECH", "HARM_CATEGORY_DANGEROUS_CONTENT", "HARM_CATEGORY_HARASSMENT", "HARM_CATEGORY_SEXUALLY_EXPLICIT"]>;
                threshold: z.ZodEnum<["BLOCK_LOW_AND_ABOVE", "BLOCK_MEDIUM_AND_ABOVE", "BLOCK_ONLY_HIGH", "BLOCK_NONE"]>;
            }, "strip", z.ZodTypeAny, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }, {
                category: "HARM_CATEGORY_UNSPECIFIED" | "HARM_CATEGORY_HATE_SPEECH" | "HARM_CATEGORY_SEXUALLY_EXPLICIT" | "HARM_CATEGORY_HARASSMENT" | "HARM_CATEGORY_DANGEROUS_CONTENT";
                threshold: "BLOCK_LOW_AND_ABOVE" | "BLOCK_MEDIUM_AND_ABOVE" | "BLOCK_ONLY_HIGH" | "BLOCK_NONE";
            }>, "many">>;
            vertexRetrieval: z.ZodOptional<z.ZodObject<{
                datastore: z.ZodObject<{
                    projectId: z.ZodOptional<z.ZodString>;
                    location: z.ZodOptional<z.ZodString>;
                    dataStoreId: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }, {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                }>;
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }, {
                datastore: {
                    dataStoreId: string;
                    location?: string | undefined;
                    projectId?: string | undefined;
                };
                disableAttribution?: boolean | undefined;
            }>>;
            googleSearchRetrieval: z.ZodOptional<z.ZodObject<{
                disableAttribution: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                disableAttribution?: boolean | undefined;
            }, {
                disableAttribution?: boolean | undefined;
            }>>;
            functionCallingConfig: z.ZodOptional<z.ZodObject<{
                mode: z.ZodOptional<z.ZodEnum<["MODE_UNSPECIFIED", "AUTO", "ANY", "NONE"]>>;
                allowedFunctionNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "strip", z.ZodTypeAny, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }, {
                mode?: "MODE_UNSPECIFIED" | "ANY" | "AUTO" | "NONE" | undefined;
                allowedFunctionNames?: string[] | undefined;
            }>>;
            thinkingConfig: z.ZodOptional<z.ZodObject<{
                includeThoughts: z.ZodOptional<z.ZodBoolean>;
                thinkingBudget: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }, {
                includeThoughts?: boolean | undefined;
                thinkingBudget?: number | undefined;
            }>>;
        }, z.ZodTypeAny, "passthrough">>>;
    };
};

export { GENERIC_MODEL, type GeminiConfig, GeminiConfigSchema, type GeminiConfigSchemaType, type GeminiModelName, KNOWN_MODELS, type KnownModels, SafetySettingsSchema, TEST_ONLY, defineKnownModels, defineModel, isGeminiModelName, listActions, model };
