import { ModelReference, z, EmbedderReference } from 'genkit';
import { GenkitPlugin } from 'genkit/plugin';
import { EmbeddingConfig, EmbeddingConfigSchemaType } from './embedder.js';
import { KnownModels, GeminiModelName, GeminiConfig, GeminiConfigSchemaType } from './gemini.js';
import { KnownModels as KnownModels$1, ImagenModelName, ImagenConfig, ImagenConfigSchemaType } from './imagen.js';
import { KnownModels as KnownModels$2, LyriaModelName, LyriaConfig, LyriaConfigSchemaType } from './lyria.js';
import { KnownModels as KnownModels$3, VeoModelName, VeoConfig, VeoConfigSchemaType } from './veo.js';
import { VertexPluginOptions } from './types.js';
import 'genkit/embedder';
import 'genkit/model';
import 'google-auth-library';
import '../common/types.js';

/**
 * @license
 *
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @module /
 */

type VertexAIPlugin = {
    (pluginOptions?: VertexPluginOptions): GenkitPlugin;
    model(name: KnownModels | (GeminiModelName & {}), config?: GeminiConfig): ModelReference<GeminiConfigSchemaType>;
    model(name: KnownModels$1 | (ImagenModelName & {}), config?: ImagenConfig): ModelReference<ImagenConfigSchemaType>;
    model(name: KnownModels$2 | (LyriaModelName & {}), config: LyriaConfig): ModelReference<LyriaConfigSchemaType>;
    model(name: KnownModels$3 | (VeoModelName & {}), config: VeoConfig): ModelReference<VeoConfigSchemaType>;
    model(name: string, config?: any): ModelReference<z.ZodTypeAny>;
    embedder(name: string, config?: EmbeddingConfig): EmbedderReference<EmbeddingConfigSchemaType>;
};
/**
 * Google Cloud Vertex AI plugin for Genkit.
 * Includes Gemini and Imagen models and text embedder.
 */
declare const vertexAI: VertexAIPlugin;

export { EmbeddingConfig, GeminiConfig, ImagenConfig, LyriaConfig, VeoConfig, type VertexAIPlugin, VertexPluginOptions, vertexAI as default, vertexAI };
