import { ModelReference, z, ActionMetadata, Genkit } from 'genkit';
import { ModelAction } from 'genkit/model';
import { Model, ClientOptions, VertexPluginOptions } from './types.js';
import 'google-auth-library';
import '../common/types.js';

/**
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

declare const LyriaConfigSchema: z.ZodObject<{
    negativePrompt: z.ZodOptional<z.ZodString>;
    seed: z.ZodOptional<z.ZodNumber>;
    sampleCount: z.ZodOptional<z.ZodNumber>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    negativePrompt: z.ZodOptional<z.ZodString>;
    seed: z.ZodOptional<z.ZodNumber>;
    sampleCount: z.ZodOptional<z.ZodNumber>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    negativePrompt: z.ZodOptional<z.ZodString>;
    seed: z.ZodOptional<z.ZodNumber>;
    sampleCount: z.ZodOptional<z.ZodNumber>;
}, z.ZodTypeAny, "passthrough">>;
type LyriaConfigSchemaType = typeof LyriaConfigSchema;
type LyriaConfig = z.infer<LyriaConfigSchemaType>;
type ConfigSchemaType = LyriaConfigSchemaType;
declare const KNOWN_MODELS: {
    readonly 'lyria-002': ModelReference<z.ZodObject<{
        negativePrompt: z.ZodOptional<z.ZodString>;
        seed: z.ZodOptional<z.ZodNumber>;
        sampleCount: z.ZodOptional<z.ZodNumber>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        negativePrompt: z.ZodOptional<z.ZodString>;
        seed: z.ZodOptional<z.ZodNumber>;
        sampleCount: z.ZodOptional<z.ZodNumber>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        negativePrompt: z.ZodOptional<z.ZodString>;
        seed: z.ZodOptional<z.ZodNumber>;
        sampleCount: z.ZodOptional<z.ZodNumber>;
    }, z.ZodTypeAny, "passthrough">>>;
};
type KnownModels = keyof typeof KNOWN_MODELS;
type LyriaModelName = `lyria-${string}`;
declare function isLyriaModelName(value?: string): value is LyriaModelName;
declare function model(version: string, config?: LyriaConfig): ModelReference<ConfigSchemaType>;
declare function listActions(models: Model[]): ActionMetadata[];
declare function defineKnownModels(ai: Genkit, clientOptions: ClientOptions, pluginOptions?: VertexPluginOptions): void;
declare function defineModel(ai: Genkit, name: string, clientOptions: ClientOptions, pluginOptions?: VertexPluginOptions): ModelAction;
declare const TEST_ONLY: {
    GENERIC_MODEL: ModelReference<z.ZodObject<{
        negativePrompt: z.ZodOptional<z.ZodString>;
        seed: z.ZodOptional<z.ZodNumber>;
        sampleCount: z.ZodOptional<z.ZodNumber>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        negativePrompt: z.ZodOptional<z.ZodString>;
        seed: z.ZodOptional<z.ZodNumber>;
        sampleCount: z.ZodOptional<z.ZodNumber>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        negativePrompt: z.ZodOptional<z.ZodString>;
        seed: z.ZodOptional<z.ZodNumber>;
        sampleCount: z.ZodOptional<z.ZodNumber>;
    }, z.ZodTypeAny, "passthrough">>>;
    KNOWN_MODELS: {
        readonly 'lyria-002': ModelReference<z.ZodObject<{
            negativePrompt: z.ZodOptional<z.ZodString>;
            seed: z.ZodOptional<z.ZodNumber>;
            sampleCount: z.ZodOptional<z.ZodNumber>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            negativePrompt: z.ZodOptional<z.ZodString>;
            seed: z.ZodOptional<z.ZodNumber>;
            sampleCount: z.ZodOptional<z.ZodNumber>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            negativePrompt: z.ZodOptional<z.ZodString>;
            seed: z.ZodOptional<z.ZodNumber>;
            sampleCount: z.ZodOptional<z.ZodNumber>;
        }, z.ZodTypeAny, "passthrough">>>;
    };
};

export { type KnownModels, type LyriaConfig, LyriaConfigSchema, type LyriaConfigSchemaType, type LyriaModelName, TEST_ONLY, defineKnownModels, defineModel, isLyriaModelName, listActions, model };
