"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var veo_exports = {};
__export(veo_exports, {
  TEST_ONLY: () => TEST_ONLY,
  VeoConfigSchema: () => VeoConfigSchema,
  defineKnownModels: () => defineKnownModels,
  defineModel: () => defineModel,
  isVeoModelName: () => isVeoModelName,
  listActions: () => listActions,
  model: () => model
});
module.exports = __toCommonJS(veo_exports);
var import_genkit = require("genkit");
var import_client = require("./client.js");
var import_converters = require("./converters.js");
var import_utils = require("./utils.js");
const VeoConfigSchema = import_genkit.z.object({
  sampleCount: import_genkit.z.number().optional().describe("Number of output videos"),
  storageUri: import_genkit.z.string().optional().describe("The gcs bucket where to save the generated videos"),
  fps: import_genkit.z.number().optional().describe("Frames per second for video generation"),
  durationSeconds: import_genkit.z.number().optional().describe("Duration of the clip for video generation in seconds"),
  seed: import_genkit.z.number().optional().describe(
    "The RNG seed. If RNG seed is exactly same for each request with unchanged inputs, the prediction results will be consistent. Otherwise, a random RNG seed will be used each time to produce a different result. If the sample count is greater than 1, random seeds will be used for each sample."
  ),
  aspectRatio: import_genkit.z.enum(["9:16", "16:9"]).optional().describe("The aspect ratio for the generated video"),
  resolution: import_genkit.z.enum(["720p", "1080p"]).optional().describe("The resolution for the generated video"),
  personGeneration: import_genkit.z.enum(["dont_allow", "allow_adult", "allow_all"]).optional().describe(
    "Specifies the policy for generating persons in videos, including age restrictions"
  ),
  pubsubTopic: import_genkit.z.string().optional().describe("The pubsub topic to publish the video generation progress to"),
  negativePrompt: import_genkit.z.string().optional().describe(
    "In addition to the text context, negative prompts can be explicitly stated here to help generate the video"
  ),
  enhancePrompt: import_genkit.z.boolean().optional().describe(
    "If true, the prompt will be improved before it is used to generate videos. The RNG seed, if provided, will not result in consistent results if prompts are enhanced."
  ),
  generateAudio: import_genkit.z.boolean().optional().describe("If true, audio will be generated along with the video"),
  compressionQuality: import_genkit.z.enum(["optimized", "lossless"]).default("optimized").optional().describe("Compression quality of the generated video")
}).passthrough();
function commonRef(name, info, configSchema = VeoConfigSchema) {
  return (0, import_genkit.modelRef)({
    name: `vertexai/${name}`,
    configSchema,
    info: info ?? {
      supports: {
        media: true,
        multiturn: false,
        tools: false,
        systemRole: false,
        output: ["media"],
        longRunning: true
      }
    }
    // TODO(ifielker): Remove this cast if we fix longRunning
  });
}
const GENERIC_MODEL = commonRef("veo");
const KNOWN_MODELS = {
  "veo-2.0-generate-001": commonRef("veo-2.0-generate-001"),
  "veo-3.0-generate-001": commonRef("veo-3.0-generate-001"),
  "veo-3.0-fast-generate-001": commonRef("veo-3.0-fast-generate-001"),
  "veo-3.0-generate-preview": commonRef("veo-3.0-generate-preview"),
  "veo-3.0-fast-generate-preview": commonRef("veo-3.0-fast-generate-preview")
};
function isVeoModelName(value) {
  return !!value?.startsWith("veo-");
}
function model(version, config = {}) {
  const name = (0, import_utils.checkModelName)(version);
  return (0, import_genkit.modelRef)({
    name: `vertexai/${name}`,
    config,
    configSchema: VeoConfigSchema,
    info: { ...GENERIC_MODEL.info }
  });
}
function listActions(models) {
  return models.filter((m) => isVeoModelName(m.name)).map((m) => {
    const ref = model(m.name);
    return (0, import_genkit.modelActionMetadata)({
      name: ref.name,
      info: ref.info,
      configSchema: ref.configSchema
    });
  });
}
function defineKnownModels(ai, clientOptions, pluginOptions) {
  for (const name of Object.keys(KNOWN_MODELS)) {
    defineModel(ai, name, clientOptions, pluginOptions);
  }
}
function defineModel(ai, name, clientOptions, pluginOptions) {
  const ref = model(name);
  return ai.defineBackgroundModel({
    name: ref.name,
    ...ref.info,
    configSchema: ref.configSchema,
    async start(request) {
      const veoPredictRequest = (0, import_converters.toVeoPredictRequest)(request);
      const response = await (0, import_client.veoPredict)(
        (0, import_utils.extractVersion)(ref),
        veoPredictRequest,
        clientOptions
      );
      return (0, import_converters.fromVeoOperation)(response);
    },
    async check(operation) {
      const response = await (0, import_client.veoCheckOperation)(
        (0, import_converters.toVeoModel)(operation),
        (0, import_converters.toVeoOperationRequest)(operation),
        clientOptions
      );
      return (0, import_converters.fromVeoOperation)(response);
    }
  });
}
const TEST_ONLY = {
  GENERIC_MODEL,
  KNOWN_MODELS
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  TEST_ONLY,
  VeoConfigSchema,
  defineKnownModels,
  defineModel,
  isVeoModelName,
  listActions,
  model
});
//# sourceMappingURL=veo.js.map