import { type TraceData, type TraceQueryFilter } from '@genkit-ai/tools-common';
import { Mutex } from 'async-mutex';
import type { TraceQuery, TraceQueryResponse, TraceStore } from './types';
export declare class LocalFileTraceStore implements TraceStore {
    private readonly storeRoot;
    private readonly indexRoot;
    private mutexes;
    private filters;
    private readonly index;
    static defaultFilters: Record<string, string>;
    constructor(options: {
        filters?: Record<string, string>;
        storeRoot: string;
        indexRoot: string;
    });
    init(): Promise<void>;
    private reIndex;
    load(id: string): Promise<TraceData | undefined>;
    getMutex(id: string): Mutex;
    save(id: string, rawTrace: TraceData): Promise<void>;
    list(query?: TraceQuery): Promise<TraceQueryResponse>;
    private listFromFiles;
    private filter;
}
export declare function trucateLargeAttrs<T>(input: T): T;
export interface IndexSearchResult {
    pageLastIndex?: number;
    data: Record<string, string>[];
}
export declare class Index {
    private indexRoot;
    private currentIndexFile;
    constructor(indexRoot: string);
    clear(): void;
    metadataFileName(): string;
    getMetadata(): {
        version: string;
    } | undefined;
    private newIndexFileName;
    listIndexFiles(): string[];
    add(traceData: TraceData): void;
    search(query: {
        limit: number;
        startFromIndex?: number;
        filter?: TraceQueryFilter;
    }): IndexSearchResult;
}
