"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GenerateActionOptionsSchema = exports.GenerateActionOutputConfig = exports.GenerateResponseChunkSchema = exports.ModelResponseChunkSchema = exports.GenerateResponseSchema = exports.ModelResponseSchema = exports.CandidateErrorSchema = exports.CandidateSchema = exports.FinishReasonSchema = exports.GenerationUsageSchema = exports.GenerateRequestSchema = exports.ModelRequestSchema = exports.OutputConfigSchema = exports.GenerationCommonConfigSchema = exports.ToolDefinitionSchema = exports.ModelInfoSchema = exports.MessageSchema = exports.RoleSchema = exports.PartSchema = exports.OperationSchema = exports.ToolResponsePartSchema = exports.ToolRequestPartSchema = exports.TextPartSchema = exports.ResourcePartSchema = exports.MediaPartSchema = exports.DataPartSchema = exports.CustomPartSchema = void 0;
const zod_1 = require("zod");
const document_1 = require("./document");
Object.defineProperty(exports, "CustomPartSchema", { enumerable: true, get: function () { return document_1.CustomPartSchema; } });
Object.defineProperty(exports, "DataPartSchema", { enumerable: true, get: function () { return document_1.DataPartSchema; } });
Object.defineProperty(exports, "MediaPartSchema", { enumerable: true, get: function () { return document_1.MediaPartSchema; } });
Object.defineProperty(exports, "ResourcePartSchema", { enumerable: true, get: function () { return document_1.ResourcePartSchema; } });
Object.defineProperty(exports, "TextPartSchema", { enumerable: true, get: function () { return document_1.TextPartSchema; } });
Object.defineProperty(exports, "ToolRequestPartSchema", { enumerable: true, get: function () { return document_1.ToolRequestPartSchema; } });
Object.defineProperty(exports, "ToolResponsePartSchema", { enumerable: true, get: function () { return document_1.ToolResponsePartSchema; } });
exports.OperationSchema = zod_1.z.object({
    action: zod_1.z.string().optional(),
    id: zod_1.z.string(),
    done: zod_1.z.boolean().optional(),
    output: zod_1.z.any().optional(),
    error: zod_1.z.object({ message: zod_1.z.string() }).passthrough().optional(),
    metadata: zod_1.z.record(zod_1.z.string(), zod_1.z.any()).optional(),
});
exports.PartSchema = zod_1.z.union([
    document_1.TextPartSchema,
    document_1.MediaPartSchema,
    document_1.ToolRequestPartSchema,
    document_1.ToolResponsePartSchema,
    document_1.DataPartSchema,
    document_1.CustomPartSchema,
    document_1.ReasoningPartSchema,
    document_1.ResourcePartSchema,
]);
exports.RoleSchema = zod_1.z.enum(['system', 'user', 'model', 'tool']);
exports.MessageSchema = zod_1.z.object({
    role: exports.RoleSchema,
    content: zod_1.z.array(exports.PartSchema),
    metadata: zod_1.z.record(zod_1.z.unknown()).optional(),
});
exports.ModelInfoSchema = zod_1.z.object({
    versions: zod_1.z.array(zod_1.z.string()).optional(),
    label: zod_1.z.string().optional(),
    configSchema: zod_1.z.record(zod_1.z.any()).optional(),
    supports: zod_1.z
        .object({
        multiturn: zod_1.z.boolean().optional(),
        media: zod_1.z.boolean().optional(),
        tools: zod_1.z.boolean().optional(),
        systemRole: zod_1.z.boolean().optional(),
        output: zod_1.z.array(zod_1.z.string()).optional(),
        contentType: zod_1.z.array(zod_1.z.string()).optional(),
        context: zod_1.z.boolean().optional(),
        constrained: zod_1.z.enum(['none', 'all', 'no-tools']).optional(),
        toolChoice: zod_1.z.boolean().optional(),
    })
        .optional(),
    stage: zod_1.z
        .enum(['featured', 'stable', 'unstable', 'legacy', 'deprecated'])
        .optional(),
});
exports.ToolDefinitionSchema = zod_1.z.object({
    name: zod_1.z.string(),
    description: zod_1.z.string(),
    inputSchema: zod_1.z
        .record(zod_1.z.any())
        .describe('Valid JSON Schema representing the input of the tool.')
        .nullish(),
    outputSchema: zod_1.z
        .record(zod_1.z.any())
        .describe('Valid JSON Schema describing the output of the tool.')
        .nullish(),
    metadata: zod_1.z
        .record(zod_1.z.any())
        .describe('additional metadata for this tool definition')
        .optional(),
});
exports.GenerationCommonConfigSchema = zod_1.z.object({
    version: zod_1.z.string().optional(),
    temperature: zod_1.z.number().optional(),
    maxOutputTokens: zod_1.z.number().optional(),
    topK: zod_1.z.number().optional(),
    topP: zod_1.z.number().optional(),
    stopSequences: zod_1.z.array(zod_1.z.string()).optional(),
});
exports.OutputConfigSchema = zod_1.z.object({
    format: zod_1.z.string().optional(),
    schema: zod_1.z.record(zod_1.z.any()).optional(),
    constrained: zod_1.z.boolean().optional(),
    contentType: zod_1.z.string().optional(),
});
exports.ModelRequestSchema = zod_1.z.object({
    messages: zod_1.z.array(exports.MessageSchema),
    config: zod_1.z.any().optional(),
    tools: zod_1.z.array(exports.ToolDefinitionSchema).optional(),
    toolChoice: zod_1.z.enum(['auto', 'required', 'none']).optional(),
    output: exports.OutputConfigSchema.optional(),
    docs: zod_1.z.array(document_1.DocumentDataSchema).optional(),
});
exports.GenerateRequestSchema = exports.ModelRequestSchema.extend({
    candidates: zod_1.z.number().optional(),
});
exports.GenerationUsageSchema = zod_1.z.object({
    inputTokens: zod_1.z.number().optional(),
    outputTokens: zod_1.z.number().optional(),
    totalTokens: zod_1.z.number().optional(),
    inputCharacters: zod_1.z.number().optional(),
    outputCharacters: zod_1.z.number().optional(),
    inputImages: zod_1.z.number().optional(),
    outputImages: zod_1.z.number().optional(),
    inputVideos: zod_1.z.number().optional(),
    outputVideos: zod_1.z.number().optional(),
    inputAudioFiles: zod_1.z.number().optional(),
    outputAudioFiles: zod_1.z.number().optional(),
    custom: zod_1.z.record(zod_1.z.number()).optional(),
    thoughtsTokens: zod_1.z.number().optional(),
    cachedContentTokens: zod_1.z.number().optional(),
});
exports.FinishReasonSchema = zod_1.z.enum([
    'stop',
    'length',
    'blocked',
    'interrupted',
    'other',
    'unknown',
]);
exports.CandidateSchema = zod_1.z.object({
    index: zod_1.z.number(),
    message: exports.MessageSchema,
    usage: exports.GenerationUsageSchema.optional(),
    finishReason: exports.FinishReasonSchema,
    finishMessage: zod_1.z.string().optional(),
    custom: zod_1.z.unknown(),
});
exports.CandidateErrorSchema = zod_1.z.object({
    index: zod_1.z.number(),
    code: zod_1.z.enum(['blocked', 'other', 'unknown']),
    message: zod_1.z.string().optional(),
});
exports.ModelResponseSchema = zod_1.z.object({
    message: exports.MessageSchema.optional(),
    finishReason: exports.FinishReasonSchema,
    finishMessage: zod_1.z.string().optional(),
    latencyMs: zod_1.z.number().optional(),
    usage: exports.GenerationUsageSchema.optional(),
    custom: zod_1.z.unknown(),
    raw: zod_1.z.unknown(),
    request: exports.GenerateRequestSchema.optional(),
    operation: exports.OperationSchema.optional(),
});
exports.GenerateResponseSchema = exports.ModelResponseSchema.extend({
    candidates: zod_1.z.array(exports.CandidateSchema).optional(),
    finishReason: exports.FinishReasonSchema.optional(),
});
exports.ModelResponseChunkSchema = zod_1.z.object({
    role: exports.RoleSchema.optional(),
    index: zod_1.z.number().optional(),
    content: zod_1.z.array(exports.PartSchema),
    custom: zod_1.z.unknown().optional(),
    aggregated: zod_1.z.boolean().optional(),
});
exports.GenerateResponseChunkSchema = exports.ModelResponseChunkSchema;
exports.GenerateActionOutputConfig = zod_1.z.object({
    format: zod_1.z.string().optional(),
    contentType: zod_1.z.string().optional(),
    instructions: zod_1.z.union([zod_1.z.boolean(), zod_1.z.string()]).optional(),
    jsonSchema: zod_1.z.any().optional(),
    constrained: zod_1.z.boolean().optional(),
});
exports.GenerateActionOptionsSchema = zod_1.z.object({
    model: zod_1.z.string(),
    docs: zod_1.z.array(document_1.DocumentDataSchema).optional(),
    messages: zod_1.z.array(exports.MessageSchema),
    tools: zod_1.z.array(zod_1.z.string()).optional(),
    toolChoice: zod_1.z.enum(['auto', 'required', 'none']).optional(),
    config: zod_1.z.any().optional(),
    output: exports.GenerateActionOutputConfig.optional(),
    resume: zod_1.z
        .object({
        respond: zod_1.z.array(document_1.ToolResponsePartSchema).optional(),
        restart: zod_1.z.array(document_1.ToolRequestPartSchema).optional(),
        metadata: zod_1.z.record(zod_1.z.any()).optional(),
    })
        .optional(),
    returnToolRequests: zod_1.z.boolean().optional(),
    maxTurns: zod_1.z.number().optional(),
    stepName: zod_1.z.string().optional(),
});
//# sourceMappingURL=model.js.map