import * as clc from 'colorette';
import * as winston from 'winston';
const defaultTransport = new winston.transports.Console();
export function forceStderr() {
    logger.remove(defaultTransport);
    logger.add(new winston.transports.Stream({
        stream: process.stderr,
    }));
}
export const logger = winston.createLogger({
    level: process.env.DEBUG ? 'debug' : 'info',
    format: winston.format.printf((log) => {
        if (log.level === 'info')
            return log.message;
        let levelColor;
        switch (log.level) {
            case 'error':
                levelColor = clc.red;
                break;
            case 'warn':
                levelColor = clc.yellow;
                break;
            default:
                levelColor = (text) => text.toString();
                break;
        }
        const level = log.level.charAt(0).toUpperCase() + log.level.slice(1);
        return `${clc.bold(levelColor(level))}: ${log.message}`;
    }),
    transports: [defaultTransport],
});
//# sourceMappingURL=logger.js.map