import type { CreateDatasetRequest, UpdateDatasetRequest } from '../types/apis';
import { type Dataset, type DatasetMetadata, type DatasetStore } from '../types/eval';
export declare class LocalFileDatasetStore implements DatasetStore {
    private readonly storeRoot;
    private readonly indexFile;
    private static cachedDatasetStore;
    private constructor();
    static getDatasetStore(): LocalFileDatasetStore;
    static reset(): void;
    createDataset(req: CreateDatasetRequest): Promise<DatasetMetadata>;
    private createDatasetInternal;
    updateDataset(req: UpdateDatasetRequest): Promise<DatasetMetadata>;
    getDataset(datasetId: string): Promise<Dataset>;
    listDatasets(): Promise<DatasetMetadata[]>;
    deleteDataset(datasetId: string): Promise<void>;
    private static generateRootPath;
    generateDatasetId(datasetId?: string): Promise<string>;
    private testUniqueness;
    private generateFileName;
    private getIndexFilePath;
    private getMetadataMap;
    private getDatasetFromInferenceDataset;
    private patchDataset;
}
