import { protos, ServiceContext } from '@google-cloud/logging';
import { LogSeverityFunctions } from '@google-cloud/logging/build/src/utils/log-common';
import { Options } from '.';
import { Entry, LogEntry } from '@google-cloud/logging/build/src/entry';
type Callback = (err: Error | null, apiResponse?: {}) => void;
export type MonitoredResource = protos.google.api.MonitoredResource;
export interface StackdriverData {
    serviceContext?: ServiceContext;
    message?: string;
    metadata?: Metadata | MetadataArg;
}
export interface Metadata {
    stack?: string;
    httpRequest?: protos.google.logging.type.IHttpRequest;
    labels?: {};
    [key: string]: any;
}
/*!
 * Log entry data key to allow users to indicate a trace for the request.
 */
export declare const LOGGING_TRACE_KEY = "logging.googleapis.com/trace";
/*!
 * Log entry data key to allow users to indicate a spanId for the request.
 */
export declare const LOGGING_SPAN_KEY = "logging.googleapis.com/spanId";
/*!
 * Log entry data key to allow users to indicate a traceSampled flag for the request.
 */
export declare const LOGGING_SAMPLED_KEY = "logging.googleapis.com/trace_sampled";
/**
 * Default library version to be used
 * Using release-please annotations to update DEFAULT_INSTRUMENTATION_VERSION with latest version.
 * See https://github.com/googleapis/release-please/blob/main/docs/customizing.md#updating-arbitrary-files
 */
export declare const NODEJS_WINSTON_DEFAULT_LIBRARY_VERSION = "6.0.1";
/*!
 * Gets the current fully qualified trace ID when available from the
 * @google-cloud/trace-agent library in the LogEntry.trace field format of:
 * "projects/[PROJECT-ID]/traces/[TRACE-ID]".
 */
export declare function getCurrentTraceFromAgent(): string | null;
export declare class LoggingCommon {
    readonly logName: string;
    private inspectMetadata;
    private levels;
    cloudLog: LogSeverityFunctions;
    private resource;
    private serviceContext;
    private prefix;
    private labels;
    private defaultCallback?;
    redirectToStdout: boolean;
    static readonly LOGGING_TRACE_KEY = "logging.googleapis.com/trace";
    static readonly LOGGING_SPAN_KEY = "logging.googleapis.com/spanId";
    constructor(options?: Options);
    log(level: string, message: string, metadata: MetadataArg | undefined, callback: Callback): void;
    entry(metadata?: LogEntry, data?: string | {}): Entry;
}
export declare function getNodejsLibraryVersion(): string;
type MetadataArg = {
    stack?: {};
    /**
     * set httpRequest to a http.clientRequest object to log it
     */
    httpRequest?: protos.google.logging.type.IHttpRequest;
    labels?: {};
    timestamp?: {};
    logName?: string;
} & {
    [key: string]: string | {};
};
export {};
