import TransportStream = require('winston-transport');
import { LoggingCommon, getCurrentTraceFromAgent } from './common';
import * as express from './middleware/express';
import { getDefaultMetadataForTracing } from './default-metadata';
import { MonitoredResource, ServiceContext, LoggingOptions } from '@google-cloud/logging';
export { express };
export { getDefaultMetadataForTracing };
export { getCurrentTraceFromAgent };
type Callback = (err: Error | null, apiResponse?: {}) => void;
export interface Options extends LoggingOptions {
    /**
     * The default log level. Winston will filter messages with a severity lower
     * than this.
     */
    level?: string;
    /**
     * Custom logging levels as supported by winston. This list is used to
     * translate your log level to the Cloud Logging level. Each property
     * should have an integer value between 0 (most severe) and 7 (least severe).
     * If you are passing a list of levels to your winston logger, you should
     * provide the same list here.
     */
    levels?: {
        [name: string]: number;
    };
    /**
     *  Serialize winston-provided log metadata using `util.inspect`.
     */
    inspectMetadata?: boolean;
    /**
     * The name of the log that will receive messages written to this transport.
     */
    logName?: string;
    /**
     * The monitored resource that the transport corresponds to. On Google Cloud
     * Platform, this is detected automatically, but you may optionally specify a
     * specific monitored resource. For more information see the
     * [official documentation]{@link
     * https://cloud.google.com/logging/docs/api/reference/rest/v2/MonitoredResource}.
     */
    resource?: MonitoredResource;
    /**
     * For logged errors, we provide this as the service context. For more
     * information see [this guide]{@link
     * https://cloud.google.com/error-reporting/docs/formatting-error-messages}
     * and the [official documentation]{@link
     * https://cloud.google.com/error-reporting/reference/rest/v1beta1/ServiceContext}.
     */
    serviceContext?: ServiceContext;
    logname?: string;
    prefix?: string;
    labels?: {
        [key: string]: string;
    };
    maxEntrySize?: number;
    defaultCallback?: Callback;
    /**
     * Boolen flag that opts-in redirecting the output to STDOUT instead of ingesting logs to Cloud
     * Logging using Logging API. Defaults to {@code false}. Redirecting logs can be used in
     * Google Cloud environments with installed logging agent to delegate log ingestions to the
     * agent. Redirected logs are formatted as one line Json string following the structured logging guidelines.
     */
    redirectToStdout?: boolean;
    /**
     * Boolean flag indicating if "message" field should be used to store structured,
     * non-text data inside jsonPayload field. This flag applies only when {@link Options#redirectToStdout} is set.
     * By default this value is true
     */
    useMessageField?: boolean;
    /**
     * Additional parameters for {@link TransportStream}. For more information on parameters,
     * please see [winston-transport](https://github.com/winstonjs/winston-transport/blob/0e5e4c0056188a74e24407ee066902fb113bd8de/index.js#L8).
     */
    format?: any;
    silent?: boolean;
    handleExceptions?: boolean;
    handleRejections?: boolean;
}
/**
 * This module provides support for streaming your winston logs to
 * [Cloud Logging](https://cloud.google.com/logging).
 *
 * @class
 *
 * @param {object} [options]
 * @param {object} [options.level] The default log level. Winston will filter
 *     messages with a severity lower than this.
 * @param {object} [options.levels] Custom logging levels as supported by
 *     winston. This list is used to translate your log level to the Cloud
 *     Logging level. Each property should have an integer value between 0 (most
 *     severe) and 7 (least severe). If you are passing a list of levels to your
 *     winston logger, you should provide the same list here.
 * @param {boolean} [options.inspectMetadata=false] Serialize winston-provided log
 *     metadata using `util.inspect`.
 * @param {string} [options.logName=winston_log] The name of the log that will receive
 *     messages written to this transport.
 * @param {object} [options.resource] The monitored resource that the transport
 *     corresponds to. On Google Cloud Platform, this is detected automatically,
 *     but you may optionally specify a specific monitored resource. For more
 *     information see the
 *     [official documentation]{@link
 * https://cloud.google.com/logging/docs/api/reference/rest/v2/MonitoredResource}.
 * @param {object} [options.serviceContext] For logged errors, we provide this
 *     as the service context. For more information see
 *     [this guide]{@link
 * https://cloud.google.com/error-reporting/docs/formatting-error-messages} and
 * the [official documentation]{@link
 * https://cloud.google.com/error-reporting/reference/rest/v1beta1/ServiceContext}.
 * @param {string} [options.serviceContext.service] An identifier of the
 *     service, such as the name of the executable, job, or Google App Engine
 *     service name.
 * @param {string} [options.serviceContext.version] Represents the version of
 *     the service.
 * @param {string} [options.projectId] The project ID from the Google Cloud
 *     Console, e.g. 'grape-spaceship-123'. We will also check the environment
 *     variable `GCLOUD_PROJECT` for your project ID. If your app is running in
 *     an environment which supports {@link
 * https://cloud.google.com/docs/authentication/production#providing_credentials_to_your_application
 * Application Default Credentials}, your project ID will be detected
 * automatically.
 * @param {string} [options.keyFilename] Full path to the a .json, .pem, or .p12
 *     key downloaded from the Google Cloud Console. If you provide a path
 *     to a JSON file, the `projectId` option above is not necessary. NOTE: .pem
 *     and .p12 require you to specify the `email` option as well.
 * @param {string} [options.email] Account email address. Required when using a
 *     .pem or .p12 keyFilename.
 * @param {object} [options.credentials] Credentials object.
 * @param {string} [options.credentials.client_email]
 * @param {string} [options.credentials.private_key]
 * @param {boolean} [options.autoRetry=true] Automatically retry requests if the
 *     response is related to rate limits or certain intermittent server errors.
 *     We will exponentially backoff subsequent requests by default.
 * @param {number} [options.maxRetries=3] Maximum number of automatic retries
 *     attempted before returning the error.
 * @param {constructor} [options.promise] Custom promise module to use instead
 *     of native Promises.
 *
 * @example <caption>Import the client library</caption>
 * const {LoggingWinston} = require('@google-cloud/logging-winston');
 *
 * @example <caption>Create a client that uses <a
 * href="https://cloud.google.com/docs/authentication/production#providing_credentials_to_your_application">Application
 * Default Credentials (ADC)</a>:</caption> const loggingWinston = new
 * LoggingWinston();
 *
 * @example <caption>Create a client with <a
 * href="https://cloud.google.com/docs/authentication/production#obtaining_and_providing_service_account_credentials_manually">explicit
 * credentials</a>:</caption> const loggingWinston = new LoggingWinston({
 *   projectId: 'your-project-id',
 *   keyFilename: '/path/to/keyfile.json'
 * });
 *
 * @example <caption>include:samples/quickstart.js</caption>
 * region_tag:logging_winston_quickstart
 * Full quickstart example:
 */
export declare class LoggingWinston extends TransportStream {
    static readonly LOGGING_TRACE_KEY = "logging.googleapis.com/trace";
    static readonly LOGGING_SPAN_KEY = "logging.googleapis.com/spanId";
    static readonly LOGGING_SAMPLED_KEY = "logging.googleapis.com/trace_sampled";
    common: LoggingCommon;
    constructor(options?: Options);
    log(info: any, callback: Callback): void;
}
export declare const LOGGING_TRACE_KEY = "logging.googleapis.com/trace";
export declare const LOGGING_SPAN_KEY = "logging.googleapis.com/spanId";
export declare const LOGGING_SAMPLED_KEY = "logging.googleapis.com/trace_sampled";
