'use strict';

var index = require('./index-784ff647.js');
var codes = require('./codes-87f6824b.js');

/**
 * @internal
 */ function getErrorShape(opts) {
    const { path , error , config  } = opts;
    const { code  } = opts.error;
    const shape = {
        message: error.message,
        code: codes.TRPC_ERROR_CODES_BY_KEY[code],
        data: {
            code,
            httpStatus: index.getHTTPStatusCodeFromError(error)
        }
    };
    if (config.isDev && typeof opts.error.stack === 'string') {
        shape.data.stack = opts.error.stack;
    }
    if (typeof path === 'string') {
        shape.data.path = path;
    }
    return config.errorFormatter({
        ...opts,
        shape
    });
}

function transformTRPCResponseItem(config, item) {
    if ('error' in item) {
        return {
            ...item,
            error: config.transformer.output.serialize(item.error)
        };
    }
    if ('data' in item.result) {
        return {
            ...item,
            result: {
                ...item.result,
                data: config.transformer.output.serialize(item.result.data)
            }
        };
    }
    return item;
}
/**
 * Takes a unserialized `TRPCResponse` and serializes it with the router's transformers
 **/ function transformTRPCResponse(config, itemOrItems) {
    return Array.isArray(itemOrItems) ? itemOrItems.map((item)=>transformTRPCResponseItem(config, item)) : transformTRPCResponseItem(config, itemOrItems);
}

exports.getErrorShape = getErrorShape;
exports.transformTRPCResponse = transformTRPCResponse;
