import { toDate } from "./toDate.js";

import { getDate as coreGetDate } from "./_core/getDate.js";

/**
 * The {@link isFirstDayOfMonth} function options.
 */

/**
 * @name isFirstDayOfMonth
 * @category Month Helpers
 * @summary Is the given date the first day of a month?
 *
 * @description
 * Is the given date the first day of a month?
 *
 * @param date - The date to check
 * @param options - An object with options
 *
 * @returns The date is the first day of a month
 *
 * @example
 * // Is 1 September 2014 the first day of a month?
 * const result = isFirstDayOfMonth(new Date(2014, 8, 1))
 * //=> true
 */
export function isFirstDayOfMonth(date, options) {
  return coreGetDate(toDate(date, options?.in)) === 1;
}

// Fallback for modularized imports:
export default isFirstDayOfMonth;
