"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.defineUsageGuideTool = defineUsageGuideTool;
const utils_1 = require("@genkit-ai/tools-common/utils");
const zod_1 = __importDefault(require("zod"));
const analytics_js_1 = require("./analytics.js");
const go_js_1 = require("../commands/init-ai-tools/context/go.js");
const nodejs_js_1 = require("../commands/init-ai-tools/context/nodejs.js");
async function defineUsageGuideTool(server) {
    server.registerTool('get_usage_guide', {
        title: 'Genkit Instructions',
        description: 'Use this tool to look up the Genkit usage guide before implementing any AI feature',
        inputSchema: {
            language: zod_1.default
                .enum(['js', 'go'])
                .describe('which language this usage guide is for')
                .default('js')
                .optional(),
        },
    }, async ({ language }) => {
        await (0, utils_1.record)(new analytics_js_1.McpRunToolEvent('get_usage_guide'));
        const content = [];
        if (!language) {
            language = 'js';
        }
        let text = nodejs_js_1.GENKIT_CONTEXT;
        if (language === 'go') {
            text = go_js_1.GENKIT_CONTEXT;
        }
        content.push({
            type: 'text',
            text,
        });
        return { content };
    });
}
//# sourceMappingURL=usage.js.map