# React DayPicker

DayPicker is a [React](https://react.dev) component for creating date pickers, calendars, and date inputs for web applications.

## Documentation

See **[daypicker.dev](https://daypicker.dev)** for guides, examples and API reference, or read [the docs in the repository](website/docs/start.mdx).

<picture>
  <source media="(prefers-color-scheme: dark)" srcset="./website/static/img/screenshot-dark.png" />
  <source media="(prefers-color-scheme: light)" srcset="./website/static/img/screenshot-light.png" />
  <img width="460" src="./website/static/img/screenshot.png"  alt="Screenshot of DayPicker displaying the September 2025 calendar, with the date range from the 17th to the 20th selected." />
</picture>

## Features

- 🛠 Extensive set of props for [customizing](https://daypicker.dev/docs/customization) the calendar.
- 🎨 Minimal design that can be [easily styled](https://daypicker.dev/docs/styling) with CSS or any CSS framework.
- 📅 Supports [selections](https://daypicker.dev/docs/selection-modes) of single days, multiple days, ranges of days, or [custom selections](https://daypicker.dev/guides/custom-selections).
- 🌍 Can be [localized](https://daypicker.dev/docs/localization) into any language and [time zones](https://daypicker.dev/docs/time-zone).
- 🌐 Support for [ISO 8601](https://daypicker.dev/docs/localization#iso-week-dates), [Persian](https://daypicker.dev/docs/localization#persian-calendar), [Buddhist (Thai)](https://daypicker.dev/docs/localization#buddhist-thai-calendar), [Ethiopic](https://daypicker.dev/docs/localization#ethiopic-calendar), [Hebrew](https://daypicker.dev/docs/localization#hebrew-calendar) and [broadcast](https://daypicker.dev/docs/localization#broadcast-calendar) calendar.
- 🦮 Complies with WCAG 2.1 AA requirements for [accessibility](https://daypicker.dev/guides/accessibility).
- ⚙️ [Customizable components](https://daypicker.dev/guides/custom-components) to extend the rendered elements.
- 🔤 Easy integration [with input fields](https://daypicker.dev/guides/input-fields).

DayPicker is written in TypeScript and compiled to CommonJS and ESM. It relies on [date-fns](https://date-fns.org) for date manipulation and formatting.

## Installation

```bash
npm install react-day-picker
```

<a href="https://www.npmjs.com/package/react-day-picker"><img src="https://img.shields.io/npm/v/react-day-picker" alt="npm version"/></a> <img src="https://img.shields.io/npm/dm/react-day-picker.svg" alt="npm downloads"/> <img src="https://img.shields.io/bundlephobia/minzip/react-day-picker" alt="Min gzipped size"/>

## Example

```tsx
import { DayPicker } from "react-day-picker";
import "react-day-picker/style.css";

function MyDatePicker() {
  const [selected, setSelected] = useState<Date>();

  return (
    <DayPicker
      mode="single"
      selected={selected}
      onSelect={setSelected}
      footer={
        selected ? `Selected: ${selected.toLocaleDateString()}` : "Pick a day."
      }
    />
  );
}
```

## Compatibility

DayPicker is compatible with React 16.8 and later.

## License

DayPicker is released under the [MIT License](https://daypicker.dev/license).

## Community

Ask for help and share your experience with DayPicker:

- 💬 [Discussion forums](https://github.com/gpbl/react-day-picker/discussions) - Get support and provide feedback.
- 🪳 [Report an issue](https://github.com/gpbl/react-day-picker/issues/new/choose) - Report bugs or request features.

## Sponsors

Thank you to everyone supporting DayPicker - your sponsorship keeps this project maintained and evolving.

<p>
  <a href="https://github.com/CHECK24" title="CHECK24"><img src="https://github.com/CHECK24.png?size=64" alt="CHECK24" width="48" height="48" style="border-radius:50%; margin: 4px;" /></a>
  <a href="https://github.com/wilsonadenuga" title="wilsonadenuga"><img src="https://github.com/wilsonadenuga.png?size=64" alt="wilsonadenuga" width="48" height="48" style="border-radius:50%; margin: 4px;" /></a>
  <a href="https://github.com/severinlandolt" title="severinlandolt"><img src="https://github.com/severinlandolt.png?size=64" alt="severinlandolt" width="48" height="48" style="border-radius:50%; margin: 4px;" /></a>
  <a href="https://github.com/syntaxfm" title="syntaxfm"><img src="https://github.com/syntaxfm.png?size=64" alt="syntaxfm" width="48" height="48" style="border-radius:50%; margin: 4px;" /></a>
  <a href="https://github.com/thnxdev" title="thnxdev"><img src="https://github.com/thnxdev.png?size=64" alt="thnxdev" width="48" height="48" style="border-radius:50%; margin: 4px;" /></a>
  <a href="https://github.com/katyabilokur" title="katyabilokur"><img src="https://github.com/katyabilokur.png?size=64" alt="katyabilokur" width="48" height="48" style="border-radius:50%; margin: 4px;" /></a>
  <a href="https://github.com/bedandbreakfasteu" title="bedandbreakfasteu"><img src="https://github.com/bedandbreakfasteu.png?size=64" alt="bedandbreakfasteu" width="48" height="48" style="border-radius:50%; margin: 4px;" /></a>
  <a href="https://github.com/Thinkmill" title="Thinkmill"><img src="https://github.com/Thinkmill.png?size=64" alt="Thinkmill" width="48" height="48" style="border-radius:50%; margin: 4px;" /></a>
  <a href="https://github.com/AlexKDawson" title="AlexKDawson"><img src="https://github.com/AlexKDawson.png?size=64" alt="AlexKDawson" width="48" height="48" style="border-radius:50%; margin: 4px;" /></a>
  <a href="https://github.com/dimitur2204" title="dimitur2204"><img src="https://github.com/dimitur2204.png?size=64" alt="dimitur2204" width="48" height="48" style="border-radius:50%; margin: 4px;" /></a>
  <a href="https://github.com/indeedeng" title="indeedeng"><img src="https://github.com/indeedeng.png?size=64" alt="indeedeng" width="48" height="48" style="border-radius:50%; margin: 4px;" /></a>
  <a href="https://github.com/flexbox" title="flexbox"><img src="https://github.com/flexbox.png?size=64" alt="flexbox" width="48" height="48" style="border-radius:50%; margin: 4px;" /></a>
  <a href="https://github.com/github" title="github"><img src="https://github.com/github.png?size=64" alt="github" width="48" height="48" style="border-radius:50%; margin: 4px;" /></a>
  <a href="https://github.com/tjfred35" title="tjfred35"><img src="https://github.com/tjfred35.png?size=64" alt="tjfred35" width="48" height="48" style="border-radius:50%; margin: 4px;" /></a>
</p>

- 🎗️ Become a sponsor: https://github.com/sponsors/gpbl
