'use server';

/**
 * @fileOverview A flow that generates weekly and monthly inventory summaries using AI.
 *
 * - generateInventoryReport - A function that handles the generation of inventory reports.
 * - GenerateInventoryReportInput - The input type for the generateInventoryReport function.
 * - GenerateInventoryReportOutput - The return type for the generateInventoryReport function.
 */

import {ai} from '@/ai/genkit';
import {z} from 'genkit';

const GenerateInventoryReportInputSchema = z.object({
  reportType: z
    .enum(['weekly', 'monthly'])
    .describe('The type of inventory report to generate (weekly or monthly).'),
  inventoryData: z.string().describe('The current inventory data as a JSON string.'),
  pastInventoryData: z.string().optional().describe('The past inventory data as a JSON string for comparison.'),
});
export type GenerateInventoryReportInput = z.infer<typeof GenerateInventoryReportInputSchema>;

const GenerateInventoryReportOutputSchema = z.object({
  report: z.string().describe('The generated inventory report.'),
});
export type GenerateInventoryReportOutput = z.infer<typeof GenerateInventoryReportOutputSchema>;

export async function generateInventoryReport(input: GenerateInventoryReportInput): Promise<GenerateInventoryReportOutput> {
  return generateInventoryReportFlow(input);
}

const prompt = ai.definePrompt({
  name: 'generateInventoryReportPrompt',
  input: {schema: GenerateInventoryReportInputSchema},
  output: {schema: GenerateInventoryReportOutputSchema},
  prompt: `Anda adalah asisten AI yang berspesialisasi dalam membuat laporan inventaris untuk lab komputer.
Buat laporan dalam Bahasa Indonesia.

Anda akan menerima data inventaris saat ini dan jenis laporan yang akan dibuat (mingguan atau bulanan).
Jika data inventaris sebelumnya disediakan, Anda akan membandingkannya dengan data saat ini dan menyoroti perubahan serta tren utama.

Berdasarkan informasi ini, buat laporan inventaris yang ringkas dan informatif.

Jenis Laporan: {{{reportType}}}
Data Inventaris Saat Ini: {{{inventoryData}}}
{{#if pastInventoryData}}
Data Inventaris Sebelumnya: {{{pastInventoryData}}}
{{/if}}

Laporan:`,
});

const generateInventoryReportFlow = ai.defineFlow(
  {
    name: 'generateInventoryReportFlow',
    inputSchema: GenerateInventoryReportInputSchema,
    outputSchema: GenerateInventoryReportOutputSchema,
  },
  async input => {
    const {output} = await prompt(input);
    return output!;
  }
);
