import {
  Card,
  CardContent,
  CardDescription,
  CardHeader,
  CardTitle,
} from '@/components/ui/card';
import {
  Table,
  TableBody,
  TableCell,
  TableHead,
  TableHeader,
  TableRow,
} from '@/components/ui/table';
import { Badge } from '@/components/ui/badge';
import { inventory } from '@/lib/data';
import { addDays, format, isPast, differenceInDays } from 'date-fns';

const maintenanceSchedule: { assetId: string; checkIntervalDays: number }[] = [
  { assetId: '1', checkIntervalDays: 90 },
  { assetId: '2', checkIntervalDays: 90 },
  { assetId: '4', checkIntervalDays: 180 },
  { assetId: '5', checkIntervalDays: 365 },
];

export default function AlertsPage() {
  const upcomingChecks = maintenanceSchedule
    .map((schedule) => {
      const asset = inventory.find((a) => a.id === schedule.assetId);
      if (!asset || asset.lastMaintenance === 'N/A') return null;

      const lastCheck = new Date(asset.lastMaintenance);
      const nextCheck = addDays(lastCheck, schedule.checkIntervalDays);
      const daysUntil = differenceInDays(nextCheck, new Date());

      return {
        ...asset,
        nextCheckDate: format(nextCheck, 'yyyy-MM-dd'),
        daysUntil: daysUntil,
        isOverdue: isPast(nextCheck),
      };
    })
    .filter(Boolean)
    .sort((a, b) => (a?.daysUntil ?? 999) - (b?.daysUntil ?? 999));

  return (
    <Card>
      <CardHeader>
        <CardTitle className="font-headline">Peringatan Pemeliharaan</CardTitle>
        <CardDescription>
          Pengingat otomatis untuk pemeriksaan pemeliharaan komputer rutin.
        </CardDescription>
      </CardHeader>
      <CardContent>
        <Table>
          <TableHeader>
            <TableRow>
              <TableHead>Aset</TableHead>
              <TableHead className="hidden md:table-cell">
                Nomor Seri
              </TableHead>
              <TableHead>Pemeriksaan Berikutnya Jatuh Tempo</TableHead>
              <TableHead>Status</TableHead>
            </TableRow>
          </TableHeader>
          <TableBody>
            {upcomingChecks.map(
              (check) =>
                check && (
                  <TableRow key={check.id}>
                    <TableCell className="font-medium">{check.name}</TableCell>
                    <TableCell className="hidden md:table-cell">
                      {check.serialNumber}
                    </TableCell>
                    <TableCell>{check.nextCheckDate}</TableCell>
                    <TableCell>
                      {check.isOverdue ? (
                        <Badge variant="destructive">Terlambat</Badge>
                      ) : (
                        <Badge variant="outline">
                          {check.daysUntil} hari tersisa
                        </Badge>
                      )}
                    </TableCell>
                  </TableRow>
                )
            )}
          </TableBody>
        </Table>
      </CardContent>
    </Card>
  );
}
