'use client';

import Link from 'next/link';
import { usePathname } from 'next/navigation';
import { SidebarMenuItem, SidebarMenuButton } from '@/components/ui/sidebar';
import { Home, Computer, FileText, Bell, ScanLine } from 'lucide-react';

const navItems = [
  { href: '/dashboard', label: 'Dasbor', icon: Home },
  { href: '/inventory', label: 'Inventaris', icon: Computer },
  { href: '/reports', label: 'Laporan', icon: FileText },
  { href: '/alerts', label: 'Peringatan', icon: Bell },
];

export function AppNav() {
  const pathname = usePathname();

  return (
    <>
      {navItems.map((item) => (
        <SidebarMenuItem key={item.href}>
          <Link href={item.href} legacyBehavior passHref>
            <SidebarMenuButton
              asChild
              isActive={pathname.startsWith(item.href)}
              tooltip={item.label}
              className="justify-start"
            >
              <a>
                <item.icon className="h-5 w-5" />
                <span>{item.label}</span>
              </a>
            </SidebarMenuButton>
          </Link>
        </SidebarMenuItem>
      ))}
    </>
  );
}
