export type Asset = {
  id: string;
  name: string;
  serialNumber: string;
  type: 'Komputer' | 'Periferal' | 'Lainnya';
  status: 'Digunakan' | 'Disimpan' | 'Dalam Perawatan' | 'Dihapus';
  assignedTo?: string;
  purchaseDate: string;
  lastMaintenance: string;
  notes?: string;
};

export const inventory: Asset[] = [
  {
    id: '1',
    name: 'Dell OptiPlex 7080',
    serialNumber: 'SN-A1B2C3D4',
    type: 'Komputer',
    status: 'Digunakan',
    assignedTo: 'Stasiun Lab 1 / Baris 1',
    purchaseDate: '2023-01-15',
    lastMaintenance: '2024-06-01',
    notes: 'RAM ditingkatkan menjadi 32GB.',
  },
  {
    id: '2',
    name: 'HP EliteDesk 800 G6',
    serialNumber: 'SN-E5F6G7H8',
    type: 'Komputer',
    status: 'Digunakan',
    assignedTo: 'Stasiun Lab 1 / Baris 2',
    purchaseDate: '2023-01-15',
    lastMaintenance: '2024-06-01',
  },
  {
    id: '3',
    name: 'Logitech MX Master 3',
    serialNumber: 'SN-I9J0K1L2',
    type: 'Periferal',
    status: 'Disimpan',
    assignedTo: 'Lemari A / Baris 1',
    purchaseDate: '2023-05-20',
    lastMaintenance: 'N/A',
  },
  {
    id: '4',
    name: 'Apple MacBook Pro 16"',
    serialNumber: 'SN-M3N4O5P6',
    type: 'Komputer',
    status: 'Dalam Perawatan',
    assignedTo: 'Kantor Admin',
    purchaseDate: '2022-11-10',
    lastMaintenance: '2024-07-10',
    notes: 'Penggantian layar tertunda.',
  },
  {
    id: '5',
    name: 'Dell UltraSharp U2721DE',
    serialNumber: 'SN-Q7R8S9T0',
    type: 'Periferal',
    status: 'Digunakan',
    assignedTo: 'Stasiun Lab 1 / Baris 1',
    purchaseDate: '2023-01-15',
    lastMaintenance: 'N/A',
  },
  {
    id: '6',
    name: 'Lenovo ThinkPad X1 Carbon',
    serialNumber: 'SN-U1V2W3X4',
    type: 'Komputer',
    status: 'Dihapus',
    purchaseDate: '2020-03-01',
    lastMaintenance: '2023-08-15',
    notes: 'Didaur ulang karena kerusakan perangkat keras.',
  },
];

export const pastInventory = inventory.slice(0, 4).map(item => {
    if (item.id === '3') {
        return {...item, status: 'Digunakan', assignedTo: 'Stasiun Lab 2 / Baris 3'};
    }
    return item;
});

export const locations = [
  { value: 'Stasiun Lab 1 / Baris 1', label: 'Stasiun Lab 1 / Baris 1' },
  { value: 'Stasiun Lab 1 / Baris 2', label: 'Stasiun Lab 1 / Baris 2' },
  { value: 'Stasiun Lab 2 / Baris 1', label: 'Stasiun Lab 2 / Baris 1' },
  { value: 'Stasiun Lab 2 / Baris 2', label: 'Stasiun Lab 2 / Baris 2' },
  { value: 'Kantor Admin', label: 'Kantor Admin' },
  { value: 'Ruang Server', label: 'Ruang Server' },
  { value: 'Lemari A / Baris 1', label: 'Lemari A / Baris 1' },
  { value: 'Lemari A / Baris 2', label: 'Lemari A / Baris 2' },
]
